


var g_Kompass   = 0;
var g_Direction = 0;
var g_Distance  = 0;
var g_Height    = 0;
var g_Speed     = 0;
var g_Heading   = 0;

var g_ModelType = "";
var g_ModelTail = "";

var white = "#ffffff";
var red   = "#cc0000";

var MEASValue_GPSGroundDistance  =	11552; 
var MEASValue_GPSDistance = 		11553; 
var MEASValue_Rx_GPSRelAltitude = 	 9506; 
var MEASValue_Rx_GPS_Speed = 		 7427; 
var MEASValue_Rx_GPS_Course = 		 7429; 
var MEASValue_Rx_GPSDirection =		 7460; 
var MEASValue_Tx_Magnet_Course =	 7369; 

initPage();

function initPage(){
	$('#Soft_Shutdown').bind('click', function(){shutDown();});


	InitDataPostArgs = getCurrentModelName(InitDataPostArgs);
	GetTd(getModelConfigObject(InitDataPostArgs), g_InitEvent);



	var MEASValue_Array = [MEASValue_GPSGroundDistance, MEASValue_Rx_GPSRelAltitude, MEASValue_Rx_GPS_Speed, MEASValue_Rx_GPS_Course, MEASValue_Rx_GPSDirection, MEASValue_Tx_Magnet_Course];

	for(var i = 0; i < MEASValue_Array.length; i++){
		telemetryObj = new Object();
		telemetryObj.ID = MEASValue_Array[i];
		telemetryObj.Value = 0;
		telemetryObj.ValueStr = "";
		 	
		telemetryIds.push(telemetryObj);
	}

	setInterval(JsonFunction, 250);

	setInterval(updateLAF, 500);
}


function getModelConfigObject(InitDataPostArgs){
	if(typeof InitDataPostArgs == 'undefined'){
		InitDataPostArgs = new Object();
	}

  	ModelConfig = new Object();
  	ModelConfig.ModelName = "Default Model";

  		type = new Object();
  		type.Index = -1;
  		type.Name = "";
  	ModelConfig.Type = type;

  	modelTypeDependent = new Object();
  		tailType = new Object();
  		tailType.Index = -1;
  		tailType.Name = "";
  	modelTypeDependent.TailType = tailType;

  	ModelConfig.ModelTypeDependent = modelTypeDependent;
 	





	InitDataPostArgs.ModelConfig = ModelConfig;

	return InitDataPostArgs;
}



function onEVENT_INIT(e){
	try{
		checkHTMLHeader('Model_Name');
		setHTML('Model_Name', e.EventData.ModelName);

		g_ModelType = e.EventData.ModelConfig.Type.Name;
		g_ModelTail = e.EventData.ModelConfig.ModelTypeDependent.TailType.Index;

		drawFOVs();
		canvasInit(g_ModelType, g_ModelTail, g_Kompass, g_Direction, g_Distance, g_Heading);
	}catch(err){
		onError(err, "Error Init: ", false);
	}
}


function handleEventControl(cmd, e, key, value, valueStr){
	
	if(cmd == "telemetry"){
		if(key == MEASValue_GPSGroundDistance){
			setHTML('Distance_Value', valueStr);
			g_Distance = value / 10;
		}
		else if(key == MEASValue_Rx_GPSRelAltitude){
			setHTML('Height_Value', valueStr);

			if(value > 32767){
				g_Height = (value - 65536) / 10;
			}
			else{
				g_Height = value / 10;
			}
		}
		else if(key == MEASValue_Rx_GPS_Speed){
			setHTML('Speed_Value', valueStr);
			g_Speed = value * 0.1852;
		}
		else if(key == MEASValue_Rx_GPS_Course){
			setHTML('Heading_Value', valueStr);
			g_Heading = value / 100;
		}
		else if(key == MEASValue_Rx_GPSDirection){
			setHTML('Direction_Value', valueStr);
			g_Direction = value / 100;
		}
		else if(key == MEASValue_Tx_Magnet_Course){
			g_Kompass = value / 100;
		}
	}
}


function drawFOVs(){
	var fovc = document.getElementById('FOV_Canvas');
    var fov = fovc.getContext('2d');
    var sfov = fovc.getContext('2d');

    var lineColor = "rgba(0, 0, 0, 0.2)";

  
    fov.strokeStyle = lineColor;
	fov.lineWidth = 1;

	fov.beginPath();
	fov.moveTo(272, 188);
	fov.lineTo( -1, 179);
	fov.lineTo( -1,  -1);
	fov.lineTo(544,  -1);
	fov.lineTo(544, 179);
	fov.lineTo(272, 188);
	fov.closePath();
	fov.stroke();

    var grd = fov.createRadialGradient(272, 188, 1, 272, 188, 272);
    grd.addColorStop(1.00, 'rgba(255, 255, 255, 0.00)');
    grd.addColorStop(0.00, 'rgba(255, 255, 255, 0.08)');

    fov.fillStyle = grd;
    fov.fill();
  
    
  
    sfov.strokeStyle = lineColor;
	sfov.lineWidth = 1;

	sfov.beginPath();
	sfov.moveTo(272, 188);
	sfov.lineTo( 80, -4);
	sfov.lineTo(464, -4);
	sfov.lineTo(272, 188);
	sfov.closePath();
	sfov.stroke();

    var sgrd = sfov.createRadialGradient(272, 188, 1, 272, 188, 272);
    sgrd.addColorStop(1.00, 'rgba(255, 255, 255, 0.00)');
    sgrd.addColorStop(0.25, 'rgba(255, 255, 255, 0.05)');
    sgrd.addColorStop(0.00, 'rgba(255, 255, 255, 0.20)');

    sfov.fillStyle = sgrd;
    sfov.fill();
  
}


function canvasInit(ModelType, ModelTail, kompass, direction, distance, heading){
	W = 543;																								
	H = 375;																								

	canvas = Raphael("Radar_Canvas", W, H);

	var modelImage = "";

	var PATH_RADIUS = 100;
	PATH_RADIUS_UFO = 100;

	center = [272, 188];

	r1 = canvas.circle(center[0], center[1], PATH_RADIUS).attr({stroke: white, "stroke-width": "1px", opacity: 0});
	r2 = canvas.circle(center[0], center[1], PATH_RADIUS).attr({stroke: white, "stroke-width": "1px", opacity: 0});
	r3 = canvas.circle(center[0], center[1], PATH_RADIUS).attr({stroke: white, "stroke-width": "1px", opacity: 0});
	r4 = canvas.circle(center[0], center[1], PATH_RADIUS).attr({stroke: white, "stroke-width": "1px", opacity: 0});
	t1 = canvas.text(center[0], center[1],   "1m").attr({stroke: white, "stroke-width": "1px", x: 271, opacity: 0});
	t2 = canvas.text(center[0], center[1],  "10m").attr({stroke: white, "stroke-width": "1px", x: 271, opacity: 0});
	t3 = canvas.text(center[0], center[1], "100m").attr({stroke: white, "stroke-width": "1px", x: 271, opacity: 0});
	
	

	
	if(ModelTail == "Delta"){
		
		modelImage = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAALmSURBVHja7Ji9TxpxGMc57gCJikMroKZxaNDJdKBuHShDpw5I61YbWknp4lINIe4diP9AB8LSgfgXmBQZunQghJiQELGgQAELRsLxIm8Hv34v6SU2NcEcF3tJ7zvxXLiHzz2vv4MihKjkLLVK5lIAFUAF8C61tbX1bnt7e0eWcJOTk/pcLpcpFAoXBoPhvuwA19fXX5Df2tjYeC+7GnwJCZ/X1tacsoqeTqfTptPp70IE8/n8BVI+KxvAxcXFB+12+0oA7Pf7xGKxPJZNio1Go2liYkIv2AzD8NfmZAO4sLDwF4zJZJr7p2k1m82zm5ubrw8PDw+Ojo7SvV6PE1LMcdwwHo9nI5HIF7fb/XZ+ft58J1CYb1MOh+N5KBT6XKvVqgLQ8fFxpdVqdQUb9dhPpVIVwWZZtra/vx9yOp2OmZkZg6RQWq1WY7PZngQCgU+lUukHuUEA/Fmv1zuC3Wg0uplM5vKm756fn5eCwWDAbrc/5btfFBRFUSqr1frI7/d/RCSSZIROT08voea1iHVwrTrqvpOTk9Te3p5/dXXVSvE/OkpLS0sPvV7vh2g0+g111Ce3FKLCIrqsYJfL5WaxWGRve/9gMOBisVjU5/N5l5eXLX9AYTzoXC7Xq3A4fNDtdttEhBC9FvZw9dqgZiuVSlOMLzB00XhhNOAbPaTa3d11kzHFNwjSVRbsZDJ5cb0mxcrj8eyoMcPuSbDqmE6nwwk2UjZEZphx/aLj5yQZ1DRNqyGKB+NfY7FJaI1GQ0vgmjConzaKnCACjXEAMRd72MEDgJJqtXqFmtQOh0PRL93TED8NKMy5KTwxf8AU7QxgHErFmEgkviJy0ysrK8/Ozs4S8K0T6xNTR43tVJNsoCOKNGZfGpGr44ElO2oxUjlC/Q0Al0PD8Lv4UnaAvHhAjC6+OYayBETd5XCSltSnpM7wRldAY9BS+pTUGU4x/Ww2W8Toykvlk1L+H1QAFUAF8D8H/CXAAL+MV2wsur5tAAAAAElFTkSuQmCC";
	}
	else if(ModelType == "Plane"){
		if(ModelTail == 1){
			
			modelImage = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAQxSURBVHja7FhLSGNXGP6TmBgTp8ZozISIRqN1LNVKFwZbta0LGSwtFqFYKaIzixERKWKx0G7EnWuX2YjgUpFauqjShRsXCoqg8REzRae+ax7GmcSYO9+fJsWmWoz3dgwlP3zJuefcnHz3f58rEwSBklnklOSSIvi/J5hWW1tL8/PzZDKZKD8/n0pLS6m8vJxKSkrIarVSQ0NDZK2wsDAyv7Ky8m/7vb+/v+/D9+ZNN9TV1ZHD4aCdnR3a29ujmZkZcjqdtLm5Saurq+RyuWh3d5cmJyeptbWV0hJ9opaWFurr67t2bWxs7Lvl5WUXhgPXrev1etrY2EhMgxJaIx3a/kin01mampr+sTgxMRHRUsImvguTqakp6u7ujp82Q0MGuIUMYx3gvtcgmZ6eJq/XS0ajMQYjpmW5ubm6nJwcA0AMrVZLCwsLdw8SsU8YCASooKCAh3n8odFolNnZ2bkcKAqFIuLw955mmAg0lRkbK5VKNWeDZMiDeqAK+ALp4xOeCIfDQnNz8+cYfgq8A7wlKg/e4p4HgAlgOz4CygArXyMqzVlZWRwQtLa2dszfl5eX4c7OzicWi+Ubvj45OTl6AcHwN2ALWAccANt+H3h5G4IceQ+BfKAEKAfYRtatra1CRGeOXC5X3LQJSAkBdsaovITENBcNGENlZWXV1d9cXFwEj4+Pj55DcOkEOEGuAdsAP9BRjKAN1cFeVFRUrFarNVL4zW1aOPipChXKzKipqfnw6trZ2Zlv5c+S9bW8q6vrS5Swd8WQk8lkBA3Lrl6LkczMzAcg/UF9ff1ncrGbRSIN5BjQnMBBcpWs2F5BrlKpFFLsBAsomVwoFAojF6ZLlL7kaUtLSy/y8vKc/PAi9gr7fL5XxcXFeiaJyrGNDkUbDb67uo0cwX8Sy4XpIqGsrq7+mE0MoheI+krMqUTuqWYlchSz5gJizYHMEkkL5+fngWAw+AeGwaTpqLkWezyeM5g3dHp66gdZP5c8SaJE7Abo/yJdDcSLXP3K7XZ7kbj9krX8Yn6MZEt+/19c/NCiBxr0SGVeqTvqILTHBN3j4+N/W2hra3tzPmg2m2l0dDTSVlVUVFB/fz/Nzs5GDltMjjEwMEBoImhubo4GBweJy+3Q0BBlZGTc67GzanFxMYSuhq1iSYZzMSfh94BvgV9R2xdwjAyhzGnW19dXMfcj8CzaFb0ZGRkZYRObYGL74eHhnhAnPT09P/X29v4cPw8Tb8PEQzCx9prDljQaHB4e5iTMPtfW3t7+1GAwPIy/Bz2eAiSU8fM49Bf9ALHZbI95j46ODmk1x28cYrDb7d8L1wj+WMD6Vyh5T4UbpLGxsT122mPcyo8SfT+IxvZtnDBt8ZY4ODj4HZ3ML2VlZYTxYxyijNEyGmtiZQ6HYw6p0pWQo6deYKYIpgimCP638lqAAQBNKe0OXzIZogAAAABJRU5ErkJggg==";
		}
		else{
			
			modelImage = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAARgSURBVHja7JhLSGtXFIZXTo6P+Lr2qjemJte3JlbEKgVtVerEgl4VdFZwKrQXdNKAA6HgtHQkRcEOxKkOpKITBQfFV0tRcWAK1qL1qk3qIw9jNI/Tf50mktsmYG6OEoobFmefnOM+397rX2uvrUqSJErkJlCCtyfA/z2guLCwQO3t7RQIBP7zkANIpVL9MxNBoJ2dHWpsbJT7kdrQ0NCny8vLZ0tLSzvRPlhZWUldXV10dnZGmZmZJIoieTwe0ul0tL29TYWFhWSz2WRjNvG+M2HY4uJi6uvro83NTUpKSnrrOU+wtbX1C5fL9QcAv4o0RnJyMpWVlZHP51PexQyYkZFBIyMjlJubK6+Aw+G4M7/fn1JTU/MJWmukcRmOPZWVlRXRW4pokAfOy8uj8fFxeQX39vbo8PBQNrVabUhPT3+/qKjIgP6L8L9jmXR0dFB9fT3d3Nw8bJAwpF6vp5mZGaqoqKCrqyu6vb2lgoKCl8wCLb2Hpg+9zxPp7Owkg8Ega+1Ropghy8vLaXZ2lurq6uTfAFjAVwhfhAS0oXe7u7vliXi93sdNMwzJETc/P0+1tbXs4uehFUtNTX3GmuNohctjdutbaSaeHMWQOTk5mrm5OZ3FYqkIBVNDQ4MJEW3A7Snc6mUJsDEoGwKK7lsD3BcwFaaDFUPwJlzZGIhdqX2OVlpaKgsMrgwMDAx8aTKZzJeXlzZo9E+73X5itVot5+fnuxqN5lfk0d8BagW0j1PO9fW1LAHu86TD4cWwGzVLCJYPiDKGwNXIhn4R7EW0CfHAnmAEcMTiY350U7Kzs/VsLM+qqqpX/Lynp4dX0APoUwDvIyFbjo+PdwG8i9S1n5aW9hfGcN4F1OLi4meAXIbtwS6kd2gMdHBwYOc+PuTf2tqyvcs4APe53W7bycmJZWNj44fq6mqTWFJS8i04P1Bq7+QVDG2PMUesIKghgVy2/Pz8ysHBQUnAYGoFoFRSUCt8jbZXxxzBopgtKDEYUowK4paCepRwLyjkDUmEz+Uoirf0dzqdvIpyFANSiHdMlgkCRVRptdpGzPglazQOPm9bW9uHk5OTXwM00NTUZEZ07seTZ1l6WDyrYoVlS0vLR6w/RKAPqaI24SpqlFxujhEkZzcS8HXCAV5cXJxjAW8ZEBp0JBwgwJwIDCykw4Vbl2JnEqUGgqDdWEU7Sn52tSfhAOHWAFaRARnOm3AuxlklAyt4Axf7SMEWNyA2eCOC4/Xw8PDG0dFRMqqUZ6urqz/29/d/jhJM9+gH6d7eXjWA2mHfByuguzYxMbEO0J/Cf0Mhuzk2NvYN58lHAZyamnodrVwaHR392Ww2/xLtudFo/PjBgwQnNm20ZysrK8fYNlOiPce5mgvh1QcFXFtb43L9t1B1Fdw3hfX19TfT09PDXLM2Nzd/h5Ndafj+znsrKmhnzHtyrBUHPqTBRR8h2Dg5vwne8wkvj89V/3rnFN+zPyjg07/fngCfABOs/S3AAGHo+UOziN3dAAAAAElFTkSuQmCC";
		}
	}
	else if(ModelType == "Glider"){
		if(ModelTail == 1){
			
			modelImage = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAI/SURBVHja7Ji9axphHMc9jZ5nK31LpVgko0NA3dThoDRKhS4dOluHGwQRB/8DF+nSpfofSCDQQRy6diiouDQEdG9wCAbN3ZnEe/Ou30daSCFL7dPwFO4DD/eGD5/7PS+/38k5juNhGa+HcVxBV9AV/N8FqSJJ0jtRFF8yG8FSqSQVCoW3NPvcofamXi8XjUafoS2YjGAwGBQegIeAScEACIVCAlqIScErYBjGWtM0m6Ygd/MiEonsPgb3AIkEOYbD4fvkUhA2wSH3BQKGNIig8Tj4Mf/8Pp/Pn06nX8myvJpMJl/Q3dqyLBPSBqR1tBXQrm9AXuoS4LA5J8xms3NFUdTfLJPJ5H632/00n8/PSX8owWznjrFtm0T/ejqdnrZarY+I05ONXCqV2scDxWGMbwDr7dFONpt93el0js+AaZr6XxSwdi6XEzFEygnYdn5zADOIj8VizxOJxAHVvbDX632u1+sfKK6RAHlLi1ZvmNwXWAiXFAUNqqlusVhcqKoqM5uLIaeSrYJZweVyeUX2N2YF4bbSdV1jVhALRMdWZTIriNRmkPTGsqC1BswKIo+THG4zKwg2eZR1Qaodctv+MJ/PvyiXy2/i8fjTnzne02w2ZdSOfLVa5ck9TEm73+9/b7fbh+PxeHJnn5eVSkW6rURCZdSs1WqHtz3LZDLiVl912wxJsVgMNxqNI1I1/5oqo9HoeDAYvB8OhwFE7hTV+R4pwUj/iK6X5/k9nH/94yF2/8B0BV1BV/Df8kOAAQBv4k46eX13lQAAAABJRU5ErkJggg==";
		}
		else{
			
			modelImage = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACgAAAAoCAYAAACM/rhtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJHSURBVHja7Jg/ixpRFMVndF0dE01MogQXYyssqJ0IsUmMCmnTR4JltPFjCGniR7CSFGKxrZAu1boLMViYQLAIrrrOuLvOP2dyrixhs1UwD/MCc+AyjsKb37tz37vnKdq2LfAsl8C5HEAH0AH83wGZqlKpvM7lcs+4zWC5XK6USqVXLMfcYzZTl0uMRqOPEXMuM+jz+aR70H2IS8B9yO/3Swg/l4CXkK7ra1VVLZaA4s2bSCTy6AF0B6JM0DUQCNylW0naJIe+l0h4pT4kzYuLB/XncbvdnkwmU1wsFqvBYNDDcGvTNA1A64DWECtIvbohmtQFhMvmM2kymZzJsqz8RplKpQ47nc6H2Wx2RuPBgln2jmVZFmX/ajwef282m++Rp4cbuHQ6fYgfZJszHUNYb6G9bDb7stVq9X9AhmFof2FgrXw+n8Mrkk+hbetbhFBB3lgsdpBMJp8z3Qu73e5RvV5/x3CN7NMsTVajobjPsRAuGALqTFvdfD4/VxRlwW0vBpxCWwW3gMvl8pL2N24BwbbSNE3lFhALRMNWZXALiNamU3vjGdBcQ9wCoo9TD7e4BYQ2fZQbwFqt9nY0Gn1GGx/BYh3Dfj0tFotvhsPhKXry136//6lQKLz4Jyc4PDh/24FUq9WPjUbj5LaTgp1L7fzQFI/HD9rtdnc6neowqSJFr9f7EgwGBfjKb3Q0CYVCQjgc9iYSiScn0FbuZtuSgSv65TgQHrJbtE7ISSMkhPvaiKjXxSnsFND568MBdAAdwD/TTwEGAGFcTr7A2jqpAAAAAElFTkSuQmCC";
		}
	}
	else if(ModelType == "Helicopter"){
		
		modelImage = "";
	}
	else{
		
		modelImage = "";
	}

	ufo = canvas.image(modelImage, (center[0] - 20), (center[1] - PATH_RADIUS_UFO - 20), 40, 40);
	

	updateBATKompass(0);
	updateUFOPosition(0, 0);
	updateUFOHeading(0, 0);
	updateUFODistance(0);
}


function updateLAF(){
	
	
	
	
	
	








	
	


	





	
	

	updateBATKompass(g_Kompass);
	updateUFOPosition(g_Kompass, g_Direction);
	updateUFOHeading(g_Kompass, g_Heading);
	updateUFODistance(g_Distance);
}







function updateBATKompass(kompassAngle){
	if(kompassAngle > 359){
		kompassAngle -= 360;
	}

	var newValue = kompassAngle * (-3);
	setCSS('slider', 'margin-left', newValue + 'px');
}


function updateUFOPosition(kompassAngle, directionAngle){
	var batKompassAngle = directionAngle;

	directionAngle += 270;
	var directionRad = directionAngle * (Math.atan(1) / 45);

	var newX = Math.round((Math.cos(directionRad) * PATH_RADIUS_UFO) + center[0] - 20);
	var newY = Math.round((Math.sin(directionRad) * PATH_RADIUS_UFO) + center[1] - 20);

	ufo.attr({x: newX, y: newY});

	if(batKompassAngle < 0){
		batKompassAngle += 360;
	}

	if(batKompassAngle > 180){
		batKompassAngle -= 360;
	}

	var batKompassValue = (batKompassAngle * 3) + 266;

	if(batKompassValue < -5){
		batKompassValue = -5;
	}
	else if(batKompassValue > 535){
		batKompassValue = 535;
	}

	setCSS('needle_bat', 'left', batKompassValue + 'px');
}


function updateUFOHeading(kompassAngle, headingAngle){
	headingAngle -= kompassAngle;

	ufo.transform("r" + headingAngle);
}


function updateUFODistance(distance){
	if(distance < 1){
		r4.attr({opacity: 0});
		r3.attr({opacity: 0});
		r2.attr({opacity: 0});
		r1.attr({opacity: 0});
		t3.attr({opacity: 0});
		t2.attr({opacity: 0});
		t1.attr({opacity: 0});
	}
	else{
		r4.attr({opacity: 1});
		r3.attr({opacity: 1});
		r2.attr({opacity: 1});
		r1.attr({opacity: 1});
		t3.attr({opacity: 1});
		t2.attr({opacity: 1});
		t1.attr({opacity: 1});

		if(distance <= 10){
			r4.attr({r: (2500/distance)});
			r3.attr({r: (1000/distance)});
			r2.attr({r: (500/distance)});
			r1.attr({r: (100/distance)});
			
			t3.attr({text: "10m", y: 195 + (1000/distance)});
			t2.attr({text:  "5m", y: 195 + (500/distance)});
			t1.attr({text:  "1m", y: 195 + (100/distance)});
		}
		else if(distance <= 50){
			r4.attr({r: (10000/distance)});
			r3.attr({r: (5000/distance)});
			r2.attr({r: (2500/distance)});
			r1.attr({r: (1000/distance)});
			
			t3.attr({text: "50m", y: 195 + (5000/distance)});
			t2.attr({text: "25m", y: 195 + (2500/distance)});
			t1.attr({text: "10m", y: 195 + (1000/distance)});
		}
		else if(distance <= 100){
			r4.attr({r: (25000/distance)});
			r3.attr({r: (10000/distance)});
			r2.attr({r: (5000/distance)});
			r1.attr({r: (1000/distance)});
			
			t3.attr({text: "100m", y: 195 + (10000/distance)});
			t2.attr({text:  "50m", y: 195 + (5000/distance)});
			t1.attr({text:  "10m", y: 195 + (1000/distance)});
		}
		else if(distance <= 500){
			r4.attr({r: (100000/distance)});
			r3.attr({r: (50000/distance)});
			r2.attr({r: (25000/distance)});
			r1.attr({r: (10000/distance)});
			
			t3.attr({text: "500m", y: 195 + (50000/distance)});
			t2.attr({text: "250m", y: 195 + (25000/distance)});
			t1.attr({text: "100m", y: 195 + (10000/distance)});
		}
		else if(distance <= 1000){
			r4.attr({r: (250000/distance)});
			r3.attr({r: (100000/distance)});
			r2.attr({r: (50000/distance)});
			r1.attr({r: (10000/distance)});
			
			t3.attr({text: "1km",  y: 195 + (100000/distance)});
			t2.attr({text: "500m", y: 195 + (50000/distance)});
			t1.attr({text: "100m", y: 195 + (10000/distance)});
		}
		else if(distance <= 5000){
			r4.attr({r: (1000000/distance)});
			r3.attr({r: (500000/distance)});
			r2.attr({r: (250000/distance)});
			r1.attr({r: (100000/distance)});
			
			t3.attr({text: "5km",   y: 195 + (500000/distance)});
			t2.attr({text: "2.5km", y: 195 + (250000/distance)});
			t1.attr({text: "1km",   y: 195 + (100000/distance)});
		}
		else if(distance <= 10000){
			r4.attr({r: (2500000/distance)});
			r3.attr({r: (1000000/distance)});
			r2.attr({r: (500000/distance)});
			r1.attr({r: (100000/distance)});
			
			t3.attr({text: "10km", y: 195 + (1000000/distance)});
			t2.attr({text:  "5km", y: 195 + (500000/distance)});
			t1.attr({text:  "1km", y: 195 + (100000/distance)});
		}
		else if(distance <= 5000){
			r4.attr({r: (10000000/distance)});
			r3.attr({r: (5000000/distance)});
			r2.attr({r: (2500000/distance)});
			r1.attr({r: (1000000/distance)});
			
			t3.attr({text: "50km", y: 195 + (5000000/distance)});
			t2.attr({text: "25km", y: 195 + (2500000/distance)});
			t1.attr({text: "10km", y: 195 + (1000000/distance)});
		}
		else if(distance <= 100000){
			r4.attr({r: (25000000/distance)});
			r3.attr({r: (10000000/distance)});
			r2.attr({r: (5000000/distance)});
			r1.attr({r: (1000000/distance)});
			
			t3.attr({text: "100km", y: 195 + (10000000/distance)});
			t2.attr({text:  "50km", y: 195 + (5000000/distance)});
			t1.attr({text:  "10km", y: 195 + (1000000/distance)});
		}
	}
}
