#!/bin/bash -e

# globale Funktionen inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

is_logopt=true

$(create_logfile)

bat_log "Launching startup scripts"

function on_exit
{
	# Am Ende lösche das temporäre Updateverzeichnis

	rm -Rf "$UPDATE_TMP_DIR"
	
	bat_log 'Starting daemons'
	#	Operationen sind durch, daemons starten
	daemons_on
	#gpe-dm
	#echo 100 > /sys/devices/pwm-backlight.12/backlight/pwm-backlight.12/brightness
	#exec gpe-mini-browser2
}

###############################################################################
##		Suche nach Updatearchiv
##		
bat_log 'Looking for update file'

tmp_dir="$TMP_DIR"

UPDATE_TMP_DIR="$tmp_dir/update_tmp"
mkdir -p "$UPDATE_TMP_DIR"
export UPDATE_TMP_DIR

updt_dev=$(find_update_dev)
tx_ver=$(get_transmitter_version)
updt_file_archiv=$(find_update_file $updt_dev "EN" $tx_ver)

if [ ! -e "$updt_file_archiv" ] ; then
	bat_log 'No update archiv: ' "$updt_file_archiv"
	on_exit
	exit 0
fi

bat_log "Found update file: $updt_file_archiv"

tar -zxvf $updt_file_archiv -C "$UPDATE_TMP_DIR" > /dev/null 2>&1			# entpacken

#updt_files_dir=$(find_update_dir)
UPDATE_FILES_DIR="$UPDATE_TMP_DIR/$WEATRONIC_FOLFER/update"
SERVICE_FILES_DIR="$UPDATE_TMP_DIR/$WEATRONIC_FOLFER/service"
updt_files_dir="$UPDATE_FILES_DIR"

export UPDATE_FILES_DIR
export SERVICE_FILES_DIR

bat_log "Update folder: $updt_files_dir"

#exit 0


# Führe erstmal ein Service "VOR"-Skript
script_before="$SERVICE_FILES_DIR/$FILENAME_SCRIPT_BEFORE"
if [ -e "$script_before" ] ; then
	bash "$script_before"
fi

#finde, welche Dateien es zum update gibt
linx_files=$(ls $updt_files_dir | grep "$LINUX_UPDT_FILENAME")
linx_files=$(echo $linx_files)

bat_log 'Getting Linux update files versions'

#	fuer Linuxdateien entferne Linuxupdatedateinamen, _V- und .tar.gz-Zeichenketten#
#	um Versionsnummern von Dateien zu bekommen
linx_ver=$(echo $linx_files | sed "s/$LINUX_UPDT_FILENAME//g" | sed "s/['_V''.tar.gz']//g")
linx_ver=$(echo $linx_ver)

bat_log 'Stopping daemons'

#	Daemons beenden
daemons_off
#killall gpe-dm

###############################################################################
##		LINUX-UPDATE
##		ACHTUNG !	Nach dem Finden der Update-Datei wird diese entfernt
##

bat_log 'Getting Linux update files'

if [ ! -z "$linx_ver" ] ; then
	
	bat_log 'Linux version found'

	SAVE_IFS=$IFS
	IFS=' ' read -a linx_ver <<< "$linx_ver"									# String in Array splitten
	IFS=$SAVE_IFS

	#bat_log 'Finding last available linux version'

	#	höchste Version finden 
	tmp_version=0
	for element in "${linx_ver[@]}"
	do
	    if [ $tmp_version -lt $element ] ; then
	    	tmp_version=$element
	    fi
	done

	bat_log 'Determining archiv file name'	

	linux_archive=$LINUX_UPDT_FILENAME'_V'$tmp_version'.tar.gz'
	
	####################### Update ################################
	
	#	Pruef, ob eine Datei u.d. update Verzeichnis existiert
	if [ -e $updt_files_dir/$linux_archive ] ; then
		bat_log 'File exists. Starting linux update script'
		#	Archiv entpacken und notwendige Teile aktualisieren
		bash "$BAT_SCRIPTS/update_files/update.sh" -xf "$updt_files_dir/$linux_archive"
	fi
fi	#	! -z "$linx_ver"

###############################################################################
##		FIRMWARE-UPDATE
##

bat_log 'Getting into Firmware-phase'
bash "$BAT_SCRIPTS/update_files/fw_update.sh" "$updt_files_dir"			# -uf 

###############################################################################
##		u-boot
##
bat_log 'Reading u-boot bootmode var'
bootmode=$(get_uboot_bootmode)
bat_log "U-boot bootmode var is $bootmode"
if [ "$bootmode" = "$UBOOT_BOOTMODE_HAVETRIED" ] ; then
	set_uboot_bootmode "$UBOOT_BOOTMODE_NORMAL"									# war Update, nächstes Mal normal booten
fi

if test -e "$ROOTFS_WRITTEN_FLAG_FILE" ; then
	bat_log "Root-FS flash update flag file found"
	rm -f "$ROOTFS_WRITTEN_FLAG_FILE"
fi

###############################################################################
# Führe zu Ende ein Service "NACH"-Skript
script_after="$SERVICE_FILES_DIR/$FILENAME_SCRIPT_AFTER"
if [ -e "$script_after" ] ; then
	bash "$script_after"
fi

on_exit
