/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Seitenspezifisch~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/		
var g_GET_Parameter = get_GET_Parameter();
var g_lastURL = g_GET_Parameter.LastURL;
var g_Wizard = g_GET_Parameter.Wizard;
var g_GroupTagObj = {};
var g_VoltageTagObj = {};
	
initPage();
	
function initPage(){
	if(g_Wizard){
		showDialogbox("wizard", "wizardStep6", "", 5);
		hideHTML('Navi_Box');
		hideHTML('Option_Box');
		showHTML('Wizard_Box');
	}

	$('#Additional_Button').bind("click", function(){gotoServoSync();});
//Alte XML Daten beschaffen
	//Popups
	InitDataPostArgs = getNumPadLimitObj(InitDataPostArgs, "Control");
	InitDataPostArgs = getNumPadLimitObj(InitDataPostArgs, "Servo");
	InitDataPostArgs = getPopupObj(InitDataPostArgs, "ServoFrameRate");
	InitDataPostArgs = getPopupObj(InitDataPostArgs, "ServoGroupsUser");
	//Popups End
	InitDataPostArgs = getCurrentModelName(InitDataPostArgs);
	InitDataPostArgs = getModelConfigObject(InitDataPostArgs);
	GetTd(getServoConfigObject(InitDataPostArgs), g_InitEvent);
//XML Daten Ende	
		
	setInterval(JsonFunction, 250);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~JSON-Object constructor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//create and returns Model Configuration object
function getModelConfigObject(InitDataPostArgs){
	if(typeof InitDataPostArgs == 'undefined'){
		InitDataPostArgs = new Object();
	}
	
  	ModelConfig = new Object();

  		type = new Object();
  		type.Index = -1;
  		type.Name = "";
  	ModelConfig.Type = type;
  	
 	InitDataPostArgs.ModelConfig = ModelConfig;
	
	return InitDataPostArgs;
}

//create and returns Servo object
function getServoConfigObject(InitDataPostArgs){
	if(typeof InitDataPostArgs == "undefined"){
		InitDataPostArgs = new Object();
	}
	
	Item = new Object();
	Item.Index = 0;
	Item.Plug = "";
	Item.NormalName = "";
	Item.IsCreatedAuto = -1;
	
		group = new Object();
		group.Index = -1;
		group.Name = "";
	Item.Group = group;
	
	Item.MaxValueStr = "";
	Item.MinValueStr = "";
	Item.CenterStr = "";
	Item.IsGizmo = -1;
		
		voltage = new Object();
		voltage.Index = -1;
		voltage.Name = "";
	Item.Voltage = voltage;
		
		frameRate = new Object();
		frameRate.Index = -1;
		frameRate.Name = "";
	Item.FrameRate = frameRate;

		isSlave = new Object();
		isSlave.Index = -1;
		isSlave.Name = "";
	Item.IsSlave = isSlave;
	
		isReverse = new Object();
		isReverse.Index = -1;
		isReverse.Name = "";	
	Item.IsReverse = isReverse;
		
	servoItems = new Array(Item);
		
	Servos = new Object();
	Servos.Item = servoItems;
	
	Servos.ItemCount = 0;
	Servos.Items = "ALL_USED";
	
	InitDataPostArgs.Servos = Servos;
	
	return InitDataPostArgs;	
}

//PopupList
function getServoGroupPopupObj(ServoIdx){
	if(typeof ServogroupDataPostArgs == 'undefined'){
		ServogroupDataPostArgs = new Object();
	}
	
	if(typeof ServogroupDataPostArgs.PopUp == 'undefined'){
		ServogroupDataPostArgs["PopUp"] = {};
	}
	
	ServogroupDataPostArgs["PopUp"]["ServoGroupsUser"] = {}
	ServogroupDataPostArgs["PopUp"]["ServoGroupsUser"]["ServoIdx"] = ServoIdx;
	ServogroupDataPostArgs["PopUp"]["ServoGroupsUser"]["Items"] = [];
	
	return ServogroupDataPostArgs;
}


function getServoVoltagePopupObj(ServoIdx){
	if(typeof ServovoltageDataPostArgs == 'undefined'){
		ServovoltageDataPostArgs = new Object();
	}
	
	if(typeof ServovoltageDataPostArgs.PopUp == 'undefined'){
		ServovoltageDataPostArgs["PopUp"] = {};
	}
	
	ServovoltageDataPostArgs["PopUp"]["ServoVoltage"] = {}
	ServovoltageDataPostArgs["PopUp"]["ServoVoltage"]["ServoIdx"] = ServoIdx;
	ServovoltageDataPostArgs["PopUp"]["ServoVoltage"]["Items"] = [];
	
	return ServovoltageDataPostArgs;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~EVENT-Handler~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//EVENT-Handler INIT
function onEVENT_INIT(e){
	try{
		//Listener
		  if(typeof g_lastURL != "undefined"){
			  $('#Graphic_View_Button').removeAttr("href");
			  $('#Graphic_View_Button').bind("click", function(){
				  window.location.href = "1.3.1__ServoConfigurationGraphicView.html?LastURL=" + g_lastURL;
			  });
			  $('#Navi_Button').removeAttr("href");
			  $('#Navi_Button').bind("click", function(){
				   window.location.href = g_lastURL;
			  });
		  }
		  
		if(!(e.EventData.ModelConfig.Type.Index == 0) && !(g_Wizard)){
			showHTML('Toggle_Buttons');
		}
		  
		$('#Model_Name').html(e.EventData.ModelName);
		g_numpadLimitObj = e.EventData.NumPadLimits;
	
		var ItemCount = e.EventData.Servos.ItemCount;

		var htmlOuterContainer = "";

		for(i = 0; i < ItemCount; i++){
			htmlOuterContainer += '<div id="Container_' + i + '" style="width: 803px;"></div>';
		}

		setHTML('scrollContainerInnerVertical', htmlOuterContainer);

		//var controlIds = new Array();
		for(i = 0; i < ItemCount; i++){
			Index         = e.EventData.Servos.Item[i].Index;
			Plug          = e.EventData.Servos.Item[i].Plug;
			Name          = e.EventData.Servos.Item[i].NormalName;
			Group         = e.EventData.Servos.Item[i].Group.Name;
			MaxValue      = e.EventData.Servos.Item[i].MaxValueStr;
			MinValue      = e.EventData.Servos.Item[i].MinValueStr;
			Voltage       = e.EventData.Servos.Item[i].Voltage.Name;
			FrameRate     = e.EventData.Servos.Item[i].FrameRate.Name;
			IsCreatedAuto = e.EventData.Servos.Item[i].IsCreatedAuto;
			isSlave       = e.EventData.Servos.Item[i].IsSlave.Index;
			isGizmo		  = e.EventData.Servos.Item[i].IsGizmo;
			
//			if(isSlave){
//				CenterReverse = e.EventData.Servos.Item[i].IsReverse.Name;
//			}
//			else{
				CenterReverse = e.EventData.Servos.Item[i].CenterStr;
//			}

			setHTML('Container_' + i, getRowOfServoConfigsList(Index, Plug, Name, Group, MinValue, MaxValue, CenterReverse, Voltage, FrameRate, IsCreatedAuto, isSlave, isGizmo));	

			g_popupList_Indices["Servo__" + Index + "_Group"] = e.EventData.Servos.Item[i].Group.Index;
			$("#Servo__" + Index + "_Group").bind("click", function(){getServoGroupPopupList(this);});
			
			g_popupList_Indices["Servo__" + Index + "_Voltage"] = e.EventData.Servos.Item[i].Voltage.Index;
			$("#Servo__" + Index + "_Voltage").bind("click", function(){getServoVoltagePopupList(this);});
			
			g_popupList_Indices["Servo__" + Index + "_FrameRate"] = e.EventData.Servos.Item[i].FrameRate.Index;
			$("#Servo__" + Index + "_FrameRate").bind("click", function(){showPopupList(this, e.EventData.PopUp.ServoFrameRate, false, true, g_popupList_Indices);});
			
//			if(isSlave){
//				g_popupList_Indices["Servo__" + Index + "_Reverse"] = e.EventData.Servos.Item[i].IsReverse.Index;
//				$("#Servo__" + Index + "_Reverse").bind("click", function(){showPopupList(this, g_List_PopupListObj["YesNo"], false, true, g_popupList_Indices);});
//			}
		}

		if(typeof init == "undefined"){
			init = true;
		}

		if(init){
			initScrollbarsSCL();
			init = false;
		}
		else{
			ScrollRefresh();
		}
	}catch(err){
		onError(err, "Error Init: ", false);
	}
}

//EVENT-Handler Setdata
function onEVENT_SET(e){
	try{
		if(typeof e.EventData.PopUp != "undefined"){
			if(typeof e.EventData.PopUp.ServoGroupsUser != "undefined"){
				showPopupList(g_GroupTagObj["Servo__" + e.EventData.PopUp.ServoGroupsUser.ServoIdx + "_Group"], e.EventData.PopUp.ServoGroupsUser.Items, false, true, g_popupList_Indices);
			}
			else if(typeof e.EventData.PopUp.ServoVoltage != "undefined"){
				showPopupList(g_VoltageTagObj["Servo__" + e.EventData.PopUp.ServoVoltage.ServoIdx + "_Voltage"], e.EventData.PopUp.ServoVoltage.Items, false, true, g_popupList_Indices);
			}
		}
		else if(typeof e.EventData.set.ServoConfig.Group != "undefined" || typeof e.EventData.set.ServoConfig.Voltage != "undefined"){
			GetTd(InitDataPostArgs, g_InitEvent);
		}
	}catch(err){
		onError(err, "Error Setdata: ", false);
	}	
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~HTML-constructor~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Create and return HTML-Code for one Row of Function-List 
function getRowOfServoConfigsList(Index, Plug, Name, Group, MinValue, MaxValue, CenterReverse, Voltage, FrameRate, IsCreatedAuto, isSlave, isGizmo){
	if(IsCreatedAuto){
		classGraphicViewEdit = "no_edit";
	}
	else{
		classGraphicViewEdit = "";
	}
	
	if(isSlave){
		styleCenterReverse = 'no_edit';
		htmlCenterReverse = '<div id="Servo__' + Index + '_Reverse" class="list_servo_cr ' + styleCenterReverse + '">' + CenterReverse + '</div>';
	}
	else{
		styleCenterReverse = "";
		htmlCenterReverse = '<div id="Servo__' + Index + '_Center" class="list_servo_cr ' + classGraphicViewEdit + '" onClick=\'showNumpad("Servo__' + Index + '_Center", "Servo", false, true);\'>' + CenterReverse + '</div>';
	}
	
	if(isGizmo){
		classVoltage = "";
	}
	else{
		classVoltage = "no_edit";
		Voltage= "--";
	}
	
	var htmlInnerContainer = '' +
		'<div class="list_content_row">' +
			'<div id="Servo__' + Index + '_Plug"  class="list_servo_plug">' + Plug + '</div>' +
			'<div id="Servo__' + Index + '_Name"  class="list_servo_name ' + classGraphicViewEdit + '" onClick=\'showKeypad("Servo__' + Index + '_Name");\'>' + Name + '</div>' +
			'<div id="Servo__' + Index + '_Group" class="list_servo_group ' + classGraphicViewEdit + '">' + Group + '</div>' +
//			'<script type="text/javascript">' +
//				'if(typeof ServoGroupValues == "undefined"){' +
//					'ServoGroupValues = new Array ("M-A", "S-A", "--");' +
//				'}' +
//				'$("#Servo__' + Index + '_Group").bind("click", function(){showPopupList(this,ServoGroupValues,false,false,g_popupList_Indices);});'+
//			'</script>' +
			htmlCenterReverse +
			'<div id="Servo__' + Index + '_MinValue" class="list_servo_limit ' + classGraphicViewEdit + ' ' + styleCenterReverse + '" onClick=\'showNumpad("Servo__' + Index + '_MinValue", "Servo", true, true);\'>' + MinValue + '</div>' +
			'<div id="Servo__' + Index + '_MaxValue" class="list_servo_limit ' + classGraphicViewEdit + ' ' + styleCenterReverse + '" onClick=\'showNumpad("Servo__' + Index + '_MaxValue", "Servo", true, true);\'>' + MaxValue + '</div>' +
			'<div id="Servo__' + Index + '_FrameRate" class="list_servo_info ' + classGraphicViewEdit + '">' + FrameRate + '</div>' +
			'<div id="Servo__' + Index + '_Voltage" class="list_servo_info ' + classGraphicViewEdit + ' ' + classVoltage + '">' + Voltage + '</div>' +
		'</div>';
		
	return htmlInnerContainer;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Set Function~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/		
function getControlAssignmentPath(value, Index){
	cmd = "set";
	ModelName = "DefaultModel";
	ListType = "Function";
	str = encodeURI('{"' + cmd + '":{"' + ModelName + '":{"' + ListType + '":{"Control":"' + value + '","Index":' + Index + '}}}}');
	
	return str;
}


function getAttrObj(tagId, value, completeTagId){
	Attribute = new Object();
	
	if(tagId == "Name"){
		Attribute["Name"] = value;
		
		return Attribute;
	}
	
	if(tagId == "Group"){
		Attribute["Group"] = value;

		return Attribute;
	}
	
	if(tagId == "Center"){
		Attribute["Centre"] = value;
		
		return Attribute;
	}
	
	if(tagId == "Reverse"){
		Attribute["IsReverse"] = value;
		
		return Attribute;
	}
	
	if(tagId == "MinValue"){
		Attribute["MinValue"] = value;

		if(numpadIsTestActive){
			handleTest(completeTagId, value);
			
			return false;
		}
		
		return Attribute;
	}
	
	if(tagId == "MaxValue"){
		Attribute["MaxValue"] = value;

		if(numpadIsTestActive){
			handleTest(completeTagId, value);
			
			return false;
		}
		
		return Attribute;
	}
	
	if(tagId == "FrameRate"){
		Attribute["FrameRate"] = value;
		
		return Attribute;
	}
	
	if(tagId == "Voltage"){
		Attribute["Voltage"] = value;
		
		return Attribute;
	}

	return Attribute;
}


function getPathObj(cmd, ModelName){
	xmlObj = {};
	xmlObj[cmd] = {};
	xmlObj[cmd][ModelName] = {};
	
	return xmlObj;
}


function submitSET(tagId, value){
	ModelName = "model-settings";
	ListType = "ServoConfig";
	
	completeTagId = tagId;
	tagIdArray = tagId.split("__");
	cmd = "set";
	tagIdArray = tagIdArray[1].split("_");
	Index = parseInt(tagIdArray[0]);
	tagId = tagIdArray[1];
	
	Attr = new Object();
	Attr = getAttrObj(tagId, value, completeTagId);
	
	xmlObj = getPathObj(cmd, ModelName);
	xmlObj[cmd][ModelName][ListType] = {};
	xmlObj[cmd][ModelName][ListType] = Attr;
	xmlObj[cmd][ModelName][ListType]["Index"] = Index;

	if(Attr != false){
		GetTd(xmlObj, g_SetEvent, cmd);
	}
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Specific Function~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function gotoServoSync(){
	if(g_Wizard){
		location.href = "9.3__ServoSynchronization.html?Wizard=" + g_Wizard + "&LastURL=1.3.2__ServoConfigurationListView.html?Wizard=true";
	}
	else{
		location.href = "9.3__ServoSynchronization.html?LastURL=1.3.2__ServoConfigurationListView.html";
	}
}

//handle test function from numpad test button. In this case Servo test
function handleTest(completeTagId, value){
	tagIdArray = completeTagId.split("__");
	tagIdArray = tagIdArray[1].split("_");
	Index = parseInt(tagIdArray[0]);
	
	if(numpadIsTestActive){
		GetTd({"cmd":0x0256, "param": {"ServoIdx": Index, "Pos": parseFloat(value)}}, "noEvent", "command");
		//alert("move Servo " + Index + "   to position " + value);
	}
	else{
		//alert("test for Servo " + Index + " has been stopped");
	}
}


function setDependingLimits(tagId){
	tagIdArray = tagId.split("__");
	tagIdArray = tagIdArray[1].split("_");
	Index = parseInt(tagIdArray[0]);
	tagId = tagIdArray[1];
	
	if(tagId == "MaxValue"){
		numpadMinValue = parseFloat(splitUnitFromValue(getHTML("Servo__" + Index + "_Center")).value);
	}
	else if (tagId == "MinValue"){
		numpadMaxValue = parseFloat(splitUnitFromValue(getHTML("Servo__" + Index + "_Center")).value);
	}
	else if (tagId == "Center"){
		numpadMaxValue = parseFloat(splitUnitFromValue(getHTML("Servo__" + Index + "_MaxValue")).value);
		numpadMinValue = parseFloat(splitUnitFromValue(getHTML("Servo__" + Index + "_MinValue")).value);
	}
}


function getServoGroupPopupList(tagObj){
	tagId = $(tagObj).attr('id');
	ServoIdx = parseInt(tagId.split("__")[1].split("_")[0]);
	g_GroupTagObj["Servo__" + ServoIdx + "_Group"] = tagObj;
	
	GetTd(getServoGroupPopupObj(ServoIdx), g_SetEvent);
	
	//g_GroupList = e.EventData.PopUp.ServoGroupsUser;
	//$("#Servo__" + Index + "_Group").bind("click", function(){showPopupList(this, g_GroupList, false, true, g_popupList_Indices);});
}


function getServoVoltagePopupList(tagObj){
	tagId = $(tagObj).attr('id');
	ServoIdx = parseInt(tagId.split("__")[1].split("_")[0]);
	g_VoltageTagObj["Servo__" + ServoIdx + "_Voltage"] = tagObj;
	
	GetTd(getServoVoltagePopupObj(ServoIdx), g_SetEvent);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Scroll Functions~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function initScrollbarsSCL(id){
	(function($){
		$('head').append('<link rel="Stylesheet" type="text/css" href="css/mCSB.css" />');

		if(navigator.appVersion.indexOf("X11; U; Linux armv7l; c") == -1){
			if(id != "PopUp_List_Container"){
				$.getScript("/js/jquery.mCustomScrollbar.concat.min.js", function(data, textStatus, jqxhr){
					$(".scrollContainerOuterHorizontal").mCustomScrollbar({
					 	horizontalScroll:true,
					 	callbacks:{
					 		whileScrolling:function(){
					        	pixel = 674 - mcs.left;
					        	setCSS('scrollContainerInnerVertical', 'width', pixel + 'px');
					        }
					    }
					});
	
					$(".scrollContainerOuterVertical").mCustomScrollbar({callbacks:{whileScrolling:function(){}}});
				});
			}
			else{
				$('#' + id).mCustomScrollbar();
				$('#' + id).find('.mCSB_scrollTools').css({'height': '319px'});
			}
		}
		else{
			if(id != "PopUp_List_Container"){
				var getHeight_visible  = 312;
				var getHeight_dragrail = 312;
				var getHeight_total    = $('#scrollContainerInnerVertical').height();
				var getHeight_ratio    = getHeight_dragrail/getHeight_total;
				
				var getWidth_visible   = 674;
				var getWidth_dragrail  = 674;
				var getWidth_total     = $('#scrollContainerInnerHorizontal').width();
				var getWidth_ratio     = getWidth_dragrail/getWidth_total;
	
				$.getScript("/js/jquery.mCustomScrollbar.concat.min.js", function(data, textStatus, jqxhr){
					$('.scrollContainerOuterHorizontal').mCustomScrollbar({horizontalScroll:true});
					$('.scrollContainerOuterVertical').mCustomScrollbar();
					
					$('#Dragger_1').css({'width': Math.floor(getWidth_visible * getWidth_ratio) + 'px !important'});
					$('#scrollTool_1').css({'top': '338px !important', 'overflow': 'visible'});
				});

				//Key Scrolling
				var topValue  = 0,
					leftValue = 0;
	
				var fixedContainerHeight  = $('.scrollContainerOuterVertical').innerHeight();
				var fixedContainerWidth   = $('.scrollContainerOuterHorizontal').innerWidth();
				var scrollContainerHeight = $('#scrollContainerInnerVertical').innerHeight();
				var scrollContainerWidth  = $('#scrollContainerInnerHorizontal').innerWidth();
					
				var maxPadding     = (scrollContainerHeight - fixedContainerHeight) * (-1),
					maxPaddingLeft = (scrollContainerWidth - fixedContainerWidth) * (-1),
					max = false,
					min = false,
					maxLeft = false,
					minLeft = false;
			}

			$(window).keypress(function (e){				
				var c = e.charCode;
				//Vertical Start
				if((c == CONST_SCROLLING_Key_g) || (c == CONST_SCROLLING_Key_h) || (c == CONST_SCROLLING_Key_j)){
					lepopupfinished = $('#lepopup-wrap').find("div.scrollContainerPopUpOuterVertical");

					if(typeof lepopupfinished != undefined && g_isPopUp){
						lepopupfinished.toggleClass("scrollContainerPopUpOuterVertical_active");
						$('#lepopup-wrap').find("div#scrollContainerPopUpInnerVertical").attr("id", "scrollContainerPopUpInnerVertical_active");
						var fixedContainerPopUpHeight  = 320;
						var	scrollContainerPopUpHeight = $('#scrollContainerPopUpInnerVertical_active').innerHeight();
						maxPadding = (scrollContainerPopUpHeight - fixedContainerPopUpHeight) * (-1);
						isInit = false;
					}

					min = false;
					
					switch(c){
						case CONST_SCROLLING_Key_g : 	topValue += CONST_SCROLLING_StepSmall;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepSmall;		break;
						case CONST_SCROLLING_Key_h : 	topValue += CONST_SCROLLING_StepMiddle; CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepMiddle;	break;
						case CONST_SCROLLING_Key_j : 	topValue += CONST_SCROLLING_StepBig;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepBig;		break;
					}

					if(topValue > 0)
						topValue = 0;
					else
						max = false;
						
					if(!max){
						if(g_isPopUp){
							$('#scrollContainerPopUpInnerVertical_active').animate({'top': topValue + 'px'}, CONST_SCROLLING_AnimationSpeed);
							$('#scrollContainerPopUpInnerVertical_active').find('.mCSB_dragger').animate({'top': Math.floor(topValue * getHeight_ratio * (-1)) + 'px'}, CONST_SCROLLING_AnimationSpeed);
						}
						else{
							$('#scrollContainerInnerVertical').animate({'top': topValue + 'px'}, CONST_SCROLLING_AnimationSpeed);
							$('#scrollTool_2').animate({'top': Math.floor(topValue * getHeight_ratio * (-1/120)) + 'px'}, CONST_SCROLLING_AnimationSpeed);
							$('#scrollTool_1').animate({'top': (338 + Math.floor(topValue/140)) + 'px !important'}, CONST_SCROLLING_AnimationSpeed);
						}

						if(topValue == 0)
							max = true;
					}
				}
				
				if((c == CONST_SCROLLING_Key_b) || (c == CONST_SCROLLING_Key_n) || (c == CONST_SCROLLING_Key_m)){
					lepopupfinished = $('#lepopup-wrap').find("div.scrollContainerPopUpOuterVertical");

					if(typeof lepopupfinished != undefined && g_isPopUp){
						lepopupfinished.toggleClass("scrollContainerPopUpOuterVertical_active");
						$('#lepopup-wrap').find("div#scrollContainerPopUpInnerVertical").attr("id", "scrollContainerPopUpInnerVertical_active");
						var fixedContainerPopUpHeight  = 320;
						var scrollContainerPopUpHeight = $('#scrollContainerPopUpInnerVertical_active').innerHeight();
						maxPadding = (scrollContainerPopUpHeight - fixedContainerPopUpHeight) * (-1);
						isInit = false;
					}

					max = false;
					
					switch(c){
						case CONST_SCROLLING_Key_b : 	topValue -= CONST_SCROLLING_StepSmall;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepSmall;		break;
						case CONST_SCROLLING_Key_n : 	topValue -= CONST_SCROLLING_StepMiddle;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepMiddle;	break;
						case CONST_SCROLLING_Key_m : 	topValue -= CONST_SCROLLING_StepBig;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepBig;		break;
					}
						
					if(topValue < maxPadding)
						topValue = maxPadding;
					else
						min = false;
					
					if(!min){
						if(g_isPopUp){
							$('#scrollContainerPopUpInnerVertical_active').animate({'top': topValue + 'px'}, CONST_SCROLLING_AnimationSpeed);
							$('#scrollContainerPopUpInnerVertical_active').find('.mCSB_dragger').animate({'top': Math.floor(topValue * getHeight_ratio * (-1)) + 'px'}, CONST_SCROLLING_AnimationSpeed);
						}
						else{
							$('#scrollContainerInnerVertical').animate({'top': topValue + 'px'}, CONST_SCROLLING_AnimationSpeed);
							$('#scrollTool_2').animate({'top': Math.floor(topValue * getHeight_ratio * (-1/120)) + 'px'}, CONST_SCROLLING_AnimationSpeed);
							$('#scrollTool_1').animate({'top': (338 + Math.floor(topValue/140)) + 'px !important'}, CONST_SCROLLING_AnimationSpeed);
						}

						if(topValue == maxPadding)
							min = true;
					}	
				}
				//Vertical End
				
				//Horizontal Start
				if((c == CONST_SCROLLING_Key_w) || (c == CONST_SCROLLING_Key_s) || (c == CONST_SCROLLING_Key_x)){
					minLeft = false;
					
					switch(c){
						case CONST_SCROLLING_Key_w : 	leftValue += CONST_SCROLLING_StepSmall;		CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepSmall;		break; //w
						case CONST_SCROLLING_Key_s : 	leftValue += CONST_SCROLLING_StepMiddle;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepMiddle;	break; //s
						case CONST_SCROLLING_Key_x : 	leftValue += CONST_SCROLLING_StepBig;		CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepBig;		break; //x
					}
						
					if(leftValue > 0)
						leftValue = 0;
					else
						maxLeft = false;
						
					if(!maxLeft && !g_isPopUp){
						$('#scrollContainerInnerHorizontal').animate({'left': leftValue + 'px'}, CONST_SCROLLING_AnimationSpeed);
						$('#scrollContainerInnerVertical').animate({'width': (803 - leftValue) + 'px'}, CONST_SCROLLING_AnimationSpeed);
						$('#Dragger_1').animate({'left': (leftValue * getWidth_ratio * (-1)) + 'px'}, CONST_SCROLLING_AnimationSpeed);
						$('#scrollTool_2').animate({'left': (Math.abs(leftValue) + 662) + 'px'}, CONST_SCROLLING_AnimationSpeed);

						if(leftValue == 0)
							maxLeft = true;
					}
				}
				
				if((c == CONST_SCROLLING_Key_e) || (c == CONST_SCROLLING_Key_d)|| (c == CONST_SCROLLING_Key_c)){
					maxLeft = false;
					
					switch(c){
						case CONST_SCROLLING_Key_e :	leftValue -= CONST_SCROLLING_StepSmall;		CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepSmall;		break; //e
						case CONST_SCROLLING_Key_d : 	leftValue -= CONST_SCROLLING_StepMiddle;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepMiddle;	break; //d
						case CONST_SCROLLING_Key_c : 	leftValue -= CONST_SCROLLING_StepBig;		CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepBig;		break; //c
					}
						
					if(leftValue < maxPaddingLeft)
						leftValue = maxPaddingLeft;
					else
						minLeft = false;
					
					if(!minLeft && !g_isPopUp){
						$('#scrollContainerInnerHorizontal').animate({'left': leftValue + 'px'}, CONST_SCROLLING_AnimationSpeed);
						$('#scrollContainerInnerVertical').animate({'width': (803 - leftValue) + 'px'}, CONST_SCROLLING_AnimationSpeed);
						$('#Dragger_1').animate({'left': (leftValue * getWidth_ratio * (-1)) + 'px'}, CONST_SCROLLING_AnimationSpeed);
						$('#scrollTool_2').animate({'left': (Math.abs(leftValue) + 662) + 'px'}, CONST_SCROLLING_AnimationSpeed);
						
						if(leftValue == maxPaddingLeft)
							minLeft = true;
					}
				}
			});
		}
	})(jQuery);
}
//Scrolling End
