#!/bin/sh -e

#	Verschickt Daten ueber angegebene serielle Schnittstelle
########################################3
#$2 - Versionsname zum komprimieren oder Archivname zum dekomprimieren

# globale Funktionen und Defines inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

#########################	Init	######################################

#Diverse lokale Variablen werden deklariert
argc=1
USAGE_STRING="Usage: $0 [UPDATE_DIR]"
TRYHELP_STRING="try \`$0 --help' for more information"

# wenn Argumentanzahl nicht uebereinstimmt

if [ $# -lt $argc ] ; then
	echo "$USAGE_STRING"
	exit 1										
fi

if [ "$1" == "-uf" ] ; then
	# !!! ACTUNG !!! Nur beim Übergang von 6.00 auf 6.01
	# bat60_scripts werden ersetzt, wie immer
	# aber gestartet wird noch das alte bat60_startup.sh,
	# das noch keinen Ordner-Parameter dem fw_update übergibt
	# das fw_update Skript wird bereits zuvor ersetzt.
	# deswegen wenn kein Parameter übergeben wird, wird nach
	# dem alten Verfahren auf dem Stick geschaut
	
	updt_files_dir=$(find_update_dir)	
else
	updt_files_dir=$1
fi

is_logopt=true

bat_log "Update folder $updt_files_dir"

###############################################
#		@brief	Updatet Controller durch das angegebene Schnittstelle
#		mit der angegebenen Adresse und dem Filenamen
#
function reinvoke_target
{
	local iface=$1
	local addr=$2
	local reinvoke_result=0
	
	if [ -z $iface ] ; then
		bat_log "Fatal error: no Iface"
		exit 1
	fi
	
	if [ -z $addr ] ; then
		bat_log "Fatal error: no Address"
		exit 1
	fi
	
	bat_log "bat60_reinvokeisp -d $iface -t $addr -v -v 2>&1"
	
#	Jede ausgegebene Zeile wird sofort in Log geschieben	
	while read -r reinvoke_opt ; do
        if [[ $reinvoke_opt == *"REINVOKEISP_EXIT_STATUS="* ]] ; then
			reinvoke_result=$(echo $update_opt | sed "s|REINVOKEISP_EXIT_STATUS=||g")
        fi

        bat_log "$reinvoke_opt"
    #done < <(bat60_reinvokeisp -d $iface -t $addr -v -v 2>&1 ;  echo "REINVOKEISP_EXIT_STATUS=$?" )
    done < <(bat60_cmd --execute=reinvokeisp -d $iface -t $addr -v -v 2>&1 ;  echo "REINVOKEISP_EXIT_STATUS=$?" ) 

    bat_log "Reinvoke result $reinvoke_result"
	
	return $reinvoke_result
}

###############################################
#		@brief	Updatet Controller durch das angegebene Schnittstelle
#		mit der angegebenen Adresse und dem Filenamen
#
function update_target
{
	if [ "$#" -lt 4 ] ; then
		echo "Too few args to turn_semitransparency" 1>&2
		return 1
	fi

	local iface=$1
	local addr=$2
	local file=$3
	local l_is_reinvoke=$4
	local update_result=0
	local l_reinvoke_param=''
	local l_tmp_fname=$file
	local l_local_fname=$(clean_filename -p $file)
	local l_int_sd=$(find_int_sd)
	
	if [ -z "$iface" ] ; then
		bat_log "Fatal error: no Iface"
		exit 1
	fi
	
	if [ -z "$addr" ] ; then
		bat_log "Fatal error: no Address"
		exit 1
	fi

	if [ $l_is_reinvoke == true ] ; then
		l_reinvoke_param='--reinvokeisp'
	fi
	
	bat_log "Trying to copy update file to intern SD-card"
	
	#	Datei kopieren
	if [[ $l_int_sd != "" ]] ; then
		mkdir -p "$l_int_sd/update_tmp"
		cp -Rf "$file" "$l_int_sd/update_tmp"
		l_tmp_fname="$l_int_sd/update_tmp/$l_local_fname"
		bat_log "File copied to intern SD-card"
	else
		l_tmp_fname=$file
		bat_log "Error while coping to intern SD-card. Updating from initial storage"
	fi
	
	bat_log "Updating target $addr through $iface"
	
#	Jede ausgegebene Zeile wird sofort in Log geschieben	
	while read -r update_opt ; do
        if [[ $update_opt == *"ISP_EXIT_STATUS="* ]] ; then
			update_result=$(echo $update_opt | sed "s|ISP_EXIT_STATUS=||g")
        fi

        bat_log "$update_opt"
    done < <(bat60_isp -d $iface --writefile=$addr,$l_tmp_fname $l_reinvoke_param -v -v 2>&1 ;  echo "ISP_EXIT_STATUS=$?" ) 

    bat_log "Update result $update_result"
    
	if [[ $l_int_sd != "" ]] ; then
		rm -Rf "$l_int_sd/update_tmp"
	fi
	
	return $update_result
	
}

###############################################
# @brief	Schaltet den Housekeeper in Semi-Trans. Modus
#			um weitere Controller programmieren zu koennen
#
function turn_semitransparency
{
	if [ "$#" -lt 2 ] ; then
		echo "Too few args to turn_semitransparency" 1>&2
		return 1
	fi
	
	local l_target=$(get_controller_addr $1)
	local l_transp_on=$2
	local l_iface=$(get_reinvoke_iface $CTRLR_NAME_HOUSEKEEPER)
	local transp_result=0
	
#	Jede ausgegebene Zeile wird sofort in Log geschieben	
	while read -r transp_opt ; do
        if [[ $transp_result == *"TRANSP_EXIT_STATUS="* ]] ; then
			transp_result=$(echo $update_opt | sed "s|TRANSP_EXIT_STATUS=||g")
        fi

        bat_log "$transp_opt"
    done < <(bat60_cmd -d $l_iface -t $COMM_ADDRESS_HOUSEKEEPER --execute=semitransparency,$l_transp_on,$l_target -o 0x01 -v -v 2>&1 ;  echo "TRANSP_EXIT_STATUS=$?" ) 

    bat_log "Transparency result $transp_result"
	
	return $transp_result
}

FTRX="Transceiver.fw"
FSWP="SwitchController.fw"
FHSKPR="HouseKeeper.fw"
FSTCK="StickController.fw"

declare -a updt_arr
updt_arr[0]="update_sep_trxc.sh"
#update_sep_hskpc.sh
updt_arr[1]="update_sep_switchpanel_left.sh"
updt_arr[2]="update_sep_switchpanel_right.sh"
updt_arr[3]="update_sep_stick_left_ext.sh"
updt_arr[4]="update_sep_stick_right_ext.sh"
updt_arr[5]="update_sep_stick_left_int.sh"
updt_arr[6]="update_sep_stick_right_int.sh"
updt_arr[7]="update_sep_switchpanel_center.sh"
updt_arr[8]="update_sep_hskpc.sh"

SCRIPT_SEP_TRX="update_sep_trxc.sh"
SCRIPT_SEP_SWPAN_L="update_sep_switchpanel_left.sh"
SCRIPT_SEP_SWPAN_R="update_sep_switchpanel_right.sh"
SCRIPT_SEP_SWPAN_C="update_sep_switchpanel_center.sh"
SCRIPT_SEP_STICK_L_EXT="update_sep_stick_left_ext.sh"
SCRIPT_SEP_STICK_R_EXT="update_sep_stick_right_ext.sh"
SCRIPT_SEP_STICK_L_INT="update_sep_stick_left_int.sh"
SCRIPT_SEP_STICK_R_INT="update_sep_stick_right_int.sh"
SCRIPT_SEP_HK="update_sep_hskpc.sh"

sep_scripts_dir="$BAT_SCRIPTS/update_files/separate"

PROGRESS_VAL_START=55
PROGRESS_VAL_FINISH=95
#TODO: nach return-Wert
# Transceiver
#bat_log "Transceiver: $updt_files_dir/$FTRX"
if [ -e "$updt_files_dir/$FTRX" ] ; then
	print_update_msg 'Updating Transceiver ...'
	bash "$sep_scripts_dir/$SCRIPT_SEP_TRX" "$updt_files_dir/$FTRX" #'--reinvokeisp'
	set_progress_bar 60
fi

# Switch Panels
if [ -e "$updt_files_dir/$FSWP" ] ; then
	print_update_msg 'Updating Left Switch ...'
	bash "$sep_scripts_dir/$SCRIPT_SEP_SWPAN_L" "$updt_files_dir/$FSWP" #'--reinvokeisp'
	set_progress_bar 64
	print_update_msg 'Updating Right Switch ...'
	bash "$sep_scripts_dir/$SCRIPT_SEP_SWPAN_R" "$updt_files_dir/$FSWP" #'--reinvokeisp'
	set_progress_bar 68
	
	# Beim BAT64 noch den 3-ten Switch
	if [ "$TX_VARIANT" = "64" ] ; then
		print_update_msg 'Updating Central Switch ...'
		bash "$sep_scripts_dir/$SCRIPT_SEP_SWPAN_C" "$updt_files_dir/$FSWP"
		set_progress_bar 72
	fi
fi

# Stick Controller
if [ -e "$updt_files_dir/$FSTCK" ] ; then
	print_update_msg 'Updating Left Stick external ...'
	bash "$sep_scripts_dir/$SCRIPT_SEP_STICK_L_EXT" "$updt_files_dir/$FSTCK" #'--reinvokeisp'
	set_progress_bar 76
	print_update_msg 'Updating Right Stick external ...'
	bash "$sep_scripts_dir/$SCRIPT_SEP_STICK_R_EXT" "$updt_files_dir/$FSTCK" #'--reinvokeisp'
	set_progress_bar 80
	print_update_msg 'Updating Left Stick internal ...'
	bash "$sep_scripts_dir/$SCRIPT_SEP_STICK_L_INT" "$updt_files_dir/$FSTCK" #'--reinvokeisp'
	set_progress_bar 84
	print_update_msg 'Updating Right Stick internal ...'
	bash "$sep_scripts_dir/$SCRIPT_SEP_STICK_R_INT" "$updt_files_dir/$FSTCK" #'--reinvokeisp'
	set_progress_bar 90
	
	# TODO: erkennen, ob Top-Sticks eingebaut sind
fi

# HouseKeeper ist immer der letzte
if [ -e "$updt_files_dir/$FHSKPR" ] ; then
	print_update_msg 'Updating Housekeeper ...'
	#bash "$sep_scripts_dir/$SCRIPT_SEP_HK" "$updt_files_dir/$FHSKPR"
	bash "$sep_scripts_dir/$SCRIPT_SEP_HK" "$updt_files_dir/$FHSKPR"
	set_progress_bar $PROGRESS_VAL_FINISH
fi

exit 0 
