/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Param~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
var GUI_VERSION = "6.02";
var GUI_SUBVERSION = 2748;

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Constants~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Virtual Rotary -1-> used for Numpad control
var DEBUG_LEVEL = 0;	//show nothing = 0; show errors = 1; show infos = 2; show all (debug) = 3; 

var CONST_CTRL_Null					= 0;

var CONST_CTRL_VirtualRotaryNumpad  = 1;

//Fixed Switch
var	CONST_CTRL_SwitchFixedOn		= 2;
var	CONST_CTRL_SwitchFixedOff		= 3;

//Fixed Value
var CONST_CTRL_ValueFixedBegin		= 32768;
var CONST_CTRL_ValueFixedMiddle		= 34816;
var CONST_CTRL_ValueFixedEnd		= 36863;

//Function Output
var CONST_CTRL_FunctionoutputBegin	= 1792;
var CONST_CTRL_FunctionoutputEnd	= 1888;

//Virtual Switch
var CONST_CTRL_VirtualSwitchBegin	= 1280;
var CONST_CTRL_VirtualSwitchEnd		= 1311;

//Sticks																dezimal
var CONST_CTRL_StickLeftVert 		= (1 << 8) | (0x0 << 4) | 0x0;		//256
var CONST_CTRL_StickLeftHori 		= (1 << 8) | (0x0 << 4) | 0x1;		//257
var CONST_CTRL_StickRightVert 		= (1 << 8) | (0xF << 4) | 0x0;		//496
var CONST_CTRL_StickRightHori 		= (1 << 8) | (0xF << 4) | 0x1;		//497

//Rotary Encoders
var CONST_CTRL_RotaryLeftUp 		= (2 << 8) | (0x0 << 4) | 0x0;		//512
var CONST_CTRL_RotaryLeftMiddle 	= (2 << 8) | (0x0 << 4) | 0x1;		//513
var CONST_CTRL_RotaryLeftBottom 	= (2 << 8) | (0x0 << 4) | 0x2;		//514
var CONST_CTRL_RotaryStickLeft		= (2 << 8) | (0x0 << 4) | 0xF;		//527
var CONST_CTRL_RotaryRightUp 		= (2 << 8) | (0xF << 4) | 0x0;		//752
var CONST_CTRL_RotaryRightMiddle	= (2 << 8) | (0xF << 4) | 0x1;		//753
var CONST_CTRL_RotaryRightBottom 	= (2 << 8) | (0xF << 4) | 0x2;		//754
var CONST_CTRL_RotaryStickRight		= (2 << 8) | (0xF << 4) | 0xF;		//767
	                                                              
//Switches
var CONST_CTRL_SWLeftFront1 		= (3 << 8) | (0x0 << 4) | 0x0;		//768
var CONST_CTRL_SWLeftFront2 		= (3 << 8) | (0x0 << 4) | 0x1;		//769
var CONST_CTRL_SWLeftTop1 			= (3 << 8) | (0x0 << 4) | 0x2;		//770
var CONST_CTRL_SWLeftTop2 			= (3 << 8) | (0x0 << 4) | 0x3;		//771
var CONST_CTRL_SWStickLeft			= (3 << 8) | (0x0 << 4) | 0xF;		//783
var CONST_CTRL_SWRightFront1 		= (3 << 8) | (0xF << 4) | 0x0;		//1008
var CONST_CTRL_SWRightFront2 		= (3 << 8) | (0xF << 4) | 0x1;		//1009
var CONST_CTRL_SWRightTop1 			= (3 << 8) | (0xF << 4) | 0x2;		//1010
var CONST_CTRL_SWRightTop2 			= (3 << 8) | (0xF << 4) | 0x3;		//1011
var CONST_CTRL_SWStickRight			= (3 << 8) | (0xF << 4) | 0xF;		//1023
	                                                                                                                         
//Potis                                                     
var CONST_CTRL_PotiLeftTop 			= (4 << 8) | (0x0 << 4) | 0x0;		//1024
var CONST_CTRL_PotiLeftSide 		= (4 << 8) | (0x0 << 4) | 0x1;		//1025
var CONST_CTRL_PotiStickLeft		= (4 << 8) | (0x0 << 4) | 0xF;		//1039
var CONST_CTRL_PotiRightTop 		= (4 << 8) | (0xF << 4) | 0x0;		//1264
var CONST_CTRL_PotiRightSide 		= (4 << 8) | (0xF << 4) | 0x1;		//1265
var CONST_CTRL_PotiStickRight		= (4 << 8) | (0xF << 4) | 0xF;		//1279

//Buttons
var CONST_CTRL_StickLeftButton		= (3 << 8) | (0x0 << 4) | 0xE; 		//782
var CONST_CTRL_StickRightButton		= (3 << 8) | (0xF << 4) | 0xE;		//1022

//Telemetry
var CONST_TELEMETRY_Tx_Voltage = 7307;
var CONST_TELEMETRY_Tx_TRXStatusWord = 11398;
var CONST_TELEMETRY_Tx_HKStatusWord = 11404;
var CONST_TELEMETRY_MEASValue_Tx_Servo__0 = 4224;
var CONST_TELEMETRY_MEASValue_Tx_PowerSupply = 33968;

//Hi-, Center- und Lo-Grenzen
var CONST_HiThreshold = 94;
var	CONST_LoThreshold = -94;
var CONST_CenterUpperThreshold = 6;
var CONST_CenterLowerThreshold = -6;	

//Scrolling
var CONST_SCROLLING_StepSmall  =  70;
var CONST_SCROLLING_StepMiddle = 210;
var CONST_SCROLLING_StepBig    = 490;
var CONST_SCROLLING_AnimationSpeed = 20;
//vertical
var CONST_SCROLLING_Key_g = 103;	//scroll up small
var CONST_SCROLLING_Key_h = 104;	//scroll up middle
var CONST_SCROLLING_Key_j = 106;	//scroll up big
var CONST_SCROLLING_Key_b = 98;		//scroll down small
var CONST_SCROLLING_Key_n = 110;	//scroll down middle
var CONST_SCROLLING_Key_m =	109;	//scroll down big
//horizontal
var CONST_SCROLLING_Key_e = 101;	//scroll left small
var CONST_SCROLLING_Key_d = 100;	//scroll left middle
var CONST_SCROLLING_Key_c = 99; 	//scroll left big
var CONST_SCROLLING_Key_w = 119;	//scroll right small
var CONST_SCROLLING_Key_s = 115;	//scroll right middle
var CONST_SCROLLING_Key_x =	120;	//scroll right big

//Images
var CONST_MODELICON_DEFAULT_small = "data:image/png;base64,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";
//var CONST_MODELICON_PLANE_small = "";
//var CONST_MODELICON_GLIDER_small = "";
//var CONST_MODELICON_HELI_small = "";

var CONST_BATTERYICON_ALL         = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAAVCAQAAAB7jaH5AAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAOOSURBVEjHtdZbiNRWGAfwzypWQd2qrC0j3h8VxAveUPDBqqBvpYLSC7QvreiDoLCLd1GolCKU1ieF+qAg7KOiWGTBipfV7ezO7M7uujrOuDs795lsMjmZy2b+PcnckskkozjNnwQmk5Pz4zs5JyEQKG3NN0IwcyBD9YElqXIS2wojUBBHgicJNfH7vzTAg8bZgG6+2/+uRj8I9ZkvBCXIo2wOI3OsN0joiZPyV7GA6pZP+X/yU5HHFog6ID4EeFxEBjLYkebAuJ5Ye2EIhi3+YGy5aof7aOBCYUzjcaCfzWsGzOoRj6rJGm8K4pnMJ/r/0/4PYIeo83TisWbAfCkPodaAxX62Q6EWAieNaZ8cL+O0/S37zBnI+NQRt6sTxgFOXh38NOo0wB8FPMWnB8JSr+QvaEh2whkYoCjJN5Cr8eS48JVEOVJJopi1hQDnbQrTnYBfiBOMrxZwYS5cOjDIFjoBR2iibSpo7IF5st9jE3Zhr7Ql5LK0GG4CjDlX8FyGo3g59POKBgTrdAIOr4x0qKYe1HTRhz4E5b8H1rjnWVrcbAK84wR0iRFWAroeEFysBBxni+yB41uls8XbuJnvUtPGfuRx39dPZzyytjjUBPizE/CSPqjaEK8bJqwrA8FOO6yD7bkVWB5dHPmuEKr1Inl8e140nh6zEXbgCWizBQqLpTirAA/6CQerwDD73A4Yoym+v6TIVZXVeAM7e6iPn33ciHjEAXjSYR2c/EWugIDDfP4drgLBLtgDk+Sl/jmKr9JHZmBw9zPOswUS7tnw/jHPYBMwvVRK1kDoTBE6DcAoc9m9i99RiIL78uWBk/p9u3qol9xOwNl42ID3pH54zRX8tVY/GdlR9Vp22AAEu9QYGKYIT/q6mtWr5/Xs6OG4JkDCTHSAGXA5nOdsu4Waf16tFNM1TB5jEffdWDFnBCbYkkbAUZ6hWYpHn7k+7/ZnnPYeQC1t+BbaxArhRyywu0o/JCl1RTZgVPy28Q86uS8LUw0vNwK+4nmzt8A/FTI+z+bS4L4nUEs3B3Y7XVF6jlaJgpGSxw9fXqNzB3JmYIots97ASx5KdQFKoG+9xuvVz7YYmP5TNlFyiE2O3E+pdRUEu2K9wSB5Z+XD2bG+Dc/LOLS+ghlBgTl5/s7Oof6sFLfe4PXMwH4l4F77gnMqtWs9sCsmRMuJVRO1JHCrwTO4JXTRvfrltMrQthr4H0jUWBwlG8JVAAAAAElFTkSuQmCC";
var CONST_BATTERYICON_CHARGING    = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAAVCAYAAADRhGlyAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAObSURBVHja7JhfSNNRFMfv5txvw7m/rD9GQ3yJ8EUW1foDCfYSBYVBREQQWBCEFBjRUxAEQT3WSxA9BD300pOg0T/IEYkbZqVTJmszS7dsTqdz7vfb+l65ys/1m/sn7IYeONz7+90z7uWzc+4556fKZDKkkhKNRlc9p9PpgyaT6alGo3HgMQ5VsSU6mqemph6FQqF2rVa79LKxsbGY7fZAH0A7oJ4S1v8RDamwANjKnP6ZBoPhclVVVQM7m05um0qlojMzM4Nms5nU19eXumVzmet8AZRHAOZ2eN5+lUqleK5YLNZXXV3dVVdXR2BDeJCKA6ytrV2ZLy4unlWr1VuU7CRJIoIg9Oj1+hBsiCysMxsaoAwG0el0p/BszmE3AO98B89LE45EXekDiKJIPY8sLCwcxt23O9eZkGzcgUCgF3fgqhtgw4dwOBwmCEuaPC7By2xKNvPz878B943D4UjS7EsTD96RRCJB7HZ7vi2moaasd315fiNfl6ACG/kDmEwmCaCYcL/R7KdVskHY/kJ4G2CzD49Gdu5pZOUQxp95tphQAFiM/MkFj5cs3ADPOwNIjlw2ALcT6zdpnoFa4H0jwWDwOgDGaUbOI7Se21XGEXu5DmGE7taamhoBgF7QKxFQBIRrizyZsLmZhfM44D2enZ31wVYsYItO6LkyjtjJNUB4lx8hPAGAGdyHKXhki81mO6CUjePx+JexsbEbc3Nz3S6Xq9AtXrIw3lbC8WLQ51xnYQCLwOMCkUjkO+CM45UL8CxK8OB57Ri7UUwTj8dD3G53IVskoHdLPN59BpFfgKzDIJOTkwRgDOiDmwFQL1+Hx31D/9sBeO+Xe+Ai5SG0q8jf9EDvcV8H0kIagIjVaiXocY/AGy1ZnjcAeNdg84p6XhkfP1qhbwu0/Qg9sVb25QYgEgEtYwjAEaPR2CoHCGhfUTxfBcTXFF6ZQkP5GPQWmysJzfJ3oC35QpcbgIBDkFFpp4FST7cXHimwbDsEeFcwflgHeHJANCy3Qy/Iakg6trH3t9cAzGUSWVJ4YTN63R3M84ZGR0cvotPoWUd42dn1GXSEPdPxCSua/69emHYi6IOJxWJpA0Ar5kG/338e4yca1lSampqWlEfh4msMelsdCupDgPljeHj4NEYvYBKn07li19/fvwkwRyGtBayjkiQlfT7fSVEUP1PPW4bn9XpXffLaBJgl8D4n7jkX4B0HxEEKSw6Pd/krwAAGH3xtV7ypNwAAAABJRU5ErkJggg==";
var CONST_BATTERYICON_PLUG        = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAAVCAYAAADRhGlyAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAADkSURBVHjaYvj//z/DCMLGQLwfSpMjj4GZGEYecKBQHgWMxACkKhgNwNEAHA3AIQ0YQTXJMAcfgJifAv1/gZgdSo/IFPiCQv3vcAXeSAnAsxTqPzXSy8CttNQ/EspATiC+B8QSZOj9CMTyUHrEpsDvQNxKpt5ufIE3UlIgDGwHYg8S1B+Bduv+jrYDISAIiPcRqfY4EPsQCryRFoCgrOwJxJVQNjbwC4ibgNiZUNYdiVkYGYAa1n5A3AHEUkD8DIjrgHg9tN032hMhEuyHlnMHgNhxtC88OpgwGoCjATgKSAMAAQYAhOIhSlUZfUsAAAAASUVORK5CYII=";
var CONST_BATTERYICON_PLUGWARNING = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAAVCAYAAADRhGlyAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAL8SURBVHja7FhLaxNRFJ48SUhqrJrWWB2tirrWP6CoC7FuXIvPvrCtj6ILV4JQCOgm4FJXgosguKoIEXVhKEjrIhAILgVLIGpinqTk4XfGGxjTO89IZwI58HFn7tyZe/jmO/eecx3tdlvYaisUCnqGXXI4HEtut/s+ruNagwOBgJ5vngCeAPeANRPPN5lbsMBAjNaQYWDJ5XKJRCLwBvfl/zT9yR6f/2NOwZ52w+l0iozow8BVm/ppSwJ3ArdBoFypi8C2AYH6bArk7ZWHOdbpcVLlgEDZGqiAMDCPtY+3Xt4Ctg8IVLcZqG+MLorFYjmTyZSz2WyDPTtA6jSz6ZOIGVZZ36qsr63xnOZ3KYrBijQG5PC6d0NtX5C2REh1Pp+PiCwBQ9Vq9TtT4jfgOPCz+2W/3680XQY42oO7OWCkHxQ4C/VFJKecklvrjMB1dk8mAtMGv7vWo1+f+yGE90BhszKipL5EIiG1XVEyp6YIji336NtyPxA4h41jtHPTarWoGRVFUWq7xlJozxj49msga9Kv38BLWxMIdY1BedOc6uSY1+uVWs5rNznEKlmNqhqT7j1mJNqLQArJDkDcAgjc1f2cyrlgMNgp6zZtOCyU9dpT4K1BNz8BUVunMSBKBHlTCrVxCDuy1CqlPLQ+GpjuIvBe59gVYAJo2ppApr4dPIXW6/XroVDoGdorCq+PGFQhhfI54AG75tkG8Ag4rRW6dgjhgyBvkqc+j8cj5HK5oVQqFUHOeERemXBUuM/A1BssLCldusxSpU7KNMn6H6oQbA8CaZcFgQsghluaEWHxeHwimUyej8ViF1SSfTp4mDe5u74AvrJ7ap8Dv/qilAMhh7C+XVM6F2w2m0I6nR5GNUJqDGicH1J5t9+qZciSA1UobBEIqYV4NBp9lc/nV8Lh8FmNcpN26TvAXUvWcStq4UqlUlAjsBPGVJmQGllirWiNRuMHUp6wCVc+CH9PoD8Cp/pGgbB3pVLpTPfP44Wqnh9cq9USLGfccvsjwACEQ+iPPuGfjAAAAABJRU5ErkJggg==";
var CONST_BATTERYICON_WARNING     = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFAAAAAVCAYAAADRhGlyAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJfSURBVHja7JjLbtNAFIbHzkW5tW4BJ01DDbQIsYVngBXwBkhQ6E0tFQKpj8CeLLrrE+QV0m3EDlCkSFmwQEhUkQKKnasi5dL/WJMSkpkk6tLjIx0dj2dsyZ/+mXOOteFwyLxmtm0vsuylpmmfgsHgCa5z8xbH43Hhfc2LAB3HmbdkFf49EAhYuq7/AMhHGDdnPRCNRoX3daamvQU4C+Do+j789XVfpCLAm/D3AMg4QLKP8GUf4GK2C3i3x+AxHGP3SJXXeZknz8B6vS6bMuHfkDgyVwAAkhgg/sSQzkLbPwPltg/1ZTjkZrlcblYqlR6fu0vq9BUoV+AaVPYV6kuT6iKRCIFswJfa7fZvvqV/wR/D//oKnLYDqC/tfrTufvYFB3jBx2QWfM9PItO2DoUdjIFy7+XzeTdO7MIjeNIH+L8doWhOjQaDwYBCyrIsN06spa297wP8V6JkoLy98bKF28NwOOxGwWOHArDqAKQtOXKAOwbAW5Pz1M4lEolRWzeVcPhWVluBAEW97q5AfWQGMrIbZSUPnY9KA+TquyFSaLfbfWMYxhniK8njyUVU6OUtvAl4OyL1hUIhVq1Wl4rFYho14wMkGDZDhRvKAaQsC4DHALMimidguVzueaFQeJbNZl/MaCbox8M7FRW4hfNtW3L2sX6/z0ql0iq6EVJjXLZu9PMBfkepVs627VOUKIcyMKRAx3HqtVrti2maT2OxmM5rQ5l9Riv3QRmArVbLBiRj1hqCSJ0JqXEOPNbr9f6g5DFFc0GPJuDzRqPxZFIcIkUuIqBOp5PnNeOUXQowAKOGySw5fjZpAAAAAElFTkSuQmCC";
//Constants end

//Ajax RQ Objects
var	InitDataPostArgs = new Object();
var	TdPostArgs = new Object();
var	FmDataPostArgs = new Object();
var EventDataPostArgs = new Object();
EventDataPostArgs.Event = [];
//Ajax RQ Objects End

//Telemetry Ids which called always
var telemetryIds = new Array();
var telemetryIds20 = new Array();

telemetryIds = setTxTRXStatusWord(telemetryIds);
telemetryIds20 = setCurrentPowerSupply(telemetryIds20);
//telemetryIds20 = setTXvoltage(telemetryIds20);

TdPostArgs.Telemetry_Val = telemetryIds;
//Telemetry Ids end

//Control Ids which called always
controlIds = new Array();
controlIds = setRotaryControl(controlIds);

TdPostArgs.Control_Val = controlIds;
//Control Ids end

var g_isRunOnDC = 0;
var g_isReserve = 0;
var g_dialogBoxTimeoutFunction;
var g_PageRefreshed = false;
var g_isAdditionalControlObjectUsed = false;
var g_CurrentFlightMode = -1;
var g_numpadLimitObj = {};
var g_isPopUp = false;			//f�r alle PopUps
var g_isBindingActive = 0;	//binding process active
var g_isRfConnected = 0;	//RF connection to Receiver active
var g_currentLocation = location.pathname.substring(0, location.pathname.indexOf(".html"));
var g_absoluteServoMonitorPath = "/1.14__ServoMonitor.html?LastURLMonitor=" + location.href;
var g_htmlServoMonitor = ['<div style="width: 100%;" onClick=\'gotoHref("' + g_absoluteServoMonitorPath + '");\' draggable="false">' + 'Servo İzleme' + '</div>',
                          '<div style="width: 100%;" onClick=\'takeScreenshot();\' draggable="false">' + 'Ekran Görüntüsü Al' + '</div>',
                          '<div style="width: 100%;" onClick=\'gotoHrefHelp();\' draggable="false">' + 'Yardım' + '</div>'
//                          'Add to Favorites'];
                          ];

var g_FileType = new Array();
	g_FileType["Music"]   = new Array ("mp3", "wav", "wma");
	g_FileType["Image"]   = new Array ("gif", "giff", "jpg", "jpeg", "png", "tif", "tiff", "bmp");
	g_FileType["Model"]   = new Array ("model");
	g_FileType["Log"]	  = new Array ("log");
	g_FileType["Setting"] = new Array ("set");

//Listener
$(window).keypress(function (e){onEVENT_KEYPRESS(e);});

$(document).on("onEVENT_CONTROL", function controlEvent(e){onEVENT_CONTROL(e);});
var g_ControlEvent = "onEVENT_CONTROL";

$(document).on("onEVENT_INIT", function controlEvent(e){onEVENT_INIT(e);});
var g_InitEvent = "onEVENT_INIT";

$(document).on("onEVENT_SET", function (e){onEVENT_SET(e);});
var g_SetEvent = "onEVENT_SET";

$(document).on("onEVENT_FM_CHANGED", function (e){onEVENT_FM_CHANGED(e);});
var g_FmEvent = "onEVENT_FM_CHANGED";

$(document).on("onEVENT_LINUX", function (e){onEVENT_LINUX(e);});
var g_LinuxEvent = "onEVENT_LINUX";

$(function(){
	$('#Option_Button').removeAttr("href");
	$('#Option_Button').bind("click", function(){showPopupList(this, g_htmlServoMonitor, false, false, -1);});
});

//Listener end

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~OPTION BUTTON~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function gotoHrefHelp(){
	
	if(g_currentLocation.indexOf("Help") != -1){
		var pageName2Show = encodeURI($("#Help_Page").html());
		pageName2Show = pageName2Show.replace(/&/g, "%26");
		gotoHref("/HelpContent/0.0__General_Help.html?FromName2Help=" + document.title + "&FromName2Help2Show=" + pageName2Show + "&LastURLHelp=" + g_lastURL);
	}
	else{
		var pageName2Show = encodeURI($("#" + $("#Page_Name_Tag").html()).html());
		pageName2Show = pageName2Show.replace(/&/g, "%26");
		gotoHref("/HelpContent/" + g_currentLocation + "_Help.html?FromName2Help=" + document.title + "&FromName2Help2Show=" + pageName2Show + "&LastURLHelp=" + location.href);
	}
}


function gotoHref(href){
	if(g_currentLocation == "/9.2.0__CurveEdit"){
		g_isOptionButton = true;

		if(g_fromPageType == "SyncIndex"){
			g_gotoLocation = href;
			GetTd({"cmd":0x0257, "param": {"ServoIdx": g_Index}}, g_SetEvent, "command");
		}
		else{
			if(document.getElementById("Navi_Box").style.display == "none"){
				g_gotoLocation = href;
				showDialogbox("saveCurve");
			}
			else{
				g_gotoLocation = href;
				isGotoSave = true;
				submitCurve("set", "save", g_curvePercentages, g_realPoints, g_currentFlightMode);
			}
		}	
	}
	else{
		window.location.href = href;
	}
}


function takeScreenshot(){
	hideHTML('Pop_Up_Blocker');
	$('#Pop_Up_Outer').remove();
	g_isPopUp = false;
	
	setTimeout(function(){
		if($('#Pop_Up').is(':empty')){
			GetTd({"cmd":0x0314}, "noEvent", "command");
		}
	}, 500);
}
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~DEBUG~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function log(lvl, msg){
	if(lvl <= DEBUG_LEVEL){
		console.log(msg);
	}
}


function notUsed(key, value){
	return value;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~MATH OPERATION~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function Value12Bit2Percent(x){
	return Math.round((x * 100) / 2047);
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~EXTRACT GET PARAMETER~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

//Extract GET-Parameter from URL
function get_GET_Parameter(){
	var uriGET = window.location.search.substring(1).split('&');
	
    if(!uriGET.length) return;
    
    GET_Param = {};
   
    for(var i  = 0; i < uriGET.length; i++){
        var parts = uriGET[i].split('=');
        
        if((decodeURI(parts[0]) == "LastURL") && (decodeURI(parts[2]) != "undefined")){
        	 GET_Param[decodeURI(parts[0])] = decodeURI(parts[1]) + "=" + decodeURI(parts[2]);
        }	 
        else{
        	 GET_Param[decodeURI(parts[0])] = decodeURI(parts[1]);
        }	 
    }
    
    return GET_Param;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~JSON-OBJECT CONSTRUCTOR~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

//Current Flightmode Object
function getCurrentFlightMode(TdPostArgs){
	if(typeof TdPostArgs == 'undefined'){
		TdPostArgs = new Object();
	}
	
	flightMode = new Object();
	flightMode.Index = g_CurrentFlightMode;
	flightMode.Name = "";
	
	TdPostArgs.Current_FM = flightMode;
	
	return TdPostArgs;
}

//Current Modelname Object
function getCurrentModelName(InitDataPostArgs){
	if(typeof InitDataPostArgs == 'undefined'){
		InitDataPostArgs = new Object();
	}
	
	InitDataPostArgs.ModelName = "Default Model";
	
	return InitDataPostArgs;
}

//PopupList
function getPopupObj(InitDataPostArgs, ListName){
	if(typeof InitDataPostArgs == 'undefined'){
		InitDataPostArgs = new Object();
	}
	
	if(typeof InitDataPostArgs.PopUp == 'undefined'){
		InitDataPostArgs["PopUp"] = {};
	}
	
//	ListItem = new Object();
//	ListItem.Index = -1;
//	ListItem.Name = "";
//	
//	listArray = new Array (ListItem);
	listArray = new Array();
	
	InitDataPostArgs["PopUp"][ListName] = listArray;
	
	return InitDataPostArgs;
}

//Numpad Limits
function getNumPadLimitObj(InitDataPostArgs, ClassTag){
	if(typeof InitDataPostArgs == 'undefined'){
		InitDataPostArgs = new Object();
	}
	
	if(typeof InitDataPostArgs.NumPadLimits == 'undefined'){
		InitDataPostArgs["NumPadLimits"] = {};
	}
	
	ListItem = new Object();
	ListItem.Max = -1;
	ListItem.Min = -1;
	ListItem.IsSigned = -1;
	ListItem.OutputResolution = -1;
	
	InitDataPostArgs["NumPadLimits"][ClassTag] = ListItem;
	
	return InitDataPostArgs;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~HTML CONSTRUCTOR~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

//Create and return HTML-Code for htmlOutercontainer and one Row of RD(reorder, delete) buttons 
function getRowRD(Index, Name, ListType){
	htmlRDrow = '' +
		'<div id="ContainerOuter_' + Index + '">' +
			'<div id="Container_' + Index + '" class="list_content_row" style="width: 674px;"></div>' + 
			'<div id="Delete_Button_' + Index + '" class="button_red round_all" style=" margin: 4px 0px 0px 21px; width: 52px; height: 60px;"><a href="#" onClick=\'showDialogbox("delete", "' + ListType + '","' + Name + '",' + Index + ');\' class="delete_button" draggable="false"></a></div>' +
			'<script type="text/javascript">' +
				'if(toggleStateARD != "delete")' +
					'$("#Delete_Button_' + Index + '").hide();' +
			'</script>' +
				
			'<div id="Reorder_Button_' + Index + '" class="button_blue round_all" style="display: none; margin: 4px 0px 0px 21px; width: 52px; height: 60px;"><a href="#" onClick="raiseElement(' + Index + ');" class="raise_button" draggable="false"></a></div>' + 
			'<script id="Reorder_Button_Script_' + Index + '" type="text/javascript">' +
				'if((toggleStateARD != "reorder") || (Index == 0))' +
					'$("#Reorder_Button_' + Index + '").hide();' +
			'<\/script>' +
		'</div>';
	
	return htmlRDrow;
}
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~SET CONTROL/ TELEMETRY DATA~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

//Telemetry Power Supply
function setCurrentPowerSupply(telemetryIds20){
	telemetryPowerSupply = new Object();
	telemetryPowerSupply.ID = CONST_TELEMETRY_MEASValue_Tx_PowerSupply;
	
	value = new Object();
		value.RemPowerTime = "";
		value.IsRunOnDC = -1;
		value.IsReserve = -1;
		value.Voltage = "";
		value.InputVoltage = "";
		value.MainVoltage = "";
		value.ReserveVoltage = "";
			cell = new Object();
			cell.Status = "";
			cell.Voltage = "";
			cell.Capacity = "";
			cell.Temperature = "";
		cells = new Array (cell);
		value.Cells = cells;

	telemetryPowerSupply.Value = value;

	telemetryIds20.push(telemetryPowerSupply);
	
	return telemetryIds20;
}

//Set Tx TRX Status Word
function setTxTRXStatusWord(telemetryIds){
	telemetryTxTRXStatusWord = new Object();
	telemetryTxTRXStatusWord.ID = CONST_TELEMETRY_Tx_TRXStatusWord;
	telemetryTxTRXStatusWord.Value = 0;
	
	telemetryIds.push(telemetryTxTRXStatusWord);
	
	return telemetryIds;
}

//Set Tx Voltage
//function setTXvoltage(telemetryIds20){
//	telemetryTX_Voltage = new Object();
//	telemetryTX_Voltage.ID = CONST_TELEMETRY_Tx_Voltage;
//	telemetryTX_Voltage.Value = 0;
//	telemetryTX_Voltage.ValueStr = "";
//	
//	telemetryIds20.push(telemetryTX_Voltage);
//	
//	return telemetryIds20;
//}

//Set Numpad Rotery Control
function setRotaryControl(controlIds){
	numpad_Control_Value = new Object();
	numpad_Control_Value.ID = CONST_CTRL_VirtualRotaryNumpad;
	numpad_Control_Value.Value = 0;
	
	controlIds.push(numpad_Control_Value);
	
	return controlIds;
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~EVENT HANDLER FUNCTIONS~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function shutDown(){
	GetTd({"cmd":0x0215}, "noEvent", "command");
}

//TODO -> in rotary encoder 9.1.1 ist schon mal ein funktionsaufruf (und modelconfig)
function onError(e, text, isLinuxError){
	if(typeof text == "undefined"){
		text = "Error: ";
	}
	
	if(isLinuxError){
		//TODO hier werden die texte von yaroslaw an die shoiwdialogbox �bergeben bzw ausgewertet nach fehler codes
	}
	else{
		try{
			stack = e.stack.split("at ");
			log(1, text + stack[0] + " at " + stack [1] + " at " + stack [2]);
		}
		catch(err){
			log(1, "Error onError: unable to decode stack from another Error!");
		}
		finally{
			log(1, text + e.name + " - " + e.message);
		} 
	}
}

//EVENT-Handler CONTROL/TELEMETRY Intervaldata
function onEVENT_CONTROL(e){
	try{
	//Control-Data
		for(var i in e.EventData.Control_Val){
			var key = e.EventData.Control_Val[i].ID;
			var value = e.EventData.Control_Val[i].Value;
			
			if(key == CONST_CTRL_VirtualRotaryNumpad){
				handleRoteryControl(value);
			}
			else{
				handleEventControl("control", e, key, value);
			}
		}
		
		//Telemetry
		for(j in e.EventData.Telemetry_Val){
			key = e.EventData.Telemetry_Val[j].ID;
			value = e.EventData.Telemetry_Val[j].Value;
			valueStr = e.EventData.Telemetry_Val[j].ValueStr;
			
//			if(key == CONST_TELEMETRY_Tx_Voltage){
//				handleTX_Voltage(value);
//			}
			if(key == CONST_TELEMETRY_MEASValue_Tx_PowerSupply){
				handleTxpowerSupply(value);
			}
			else if(key == CONST_TELEMETRY_Tx_TRXStatusWord){
				handleTxTRXStatusWord(value);
			}	
			else{
				handleEventControl("telemetry", e, key, value, valueStr);
			}
		}
		
		if(typeof e.EventData.Current_FM != "undefined"){
			handleEventControl("flightmode", e);
		}
		
		if(g_isAdditionalControlObjectUsed){
			handleEventControl("AdditionalControlObject", e);
		}
	}catch(err){
		onError(err, "Error Intervaldata: ", false);
	}	
}


function onEVENT_LINUX(e){
	for(var i in e.EventData.Event){
		var type = e.EventData.Event[i].Type;
		var data = e.EventData.Event[i].Data;

		switch(type){
			case 360:	if(g_isRfConnected == 0){
						  	closeDialogboxByTimer(data.ShowTime)
						  	showDialogbox("info", data.Info);
					  	}
					  	else{
						   showDialogbox("rfConnected", data.Warning, data.Info, data.ShowTime);
					  	}
					  	break;
			case 361:	clearTimeout(g_dialogBoxTimeoutFunction); showDialogbox("info", data.Info); break;
		}
	}
}

//Rotery Control Handler
function handleRoteryControl(value){
	//value/=50;
	if(typeof preControlRoteryValue == 'undefined'){
		preControlRoteryValue = value;
	}
	else{
		if(preControlRoteryValue != value){
			calculatedValue = Math.abs(value - preControlRoteryValue);
			
			if(calculatedValue != (Math.abs(Math.abs(value) - Math.abs(preControlRoteryValue)))){
				if((Math.abs(preControlRoteryValue) + Math.abs(value)) > 2048){
					log(3, "rotery overflow detected at 2048");
					calculatedValue -= 4096;
				}
				else{
					log(3, "rotery overflow detected at 0");
				}
			}
			
			if(preControlRoteryValue > value){
				calculatedValue *= -1;
			}

			preControlRoteryValue = value;
			
			if(numpadOpen){
				changeNumpadValue('control', calculatedValue);
				log(3, "Value raw : " + value + "   calculated:" + calculatedValue);
			}
			else if(location.pathname == "/9.2.0__CurveEdit.html"){
				change_curve(calculatedValue);
			}
		}	
	}
}

//Power Supply Handler
function handleTxpowerSupply(value){
	if(typeof htmlObj_Battery == 'undefined'){
		htmlObj_Battery = document.getElementById('Battery_Value');
	}
	try{
		g_isRunOnDC = value.IsRunOnDC;
		g_isReserve = value.IsReserve;
		g_isCharging = true;
		
		//RemPowerTime or power icons
	//	if(typeof isBGset == "undefined"){
	//		isBGset = false;	
	//	}
	//
	//	if(typeof isBGsetNone == "undefined"){
	//		isBGsetNone = false;
	//	}
		
		if(typeof powerState == "undefined"){
			powerState = "-.-"; 
		}
		
		if(typeof powerPreState == "undefined"){
			powerPreState = "-.-"; 
		}
		
		if(g_isRunOnDC){
			if((value.Cells[0].Status == 1) || (value.Cells[1].Status == 1) || (value.Cells[2].Status == 1) || (value.Cells[3].Status == 1)){
				if(g_isCharging){
					powerState = "runOnDc_charging_warning";
				}
				else{
					powerState = "runOnDc_warning";
				}
			}
			else{
				if(g_isCharging){
					powerState = "runOnDc_charging";
				}
				else{
					powerState = "runOnDc";
				}
			}	
			
		}
		else{
			if((value.Cells[0].Status == 1) || (value.Cells[1].Status == 1) || (value.Cells[2].Status == 1) || (value.Cells[3].Status == 1) || g_isReserve || (value.ReserveVoltage < 3900)){
				powerState = "warning";
			}
			else{
				powerState = "normal"
			}
		}
		
		if(powerState != powerPreState){
			var htmlBackgroundUrl = "";
			var htmlInnerText = "";
			switch (powerState){
				case "runOnDc_charging_warning": htmlBackgroundUrl = "url('" + CONST_BATTERYICON_ALL + "')"; break;
				case "runOnDc_warning": htmlBackgroundUrl = "url('" + CONST_BATTERYICON_PLUGWARNING + "')"; break;
				case "runOnDc_charging": htmlBackgroundUrl = "url('" + CONST_BATTERYICON_CHARGING + "')"; break;
				case "runOnDc": htmlBackgroundUrl = "url('" + CONST_BATTERYICON_PLUG + "')"; break;
				case "warning": htmlBackgroundUrl = "url('" + CONST_BATTERYICON_WARNING + "')"; break;
			}
			htmlObj_Battery.style.backgroundImage = htmlBackgroundUrl;
			htmlObj_Battery.innerHTML = htmlInnerText;
			powerPreState = powerState;
		}
		
		if(powerState == "normal"){
			htmlObj_Battery.innerHTML = value.RemPowerTime;
		}
		
	//	if(g_isRunOnDC){
	//		if(!isBGset){
	//			htmlObj_Battery.style.backgroundImage = "url('" + CONST_BATTERYICON_CHARGING + "')";
	//			htmlObj_Battery.innerHTML = "";
	//			isBGset = true;
	//			isBGsetNone = false;
	//		}
	//	}
	//	else{
	//		if(!isBGsetNone){
	//			htmlObj_Battery.style.backgroundImage = "none";
	//			isBGset = false;
	//			isBGsetNone = true;
	//		}
	//		
	//		//htmlObj_Battery.innerHTML = value.toFixed(2) + " V";
	//		htmlObj_Battery.innerHTML = value.RemPowerTime;
	//	}
		
		//Battery Manager
		if(g_currentLocation == "/2.1__BatteryManager"){
			if(typeof reverseCell == "undefined"){
				var reverseCell = -1;
			}
			if(typeof reverseCellPreState == "undefined"){
				var reverseCellPreState = -2;
			}
			for(var batteryCount = 0; batteryCount < value.Cells.length; batteryCount++){
				setHTML("Battery_Capacity_" + (batteryCount + 1), value.Cells[batteryCount].Capacity);
				setHTML("Battery_Voltage_" + (batteryCount + 1), value.Cells[batteryCount].Voltage);
				var cellStatus = parseInt(value.Cells[batteryCount].Status, 16);
				var isCellReserve = 0x10&cellStatus;
				if(isCellReserve){
					reverseCell = batteryCount + 1;
				}
				
				if(isCellReserve && (value.ReserveVoltage <= 3900) && !(0x1&cellStatus)){
					$("#Battery_Health_" + (batteryCount + 1)).addClass("battery_status_warning").removeClass("battery_status_okay battery_status_damaged");
				}
				else{
					if(0x1&cellStatus){
						$("#Battery_Health_" + (batteryCount + 1)).addClass("battery_status_damaged").removeClass("battery_status_okay battery_status_warning");
					}
					else{
						$("#Battery_Health_" + (batteryCount + 1)).addClass("battery_status_okay").removeClass("battery_status_damaged battery_status_warning");
					}
				}
	
				
				if(!g_isRunOnDC){
					if(g_isReserve){
						if(isCellReserve){
							$("#Battery_" + (batteryCount + 1)).addClass("active_battery");
						}
						else{
							$("#Battery_" + (batteryCount + 1)).removeClass("active_battery");
						}
					}
					else{
						if(isCellReserve){
							$("#Battery_" + (batteryCount + 1)).removeClass("active_battery");
						}
						else{
							$("#Battery_" + (batteryCount + 1)).addClass("active_battery");
						}
					}
				}
				else{
					$("#Battery_1").removeClass("active_battery");
					$("#Battery_2").removeClass("active_battery");
					$("#Battery_3").removeClass("active_battery");
					$("#Battery_4").removeClass("active_battery");
				}
				
			}
	
			
//			if(reverseCell != reverseCellPreState){
//				
//			}
		}
		
		//Battery Icon
		if(typeof batState == 'undefined'){
			batState = "-.-";
		}
	
		if((!g_isRunOnDC && !g_isReserve) || (g_isRunOnDC && (value.ReserveVoltage > 4100))){
			valueVoltage = value.MainVoltage;
			setClassRed = false;
			
		}
		else if(!g_isRunOnDC && g_isReserve || (g_isRunOnDC && (value.ReserveVoltage <= 4100))){
			valueVoltage = value.ReserveVoltage;
			setClassRed = true;
		}
		else{
			valueVoltage = "-.-";
			setClassRed = false;
		}
		
		batState = showBatterySegements(valueVoltage, setClassRed, batState);
	}catch(err){
		onError(err, "Error TX Powersupply: ", false);
	}
}

//TX Voltage Handler
function handleTX_Voltage(value){
//	value/= 1000;
//	
//	if(typeof batState == 'undefined'){
//		batState = "-.-";
//	}
//
//	batState = showBatterySegements(value, batState);
}

//Tx_TRX Status Word Handler
function handleTxTRXStatusWord(value){
	g_isBindingActive = 1&value;
	g_isRfConnected   = 4&value;
}

//Keypress Handler
function onEVENT_KEYPRESS(e){
	var char = e.charCode;
	
	if((char == 98) || (char == 110)|| (char == 109) || (char == 103) || (char == 104) || (char == 106)){
		ScrollTo(char);
	}
	
	if((char == 80) || (char == 112)){
		GetTd(EventDataPostArgs, g_LinuxEvent, "event");
		//TODO Event array von FCGI anfragen
	}

	if(char == 45){// Das zeichen "-" von Touchscreen filtern
		if(navigator.appVersion.indexOf("X11; U; Linux armv7l; c") != -1){
			event.cancelBubble = true;
			event.returnValue = false;
		}
	}
	//alert("char: " + char +"  is pressed")
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~AJAX RQ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

var intervalSlotcount = 0;
//Json-Function	calls GetTd-Function
function JsonFunction(){
	if((intervalSlotcount % 20) == 0){
		var telemetryIdsTemp = telemetryIds.concat(telemetryIds20);
		TdPostArgs.Telemetry_Val = telemetryIdsTemp;
	}
	else{
		TdPostArgs.Telemetry_Val = telemetryIds;
	}

	GetTd(TdPostArgs, g_ControlEvent);	
	intervalSlotcount++;

	if(intervalSlotcount >= 100){
		intervalSlotcount = 0;
	}
}

//GetTd-Function --> Ajax CGI request for CONTROL/TELEMETRY interval, init and set-data	
function GetTd(postArgs, event, cmd){
	if(typeof postArgs == "undefined"){
		return;
	}
	
	if(typeof event == "undefined"){
		event = "noEvent";
	}
	
	if(typeof cmd == "undefined"){
		cmd = "noCommand";
		url = "/cgi/get_json";
	}
	else if(cmd == "event"){
		url = "/cgi/event";
	}
	else if(cmd == "command"){
		url = "/cgi/command";
//		alert(JSON.stringify(postArgs));
	}
	else if(cmd == "service"){
		url = "/cgi/service";
	}
	else if(cmd.substr(0,14) == "fileManagement"){
		url = "/cgi/filemanagement";
	}
	else{
		url = "/cgi/set_json";
	}
	log(3, "JSON string to send :" + JSON.stringify(postArgs));
	
	isRqFinished = false;
	
	$.ajax({
		type: "post",
		async : true,
		url: url,
		data: JSON.stringify(postArgs),
		dataType: "json",
		success: function(TdJson){
			//alert("success " + TdJson.Telemetry_Val[0].ID + " : " +TdJson.Telemetry_Val[0].Value);
			log(2, "success -> " + event + " :   " + JSON.stringify(TdJson));

			if((TdJson != "\n\"\"") && (TdJson != " \n[]")){
			 	var SetParam = {};
				$.event.trigger({
					type : event,
					cmd : cmd,
					EventData : TdJson
				});
				
				if(TdJson != null){
					delete TdJson;
					TdJson = null;
				}
			}
		},
		error: function (xhr, status, error){
			log(1, JSON.stringify(xhr));
			//log("error: " + "response : '" + xhr.statusCode() + "' xhr:'" + xhr.statusText + "' status:'" + status + "' error: '" + error +"'");
		}
//	}).done(function(){

	});
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~BATTERY~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

//Shows Batterysegments
function showBatterySegements(value, setClassRed, batState){
	//value = ((value - 3.5) * 100) / 0.7;
	
	if(typeof isClassRed == "undefined"){
		isClassRed = "-.-";
	}
	
	if(setClassRed && (isClassRed != "yes")){
		$('#Battery_80').addClass("red");
		$('#Battery_60').addClass("red");
		$('#Battery_40').addClass("red");
		$('#Battery_20').addClass("red");
		$('#Battery_0').addClass("red");
		isClassRed = "yes";
	}
	else if(!setClassRed && (isClassRed != "no")){
		$('#Battery_80').removeClass("red");
		$('#Battery_60').removeClass("red");
		$('#Battery_40').removeClass("red");
		$('#Battery_20').removeClass("red");
		$('#Battery_0').removeClass("red");
		isClassRed = "no";
	}
	
	
	if(value > 4000){
		if(batState != ">4000"){
			$('#Battery_0').removeClass("blink");
			showHTML('Battery_80');
			showHTML('Battery_60');
			showHTML('Battery_40');
			showHTML('Battery_20');
			showHTML('Battery_0');
		}
		
		return ">4000";
	}
	else if(value > 3800){
		if(batState != ">3800"){
			$('#Battery_0').removeClass("blink");
			hideHTML('Battery_80');
			showHTML('Battery_60');
			showHTML('Battery_40');
			showHTML('Battery_20');
			showHTML('Battery_0');
		}
		
		return ">3800";
	}
	else if(value > 3600){
		if(batState != ">3600"){
			$('#Battery_0').removeClass("blink");
			hideHTML('Battery_80');
			hideHTML('Battery_60');
			showHTML('Battery_40');
			showHTML('Battery_20');
			showHTML('Battery_0');
		}	
		
		return ">3600";
	}
	else if(value > 3500){
		if(batState != ">3500"){
			$('#Battery_0').removeClass("blink");
			hideHTML('Battery_80');
			hideHTML('Battery_60');
			hideHTML('Battery_40');
			showHTML('Battery_20');
			showHTML('Battery_0');
		}
		
		return ">3500";
	}
	else if(value > 3400){
		if(batState != ">3400"){
			$('#Battery_0').removeClass("blink");
			hideHTML('Battery_80');
			hideHTML('Battery_60');
			hideHTML('Battery_40');
			hideHTML('Battery_20');
			showHTML('Battery_0');
		}	
		
		return ">3400";
	}
	else if(value <= 3400 ){
		if(batState != "<3400"){
			$('#Battery_0').addClass("blink");
			hideHTML('Battery_80');
			hideHTML('Battery_60');
			hideHTML('Battery_40');
			hideHTML('Battery_20');
			showHTML('Battery_0');
		}
		
		return "<3400";
	}
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~CONTROL TO IMAGE FUNCTIONS~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

/*BAT 60 specific*/
//Converts a Control-ID and Trigger to an image shown in the lists
function control2image(id, control_id, control_trigger){
	var control_image = new String;

	switch(control_id){
		case CONST_CTRL_SwitchFixedOn:			/*Control_Fixed_Switch_On*/							control_image = "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"; break;
		case CONST_CTRL_SwitchFixedOff:			/*Control_Fixed_Switch_off*/						control_image = "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"; break;
		
		//Sticks
		case CONST_CTRL_StickLeftVert:			/*Control_Top_Stick_L_UD.png*/						control_image = "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"; break;
		case CONST_CTRL_StickLeftHori:			/*Control_Top_Stick_L_LR.png*/						control_image = "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"; break;
		case CONST_CTRL_StickRightVert:			/*Control_Top_Stick_R_UD.png*/						control_image = "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"; break;
		case CONST_CTRL_StickRightHori:			/*Control_Top_Stick_R_LR.png*/						control_image = "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"; break;

		//Rotary Encoders 
		case CONST_CTRL_RotaryLeftUp:			/*Control_Top_RotaryEncoder_L_3.png*/				control_image = "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"; break;
		case CONST_CTRL_RotaryLeftMiddle:		/*Control_Top_RotaryEncoder_L_2.png*/				control_image = "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"; break;
		case CONST_CTRL_RotaryLeftBottom:		/*Control_Top_RotaryEncoder_L_1.png*/				control_image = "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"; break;
		case CONST_CTRL_RotaryStickLeft:		/*Control_Top_StickSwitch_L_Potentiometer.png*/		control_image = "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"; break;
		case CONST_CTRL_RotaryRightUp:			/*Control_Top_RotaryEncoder_R_3.png*/				control_image = "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"; break;
		case CONST_CTRL_RotaryRightMiddle:		/*Control_Top_RotaryEncoder_R_2.png*/				control_image = "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"; break;
		case CONST_CTRL_RotaryRightBottom:		/*Control_Top_RotaryEncoder_R_1.png*/				control_image = "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"; break;
		case CONST_CTRL_RotaryStickRight:		/*Control_Top_StickSwitch_R_Potentiometer.png*/		control_image = "iVBORw0KGgoAAAANSUhEUgAAAFUAAAA9CAYAAADcUiVtAAAACXBIWXMAAAsTAAALEwEAmpwYAAAKT2lDQ1BQaG90b3Nob3AgSUNDIHByb2ZpbGUAAHjanVNnVFPpFj333vRCS4iAlEtvUhUIIFJCi4AUkSYqIQkQSoghodkVUcERRUUEG8igiAOOjoCMFVEsDIoK2AfkIaKOg6OIisr74Xuja9a89+bN/rXXPues852zzwfACAyWSDNRNYAMqUIeEeCDx8TG4eQuQIEKJHAAEAizZCFz/SMBAPh+PDwrIsAHvgABeNMLCADATZvAMByH/w/qQplcAYCEAcB0kThLCIAUAEB6jkKmAEBGAYCdmCZTAKAEAGDLY2LjAFAtAGAnf+bTAICd+Jl7AQBblCEVAaCRACATZYhEAGg7AKzPVopFAFgwABRmS8Q5ANgtADBJV2ZIALC3AMDOEAuyAAgMADBRiIUpAAR7AGDIIyN4AISZABRG8lc88SuuEOcqAAB4mbI8uSQ5RYFbCC1xB1dXLh4ozkkXKxQ2YQJhmkAuwnmZGTKBNA/g88wAAKCRFRHgg/P9eM4Ors7ONo62Dl8t6r8G/yJiYuP+5c+rcEAAAOF0ftH+LC+zGoA7BoBt/qIl7gRoXgugdfeLZrIPQLUAoOnaV/Nw+H48PEWhkLnZ2eXk5NhKxEJbYcpXff5nwl/AV/1s+X48/Pf14L7iJIEyXYFHBPjgwsz0TKUcz5IJhGLc5o9H/LcL//wd0yLESWK5WCoU41EScY5EmozzMqUiiUKSKcUl0v9k4t8s+wM+3zUAsGo+AXuRLahdYwP2SycQWHTA4vcAAPK7b8HUKAgDgGiD4c93/+8//UegJQCAZkmScQAAXkQkLlTKsz/HCAAARKCBKrBBG/TBGCzABhzBBdzBC/xgNoRCJMTCQhBCCmSAHHJgKayCQiiGzbAdKmAv1EAdNMBRaIaTcA4uwlW4Dj1wD/phCJ7BKLyBCQRByAgTYSHaiAFiilgjjggXmYX4IcFIBBKLJCDJiBRRIkuRNUgxUopUIFVIHfI9cgI5h1xGupE7yAAygvyGvEcxlIGyUT3UDLVDuag3GoRGogvQZHQxmo8WoJvQcrQaPYw2oefQq2gP2o8+Q8cwwOgYBzPEbDAuxsNCsTgsCZNjy7EirAyrxhqwVqwDu4n1Y8+xdwQSgUXACTYEd0IgYR5BSFhMWE7YSKggHCQ0EdoJNwkDhFHCJyKTqEu0JroR+cQYYjIxh1hILCPWEo8TLxB7iEPENyQSiUMyJ7mQAkmxpFTSEtJG0m5SI+ksqZs0SBojk8naZGuyBzmULCAryIXkneTD5DPkG+Qh8lsKnWJAcaT4U+IoUspqShnlEOU05QZlmDJBVaOaUt2ooVQRNY9aQq2htlKvUYeoEzR1mjnNgxZJS6WtopXTGmgXaPdpr+h0uhHdlR5Ol9BX0svpR+iX6AP0dwwNhhWDx4hnKBmbGAcYZxl3GK+YTKYZ04sZx1QwNzHrmOeZD5lvVVgqtip8FZHKCpVKlSaVGyovVKmqpqreqgtV81XLVI+pXlN9rkZVM1PjqQnUlqtVqp1Q61MbU2epO6iHqmeob1Q/pH5Z/YkGWcNMw09DpFGgsV/jvMYgC2MZs3gsIWsNq4Z1gTXEJrHN2Xx2KruY/R27iz2qqaE5QzNKM1ezUvOUZj8H45hx+Jx0TgnnKKeX836K3hTvKeIpG6Y0TLkxZVxrqpaXllirSKtRq0frvTau7aedpr1Fu1n7gQ5Bx0onXCdHZ4/OBZ3nU9lT3acKpxZNPTr1ri6qa6UbobtEd79up+6Ynr5egJ5Mb6feeb3n+hx9L/1U/W36p/VHDFgGswwkBtsMzhg8xTVxbzwdL8fb8VFDXcNAQ6VhlWGX4YSRudE8o9VGjUYPjGnGXOMk423GbcajJgYmISZLTepN7ppSTbmmKaY7TDtMx83MzaLN1pk1mz0x1zLnm+eb15vft2BaeFostqi2uGVJsuRaplnutrxuhVo5WaVYVVpds0atna0l1rutu6cRp7lOk06rntZnw7Dxtsm2qbcZsOXYBtuutm22fWFnYhdnt8Wuw+6TvZN9un2N/T0HDYfZDqsdWh1+c7RyFDpWOt6azpzuP33F9JbpL2dYzxDP2DPjthPLKcRpnVOb00dnF2e5c4PziIuJS4LLLpc+Lpsbxt3IveRKdPVxXeF60vWdm7Obwu2o26/uNu5p7ofcn8w0nymeWTNz0MPIQ+BR5dE/C5+VMGvfrH5PQ0+BZ7XnIy9jL5FXrdewt6V3qvdh7xc+9j5yn+M+4zw33jLeWV/MN8C3yLfLT8Nvnl+F30N/I/9k/3r/0QCngCUBZwOJgUGBWwL7+Hp8Ib+OPzrbZfay2e1BjKC5QRVBj4KtguXBrSFoyOyQrSH355jOkc5pDoVQfujW0Adh5mGLw34MJ4WHhVeGP45wiFga0TGXNXfR3ENz30T6RJZE3ptnMU85ry1KNSo+qi5qPNo3ujS6P8YuZlnM1VidWElsSxw5LiquNm5svt/87fOH4p3iC+N7F5gvyF1weaHOwvSFpxapLhIsOpZATIhOOJTwQRAqqBaMJfITdyWOCnnCHcJnIi/RNtGI2ENcKh5O8kgqTXqS7JG8NXkkxTOlLOW5hCepkLxMDUzdmzqeFpp2IG0yPTq9MYOSkZBxQqohTZO2Z+pn5mZ2y6xlhbL+xW6Lty8elQfJa7OQrAVZLQq2QqboVFoo1yoHsmdlV2a/zYnKOZarnivN7cyzytuQN5zvn//tEsIS4ZK2pYZLVy0dWOa9rGo5sjxxedsK4xUFK4ZWBqw8uIq2Km3VT6vtV5eufr0mek1rgV7ByoLBtQFr6wtVCuWFfevc1+1dT1gvWd+1YfqGnRs+FYmKrhTbF5cVf9go3HjlG4dvyr+Z3JS0qavEuWTPZtJm6ebeLZ5bDpaql+aXDm4N2dq0Dd9WtO319kXbL5fNKNu7g7ZDuaO/PLi8ZafJzs07P1SkVPRU+lQ27tLdtWHX+G7R7ht7vPY07NXbW7z3/T7JvttVAVVN1WbVZftJ+7P3P66Jqun4lvttXa1ObXHtxwPSA/0HIw6217nU1R3SPVRSj9Yr60cOxx++/p3vdy0NNg1VjZzG4iNwRHnk6fcJ3/ceDTradox7rOEH0x92HWcdL2pCmvKaRptTmvtbYlu6T8w+0dbq3nr8R9sfD5w0PFl5SvNUyWna6YLTk2fyz4ydlZ19fi753GDborZ752PO32oPb++6EHTh0kX/i+c7vDvOXPK4dPKy2+UTV7hXmq86X23qdOo8/pPTT8e7nLuarrlca7nuer21e2b36RueN87d9L158Rb/1tWeOT3dvfN6b/fF9/XfFt1+cif9zsu72Xcn7q28T7xf9EDtQdlD3YfVP1v+3Njv3H9qwHeg89HcR/cGhYPP/pH1jw9DBY+Zj8uGDYbrnjg+OTniP3L96fynQ89kzyaeF/6i/suuFxYvfvjV69fO0ZjRoZfyl5O/bXyl/erA6xmv28bCxh6+yXgzMV70VvvtwXfcdx3vo98PT+R8IH8o/2j5sfVT0Kf7kxmTk/8EA5jz/GMzLdsAAAAgY0hSTQAAeiUAAICDAAD5/wAAgOkAAHUwAADqYAAAOpgAABdvkl/FRgAAC1pJREFUeNrsnG1MW+cVx39+BQOJ8QXHBGgcDAUDTSAvZcqqMK1dk0zd2iG1StoIqerLok7r2g/ttJWqn5ZuH6ZIa9dKUzcta7SurSp1W6smadMpQNUqqao0saHgJYBJHXAAQzDgF2yzD9jGL9evGMKS/CXE9b33OT73f89zznn+94Lkm2++IYdQAzXB7TKgIrhdEzwWi02ANom9RONC6AdmsvAzNM4GfA2YgMFcEGA0GpEvY3wF0Bz82RH8XcXqoi7LcTtE9jmATuAd4D3An61T2ZBaBPwKeB5QcuNAANqCP73As8An2RiSZnh+GdANdNxghMaiAfgY+HswiFaM1Brg8+A0v1nwCHABaFkJUpuDEVrFzYeq4LXvzyWpu4DTwal/s0IJvA08lQtS7wY+TdHW3Ex4PVhP0q/+h491hbc72lvbgndHeYvLKPwGUB0+1vViBFepW6qO9tZ24K+ALNNvjLkxa5KVHPjY0dHeqjx8rOuXafWpHe2tPwdeXcmLcs55OHHmIpeuOKguF9j3nRrWFeStOZsp8HxHe6v68LGuQ0lzajBCX13pSPngcwuWbyfwBxawfDvBPz/rW5M208BPO9pb/5yMVO1qEApgG5tO+nmt2EwTjwPPJJr++0NVfqXzYoV2PYMjk1Gf16LNDPLxM8AfxCL17tW6tT/aVUt1uQBAdbnAA3cZ16TNDBcIRWKRumW1PFhfmMeBe+5Y8zaz0EUuxpIq5MLyWm2jVsFHbYjUyOl/a9W0PBTF5lQhm0b/FsRJledy6q81WCwWnE4nO3ZEC/3z8/P09PRgsVhwu93YbDaqq6uprKxEEASMxvgi19nZSW1tbUakqv/f8mI6hL744IOopVLufeEF2traOH78OB999BFfdHWxQ6Fgi1KJSiJhu0xGr8/HZz4fY34/fTIZe/bs4eGHH6a5uZmjR49ifuUVTF4vRz/5hI0bNyYlVRJ88Hcvi0r3DYMjR45gePdd9qlU7BwdRSaRsL+ggP0qFftUqqS5zrWwwHtzc/xxZoZpg4GB/n56ysr4y+ws3iee4MknnxQb9mvgd0ajEWlXV9cNOf07Ozu5T6WiWaHgzZISBjZu5E1B4L4UhAKoJBLaCws5o9Pxj6kp3hQEauRy2lQqTp06lWiYOshl9jnV7/djt9txOBz865wjvP+BbQKCIKDT6ZDJZNdt6ucNDrKlbFFXf6SgIO4c0/w8Z71exvx+Bv1+auRytFIpLUolDQpF+LxmhYLm4OcWpZKpnh5GRkbEUsDyCtX4+DgXL17E6/XGHXM4HDgcDoaHh6mpqaG0tPS6RWksxgIBjjidHJudhbIyNtfXMxVYR1FxKZ9NXqVYOsMLg4OUjo7yVFER7YWFFEkkUTYeLCjg5MmTPProo7kj9fLlywwOpn7vwOv10tvby+bNm9m0adOqkvrhhx/ynkh03nP1Kvq9e/nF7t0UFxcD0G1dOr5bHxRjbDbe6ezk/TNn+Fgb/a5Hm0rFs6dOJSVVmgmpY2NjaREaiaGhIcbHx1eNUL/fzyWLhfddLk643TgCgfCx36rVWK3WMKEJxZmKCmw2Gy+tXxJlHIEAJ9xu/uPx8PVXX+H3+1OSqk7H2YGBgawu9NKlS2JOrAhkMhmnu7uxHzzIy0YjhpkZbh8Z4eDEBBd9Pujrw2azJbVhtVpRDw9z1uvlwMQEt4+MYJiZ4WWjEfvBg5zu7harF5lPf7vdjsfjyepCPR4Pdrud8vLydKW0ZclxpaWlPP300+F9X375JZ2dnXwwNETbXXdRUbH4ildPTw+nj3dyZaCHckMjwg+/R2NjI3q9nr3PPcfxs2epqqripd27ufPOO1O5oY4lVZtqxMTEhOj+vLw8Hvp+DdXlAkOjk4xf/q8o+RMTE6KkproZg4ODXLt2bdFrtZqqqiry8jJ7TJKfn09LSwstLUvvRJw7d44P3niD1zUa9m0s48SkjZ+99hquxx5j586d6PV69Hp9eHw2y9SUr7b8++tJ0f2P/KCWt06Zwp/b9zRx7OPzInNqki0ZiItut5tz584xPz8f3nf16lUmJyfZtm1buhea0PdPT3byN0Hg3qCd+1Uq1FIp+0924tLuzMb3zHNqwqQeo7DnSnEfGBiIIjRy3Z5tbo8qurYBdsVE/C6lkjFb1rbjSFVla+nKuDPmc26eDU1NTWV1LG3xs8LAFzFp6guvF22FIVuTqtbWVhmAPLiR8oWJ+5s1TE7GT6OrwxYO3HMH1eUCl644GBnqD/d7kUjVxsTC5/NldUwMP24qjrsRRXu/xxNvvMGfBIF9+fmccLs55HBw/2MPsFOfte9FwDU5UDQxMUFJSUnSs0tKSkRJdbvdvP2pOa6BjsX1WFlFfncsqdu2bUN66BCPn1iq/j956CGampqy8j3IoTpEqtpisVBXV4cgJO6sdDodw8PDokvTVFAqleh0uutGqk6nw2q1xuXopqYmpouXSGzSZ+e7w+HAYrGwa9euolBOVS0sLNDb28v09HTSprq6ujqri6qurr5u4krI95qamhXxfXp6mt7eXhYWFsLFSh7aCAQCmM1mmpqaKCwsFE/uWi0ul4uhoaG0ndq8eTNabeI2OBeCeDo2tFotc3NzWK3WnPk+OzuL2WwmEAgglUrDpEojK7/P58NkMuFyuRIa2rRpEw0NDSgi5DExKBQKGhoaUoop3ResdF+wLpvYdOzo9frFvx6Ry5ftu8vlwmQyxRbNcKSqY9Uls9nM1q1bE65cSktL0Wg0jI6O4nA4wLpUwDQaDYIgUFZWlnLKd1+w0nV+iYjdW/VZE5qunQ0bNlBSUrIs3z0eD2azWay+hElVSWI0Q5fLFU4Fie6qTCajoqKCioqKjFZKiYhYTEnZIXJsyGYyYpfju8/nw2w2x83mIIfq0PQvMhqNoZwQlS9MJhOBCOksVxCLrNYmfdb2Wpv0USR2nc9NSolFIBDAZDIxOzsbtV8qlYaewC7lVI1GQ0NDA7ER63Q6IyvbqhKaLO+JHVtpYkMdktPpjIvQhoYGNBpNOFLDOVUQBBobG+np6Yki0eFw0NfXh9FojCLdM+/j929/nlFlziRCi4uLE4rbiVY4IVshMsVSQaRMmAjPHfgueQp5FKF9fX2LOTiG0MbGxsj+Phyp4SWqIAjU19fHRezY2BjDw8M5uNukPeUNBoNohyGXy6mqqko7FeRiklmtVsbGxuIIra+vj10wKcOFKrayG41G+vr6oiJ2eHiYDRs2oFKplpX7xLYTaaDbt29nYGAgSk81GAwp9dRMvicVXC4Xly9fjiPUaDSKLV9lsPgyxeuI/H2Q3W6nv78/brlXV1fHzYT+/n7sdnvUvrq6ukRL17eMRuNBaSLZT6fTYTAY4tLASnQDaxWBQCBu2hsMhpRagDyZ7FdZWcn09HS4YAQCAaamppIKL8ngdrvDKxC32y0qQse2dbGdh0QiSbiMjuxDCyIeURcUFMS1jOlqupFBVFpaSmVlZbIhatEVVSxqa2uZnZ0NN7tipHq9XrxeL06nk/n5eTweD3Nzc/j9flwu16o9SU1XMVMqleTn56NQKCgoKEAmkyEIAkpldHyFcjmASqVK9dZfVKQmrTxyuZza2lrOnz8fTtxi+TfT9wGuF0IBMDMT/Q8tqqqquO2226L2zc3NRQVXKs0gxKWUNFR/tVodjs5kYsuNhtC1CoKAWp3WYzxliNS0zg49Xk6VB28khK41g0frshCpaanHGo0GuVy+pvJjLiGmSvn9fuRyeWgJmg7CK6q0/p2FRCJh3bp1BAKBnGoBaxULCwsEAgHWr18ft8JMhYz6jFB1vFGjNTZKgZRivFhLlXZOTTRFbnRkc81SbiGXUGWUU28hvQyZUfW/hcxIvYXc1QsVwP8GAEFJhcOY6ly0AAAAAElFTkSuQmCC"; break;
		
		//Switches
		case CONST_CTRL_SWLeftFront1:			/*Control_Front_Switch_L_1.png*/					control_image = "iVBORw0KGgoAAAANSUhEUgAAAFUAAAA9CAYAAADcUiVtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAOISURBVHja7JtNaBNBFMffbtI06QcplSaStAehNrSgFAoePMST4EEoghB6ELzqybvQQ8G7UPDQq5RS9SQVCt5i8VYQe2giFQ9tgk1RD02/kjbxve2upjEx2XUju+n/D4+Znd3ZffPbtzOTmVYpl8sE2SsFUAEVUAEVAlRABVQIUAEVUCFAdRjUubm5P07E4/G7nNxiG2ebqFX54OCAMpkMZbPZtoISiUQoGo1SIBCod8kq2we25WQy+aohVIYpIJ+yxZp1Ip1O0/b2dlsADYfDFIvFzFRJsz1iuMtGgVoVnQ84WTIDVDQyMkJ9fX2uByptkLaYlLBa0tmdhcqFNziZZfOY7kMUhcbGxigYDLoWqPgubZC2WJAwm9UZnn7+qVTKx/kU26V/cUzuJX1sLpejfD7vCpg9PT0UCoW0PtQi0Ep9YbtsQJVB6SXGbVs0aXz+d8DCNiUMqBNgYZvGDagXwcI2RQ2oQbCwbyKhgoH9AtQWyFur8MnzZMOKj+/FzwUgKywQqfj83SHjFxUWVVvZp87MzNDCwkLDilNTUzQ9PQ2CzUTq6OgolYeGGlfc3KT19XUMVBioMFC5u0/d2dnZ4G5guKurixKJBCmLi031qedBzczHj4+P6fDwkPb39+UwpfWp8/Pz14+Ojt7wSW1PRBZru7u7ye/3U0dHh5aXMq/X+2szTFKPx9PWQE9OTrTNTZGkAk947e3tUbFY1EBK3tiRZj4/Ojs7b2uRyifecxKm093Tm6qqXmPqg/l8PtKw/1DVEke43FUj3Nvbe+a8gK/eleQHk8/nM9VAebkiaYwZFQoF4oA5UyaABFildnd3y6VSSSPIsPycb9g1cqBtMdDPnF1je8vQl9kKlVOqAttrseoH6hqn3/tXUdKXC/nhPoZ/hbNC6b5sozDIT/KijYp8zQV+eMgR0x1FyXEgfNP9KrJfJb1tspfyQuewpqeir2wZI3jpdGtaU72/mai7729BAnpLzw9WOFJLtby5qr+Yag2zPWPr14+/sz1k26gVmGwfa7XTJr+tL6hY1EBV3qxza3XKV/V7vdOPJ9lWHOR3S6dU/RV5uxe9V+rkHem3nVCDdRx1umz3u1WR6iao/YDqAqitHKj+OrOxMhuy+TorfiNS8fkDKqC2wzz1f0ENOhnqgEuhYqByqt/475QWCFABFVABFQJUQAVUCFABFVAhQHWQfgowADvKcajhaZaCAAAAAElFTkSuQmCC"; break;
		case CONST_CTRL_SWLeftFront2:			/*Control_Front_Switch_L_2.png*/					control_image = "iVBORw0KGgoAAAANSUhEUgAAAFUAAAA9CAYAAADcUiVtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAOxSURBVHja7JxNaBNREMdnN2maNi0JlSaSpAchVlJQCgWPEQRBEBRBkB7EQk968q70UPAuFDz06iEgnqRCwVtSvBWKPTR+IbRNsQH10KQfSZs4s32rm+3G7W43ZTedP0zf288375f3Zl92QqVGowEsZyUzAobKUBkqi6EyVIbKYqgMlaGyGKp75Kc/s7OzRw5kMpl7WNxEG0UbM7p4Z2cHisUibGxsdBSUeDwOiUQCenp6Wp2yiLaENp/L5d4YQtXBJJAv0C6ZNU6NplIpODg4gM3NzY4AGovFlD6ZaEzYJPL6hOUThDtvOP3xhEdYzB0HqFbDw8MQiUQ8D5T6QH2xKGI1J9g1Q8Wd17CYQfNZvaskSTAyMgLhcNizQMl36gP1xYaI2YxgCBK9Ty0UCgGsF9AunMQxuhfF2FKpBOVy2RMw+/r6IBqNKjHUJlCtvqNdVGPq7ZMCVUdsMplU7IyKGN5Sp/9dXgg5pvuy5mnGckajKtTzzMIxJVSoYWbh3EKCv6a262uqVtPT05DNZk0vHB8fh6mpKSZotAoS69S/yf90Og2NoSHzC9fWYGVlpeMBPX+VMz3n6YNM0zZP/zaIoZ5GTKVYKR0zpp4F6ae2rZjKasNItRuc+UHFMZUfVJ5cp+bz+S9Ypnp7eyEYDILf72cyFrS/vw+7u7uwvb1NmwWF3urq6sO9vb13eFDJidB70VAopADu6upS6rSPYKvJMCp9Pl9Hw6LcGyU3SVQSPBqElUoFarWaApLq6g+nkc/v7u7uSQUqHviARQwOs6c3ZFm+itST5XI5bho/ZLmOI5zuqhDu7+9vOk7g9VlJbBgCgYClDtKHS6LOWFG1WgUcME37CBAB02pra6tRr9cVgggriHXT0IgDbR2BfsPqMtp7hD6PVtXO8yraWzJ9g0Kj8C9/lQDxuhAbDyD8y1glShOURkGQn+mDVi/Ec85h41FXxDtJKuFA+Cn8qqFfddE3yqW8FhyWRUn6gVZUBy8cpqYVtfppv5XguaSpLxocJ9ATYtpc1zhiJCNvrogPRi/KF79EGxDbv9Aeo301GphoH41YakHoBg35vS7qz0z8tr9OtalBXd2qc8st9i+Ke+XF9h20BRf53dYl1YCm7vRL74UWdVf67STUcAtH3S7H/W7XSPUS1AGG6gGo7XxQ/XdlY2c15PB5dvzmkcrTn6Ey1E5Yp54W1LCboQ56FCo/qNzqt8T/RMF5cTqFoTJUhspiqAyVobIYKkNlqCyG6iL9EWAAlCkrxdYS1f8AAAAASUVORK5CYII="; break;
		case CONST_CTRL_SWLeftTop1:				/*Control_Top_Switch_L_2.png*/						control_image = "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"; break;
		case CONST_CTRL_SWLeftTop2:				/*Control_Top_Switch_L_1.png*/						control_image = "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"; break;
		case CONST_CTRL_SWStickLeft:			/*Control_Top_StickSwitch_L_UD.png*/				control_image = "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"; break;
		case CONST_CTRL_SWRightFront1:			/*Control_Front_Switch_R_1.png*/					control_image = "iVBORw0KGgoAAAANSUhEUgAAAFUAAAA9CAYAAADcUiVtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAOlSURBVHja7JxNaBNBFMffbtI06QcplSaSpAchVhJQCgUPHuJJEBRFEEIPgpBD0ZN3oYeCd6EgtFcpBfEkFQreYvFWKObQKBUPbYpNUQ9Nv5I28b3prG7TTTdJN7Kbvj+8zuznvPntm9nZmVClUqkAy1qpjIChMlSGymKoDJWhshgqQ2WoLIZqH7npz/T09IkDiUTiISa30YbRRowu3t3dhVwuB+vr620FJRQKQTgcBp/PV+uURbQltPl0Ov3WEGoVTAL5Eu2KWeFUaDQahcPDQ9jY2GgLoMFgUNTJRCPSUsjrC6bPEO68YfPHE55gMlcPUL2Ghoagr6/P8UCpDlSXBkWs5iS741Bx501MJtFcjd5VURSIx+Pg9/sdC5R8pzpQXZoQMZuUDEGh+dRsNuvBfBbt0lkco3tRH5vP56FQKDgCZk9PDwQCAdGHNglUr+9ol7U+9d5ZgWoRG4lEhJ1TEcM7WvN/wAMhy5RUdW8zljUa1qBeZBaWKaxB9TML6wYS/JnK3/4O+vav1ovXadMLnz9KnAtAzbDgSOXm7wxpn6n8259W96msI01MTMDs7KzpeaOjozA+Pn56pPKL6kixWAwqg4PmzX11FZaXl7lP5ReVE/vUzc3NFewGol1dXeD1es/NGLSevlKpo09NJpNi/nhnZ4c2s6JPnZmZubG/v//+4OBArInQvGh3d7cA3NHRIfK0z+12/10Mo9TlcrU1VFp7o8VNEqXIR0zEb29vQ6lUgr29PZHXfjiNfH53dnbeFZGKBz5hEoSj1dNbqqpeR+oRpB8y7T9UtYwRTncVhHt7e48dJ/DVq5JYMHg8noYqSA+XRJVpRMViETBgju0jQARMr62trUq5XBYEEZYX86ZdIwbaGgL9htkM2geEPp9KpYr6IVUR7R1ZdYFSw/Bv/SoMcroQC/cg/KuYJUqPqRkgyK/0oLUL8ZwLWHjAFgNzRcljIPyUfpXQr7KsG62lvJEcMjIl/UDLacE7Nja2VNfg32jdvwkR6DWZj+gcMZLRx8Y1+WCqRevFr9D65fYvtKdoK0aBifbZqJ6N+I3gbDP4H6jK5xq8PlNj/6K810e5fR9toZV+T01N2WZI1a/LWz3pvVAjb0u/rYTqr+Go3WW5362KVCdB7WeoDoDayhfVqaOOZkZDFp/XjN8cqdz8GSpDbYdx6v+C6rcz1AGHQuUXlV39VvifKFgvXk5hqAyVobIYKkNlqCyGylAZKouh2kh/BBgAQdUh4kNzQfkAAAAASUVORK5CYII="; break;
		case CONST_CTRL_SWRightFront2:			/*Control_Front_Switch_R_2.png*/					control_image = "iVBORw0KGgoAAAANSUhEUgAAAFUAAAA9CAYAAADcUiVtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAOPSURBVHja7JtNaBNREMdnN22atCkJlSaStAehNrSgFAoe40nwVgRBehAFT3ryLuQQ8C4UPPTqIaCepELBW1K8FcQemviBkDbFBtRD06ZNmsSZ7VtM4q7pbl/Kbpw/DO/t97zfvp33didRms0msORKYagMlaEyVBZDZagMlcVQGSpDZTFUh0FdXl7+a0MikbiNxU20ObR5o4MrlQoUi0XY2dnpKyjRaBRisRj4/X6zXdbRPqCtZjKZ112hIkwC+Qwtflon8vk87O7u9gXQSCQC8XjcyiF5tMcId1VfoXb0zodYrFgBSpqenoZQKOR6oNQGaotFEasVwa4dKq68jsUSmsdyDFEUmJ2dhWAw6Fqg5Du1gdpiQ8RsSTA8efxzuZwX6zm0S2dxjM5FMbZUKkG5XHYFzEAgAOFwWIuhNoG26hvaZR0qDUqveNyWogX98b/FLKTpjg51nllI05wO9SKzkKaYDjXILORNJFRmIF8DjMBcqVQK0ul01/0WFxchmUy2v6bilKrtq8rTF5muJ3pyN9H3UGdmZqA5Odn95WdrCzY3N8HwNZUlRwz1vGLq//Bon0YUK5VTxtS2cGAUU1k96Kk8UJ2NBcdUHqjcIS2mZrPZz1hODQ8Pg8/ng4EBfiewouPjYzg8PISDgwNazGn0CoXCvaOjo7e4UcuJ0MfakZERDfDg4KBWp3UEW0+GUenxePoaVr1e15KbJCoJHnXC/f19qNVqGkiq6xlp5PNraGjogQYVN7zHIgIn2dMbqqpeQ+oT5XI52jV+qGoDezidVSM8Ojratp3Ad2Yl8cLg9XotNZBuLokaY0XVahWww7StI0AErFV7e3vNRqOhEURYPqx3DY3Y0bYR6FesbqC9Q+iraNXW57yK9oas84JCc/AnfxUD8bkQL+5F+FewSpTuUxoFQX6iG60fiPtcwIuHHRHvFKWEHeGH8KuGfjVE2yiX8lJw2BAl6TtaUe+8cJKa1mT2mwnTvL8NEehtUZ9occRIRt5cFTemU1Noz9HGxPJPtEdoX4w6JtpHo3ZK8tv+PNWmxjvqVp3bMFm/Ls6VFcsLaGsO8runU6qxlrrsj95rJnVH+i0TatDEUadLut+96qlugjrGUF0AtZcD1T9nNnZmQ5L3s+M391R+/BkqQ+2Heep5QQ06Geq4S6HyQOVUv/nfKT0QQ2WoDJWhshgqQ2WoLIbKUBkqi6E6SL8FGAD2AXJKhAOU5AAAAABJRU5ErkJggg=="; break;
		case CONST_CTRL_SWRightTop1:			/*Control_Top_Switch_R_2.png*/						control_image = "iVBORw0KGgoAAAANSUhEUgAAAFUAAAA9CAYAAADcUiVtAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2RpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDoyMzFFNTU0RDA1OUQxMUUzQTUyQkNFRUZCOTEzOTlDRiIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDoyMzFFNTU0QzA1OUQxMUUzQTUyQkNFRUZCOTEzOTlDRiIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpFQzIwNjgzMjk3MDVFMzExQjAwQjk5MjAyMEZBMDRGOSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PrhBCQIAAAfjSURBVHja7FxbbBRVGP673VK2t+2FhdorSzdtKbalkGjQ0ET0wQeU+GC4GJ5MNBoTfZDEBMMD0RfjiyHRF9+IgtEHLy8GQ6LFkJiYlNJSetnSG2DpbSmFQunN8x3mLLOzZ3YuO9vdbPdL/uzszJwz//nmP/9//v9sm3X9+nVyEF4mAeW4nEmlchxQrmlRw8QXoz+9dgL9TO7b0FO0u8XkCpNuJsNOkeCOoy0I263IXuXTT+uLBpvt9krOzTL5i8kPTH5ismJXqSwbllrA5BMmJ5hsovREL5OPmPxhp7HL4v2Y0peYnExjQoEmJheYfKcYUcJIhX+7rEzzjYJjTK4yeS4RpO5WLNRPGw9+ZeyHnSR1H5M/lam/UQFXd57Je06QeoDJRYNlzUbC10o8Mb+k+vxsR/j45PH2N5S3k1YB6fTp03Tu3Lnw96NHj9KpU6esdPEZEw/j6lMVV8aWym46zj5+tEMoXoyQVAQIXauuDouaYAs4yTj6wvTin938Afs4k8iBzS8s0u//BGno9izVVZTSq88HqDAvN+X6NMAJxpWXGc+7MX2qYqFnEm0tv10eoIGbM7SyusY/f/67LyX7NIF3GGffxiLVtx6EArem7sX8nip9msTbTD7Um/6HRZTXBCzHtaj0FdHwf6GI76nYp17MkHADUr+SWeqB9Xq1B/fVc78H4PPQi40p2afFBKFAZqnN66VBUX4uHXn52ZTv00ZdJKgltdSJnhPhLpwE1qVZmnWqQ/DJSN0QWRMW+hYX+2ZRoPWpsNLsTBbqPKkZOESqqPxje+HfDC9x4X0m32Qs1VmEY5Kro6MjQ6pDpCpchqO/ZVJXVlbozp07NDs7S790zobPH2orpdLSUtq2bRtlZ6dm7IPuExMTFAqFnNQ9avFvidTp6WkKBoP0+PHjqGsgGTI2NkaBQIC2bNmSUoRC98HBQVpaWnJad/vRf3x8nHp7e6WEqoHruA8KpgpGR0e5TjJCHdDdHqlTU1M0PGzthxwjIyPcOpIN6A5SE6h7FKleM37oxo0btgY0NDTE2yfTh0KHBOtu3aciKC0uLtpSDO3QvqKiIuqaE2VGoz7wbCN3ZUd3vSWVW1UMiImZmRnp+dzcXHrzpQAvt41MhGh6fFBKPtqbUCxqQHA3c3NzT7T2esnv9/NnWoEZ3bENE7oVjEf3KEs1/GnLr1dC0vPHXqkn/zMl/BjK5WQ30tkLXZIoEaJmC8XFR48eUWdnZ0RQmZyc5MugtrY22rx5s+m+zOheX1VGYznueHS37lP1oK2wO1Vxh/+WRWmcs+vbE6x7FKkeuz3dnp7XfHdmb+ju3bu2riVRd097ezvPGNzKgeH+/uu7S/jU02JybIBWVp/6pZmbQdpfG92+uLjYkobLy8u2rsnwWmux9EUkQHdY6xx8agEccVlZWcy7cV1GKnzf+Ys94e8ypYBkZlZ4toxUJ3VXOIQbncP09w4MDPD0LBaQD2/aZO8XQGiH9skCnp2Tk5Mw3cEdOBR+FaR61tbWeFp2756+T0GBoa6uzpZiaJfM4gqejVw+EbqDM3AHDgWpbnGwurpKPT091NraSvn5+dIOfD4fPXz4kKdvZrF9+3beTg9ObBSa6QM6LCwsWEpVjXR/8OAB5wzcuVyuSEtVB4Du7m5OnB5qamqoqanJcDrhOu7D/bFw6eool3hhpp/a2lpqbGwkt9sdt+7gCFxpgmbYUr3aCg3Yb2lp0c1c4LhLSkp4TZL74tGnAQznUZMsLy83nPIgoaPrKRH7W2ptE2q2n61bt/KgG4/uyLrAkST1DZPqycrKinoLwhXovVU8tLKykktzc/xEPHFJ9qBuK/qMRWw8usMywY12NiscesX0L8CUUHxChL+AecNfOA2ZZbW31truD23VJKJvJ1yKFuACnIAbNcAdOIzwqTB7+BCtxc7Pz6sj27oSGsvvya4lmlixQgInWgsFd+BQWGrYp8KX7Nq1i65duxZBIvxOX18ffxNq0heXlunL85ctRWYrFoosRq9ArJfhiL4EmTJXYOYX3h8feYFyc9wRhIID7VoefIAzcKf2qS51ioqLO3fujLJYVM2d2BZRG7zRlN+xY4d0hQErRfnPrCtwYpJhGQYOtISCKxWhJLh0a4spiOywSrwZtcWCVEROj8cTl++THcuA0t6ePXt4RUpdTwXZRvVUK88xAgIS9uW0hIIjSfrKlwz4hQr+jCXq74NQ7e7v749K9xoaGmgjARyACzXAgU7q+j2Tt1x6ZT80glVo3UAiVgOpCoxVO+3BiVEtwB2r7FdVVcVzWxEw8BBUezR+xDRQFRIZCI6NtoqxdNGuPDD19NJo9To0Ly8v/B3H2iWj2Zqu2ogw3cFJDHilGZUW9fX1fHBisSsjFZkFBMsNEIWMA3k2diHRLpk7qbKqEwQ+G4EQhOMlYEzaKpzw5QBiCbgwAzcZVP0RbdFZV1dX2HHL/K/V3wMkC8IA7t+P/IcWWFFUV1dHnINhqI3LqGYguHSRiao/oq6wzljFlnSDGCvGDg7MTARBqqm7xRatkR9MJ4ixWthazxakmqoeIw2D+aeSf3QSsqoUxooxKymoGYQzKlP/zgJRt7CwkEdDJ2sBqQqMEWMtKiqKyjCNYGmdIaJjulqr1koBi3tbXks+VW+KpDvsjNlFGTgJjyWfmoE5D2kp+mdgjdQMnIsXfPr/L8AABujQRBiFOK0AAAAASUVORK5CYII="; break;
		case CONST_CTRL_SWRightTop2:			/*Control_Top_Switch_R_1.png*/						control_image = "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"; break;
		case CONST_CTRL_SWStickRight:			/*Control_Top_StickSwitch_R_UD.png*/				control_image = "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"; break;
		
		//Potis
		case CONST_CTRL_PotiLeftTop:			/*Control_Top_Potentiometer_L.png*/					control_image = "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"; break;
		case CONST_CTRL_PotiLeftSide:			/*Control_Left_Potentiometer.png*/					control_image = "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"; break;
		case CONST_CTRL_PotiRightSide:			/*Control_Right_Potentiometer.png*/					control_image = "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"; break;
		case CONST_CTRL_PotiRightTop:			/*Control_Top_Potentiometer_R.png*/					control_image = "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"; break;
		case CONST_CTRL_PotiStickLeft:			/*Control_Top_StickSwitch_L_Potentiometer.png*/		control_image = "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"; break;
		case CONST_CTRL_PotiStickRight:			/*Control_Top_StickSwitch_R_Potentiometer.png*/		control_image = "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"; break;
			
		//Buttons
		case CONST_CTRL_StickLeftButton:		/*Control_Top_StickButton_L.png*/					control_image = "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";	break;
		case CONST_CTRL_StickRightButton: 		/*Control_Top_StickButton_R.png*/					control_image = "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";	break;
		//case :	/*							--> Control_Front_Switch_L_L_1.png*/				control_image = "owQ0U0QjYxQTA2OUUxMUUzQjFDMThBMThCNTkwQzFGQiIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowQ0U0QjYxOTA2OUUxMUUzQjFDMThBMThCNTkwQzFGQiIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNzVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Ph2cU/sAAAQZSURBVHja7JzfSxRRFMfP7K7rb0yTxdY2kX4aJtGPF4mVhKQfQhIGKii9LSYL0Wv4IvkPhGb7EJEJFgRRGPjYbuBbICpKEvm0sriaO6jr753OGWdt1dV1d2dzR88XjnPnzq8zn3vn3Hvn7ihIkgQsdaVjBAyVoTJUFkNlqAyVxVAZ6tGQ4HA4mALX1KMD1Y8mKebX0P0nxG+1oP7ZJZ3sSojfakH1ahSqN5mhihqFKiYzVH78GSpD1RxUQwICvjfCvuHmb4R9HiOofO5o/Oaayo8/Q43onKhRqGKyQU1kP/XGLumk9fsgGqpwuoRmDJN/Bu1lyPpntMdov8Lsu3IAfscF9TKaXkkXohUoaWMYIH2CIOhQKbQSCASOS5JkinD+oX36kYf2Psp73OwRoF9T6NdMyDb9+vp6MP1cKZjhkALyoLmVNO04SAmbzXYRF81oXQ6HY3Q3qATlNtotgoQXP40gTkaMHTpdIC0tbUlJS9nZ2YJSABse6/WQnp6+5ZjU1FQwGo1RUUlJkcsHVldXozpuZWUFlpeXQ7NMi4uLphCQsubm5mjxiMD5/X4BK8KeYbGiogJqh4bgldncMDAw4CovL3+D2f3BwjBkZmaW44X71tbWcpXSBMwDhCXfDKUpz2AwbAKiJQFTYnLG/2pVqEASrODTCAQeC0BO0xL5AP1EamFhAZxOJ3yzWKDA48lr6u6uwV1qrFarD/27h9sHDBaL5TVm5mZkZMggCR4LoL29HXp7e/fcpxaZnUJe93t6qKIda2hoeDs2NnZWwD9bRiHt71wRL/is0XrooZaUlICEtXE/msBaXOX1wp3mZigtLRW4WqqgYqyt300muNDZCWIgkMNQ1ehPBgJQNzMDTS0tVFPFHY8/a0NtbW17xtRgaBjGHkk1PvrVNhvY7XZwuVwCQ40j3vYvLcHD6Wl42toK9fX18jaCuuPx54YqMotzVyqgY2IInszOwguMo5WVlQkZph4pnb92Ezp0OriLcLcDZagxKif/BFyvqtt1O8dUlUUxlX/2kwAx1ARBFRmDahKDUN3MQjV5glAHmYVq+hGE+oFZqKZPwX7qV7QJtOJ4zkYvcN1uN0xNTcH8/LwmCGRlZYHJZILCwkL5RXycIoZfKKEvKyuTioqKKAQ0xtoboLfiIyMj4PF45CkMrYh8ncWhpiiKkJ+fT1NCsZ6K5mceYB/192aXClecuLArG6OuoaOjo7Jjmm2y0Xe6hxi/KCdmdoXh1n4qZnbhohrtZzRnHB8fB5/Pp/lgSPdA9xKliFW1wu7fMDXc1ylWq7UWNmZXaWb0ariz0WQYxdDJyclD1dKYzWY5xm6fBd7WwlO47EeYH8OO/fmTH/Ul8H+m4LE/Q2WoLIbKUBkqi6EyVIbKYqjJo78CDACwp391Vgy4ugAAAABJRU5ErkJggg==";										break;
		//case :	/*							-->	Control_Front_Switch_L_L_2.png*/				control_image = "owRDgyQTYxQTA2OUUxMUUzODhBOEY5MDIzRkRBRjAxNSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowRDgyQTYxOTA2OUUxMUUzODhBOEY5MDIzRkRBRjAxNSIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNzVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PrpvLwYAAAQcSURBVHja7JxfSFNRHMd/d9P5H6lkhGYSK9AwCXqL2FtRJIRhkIgS+CBme+k1fJF86F0LnxNmIIRiIPUQLgjpD1iaI7F6ySXOP7uoc07d7fe73js2u7Z/d7jrfl84nrO7e8/O+Zzf+Z1/m4IkScDSVyZGwFAZKkNlMVSGylBZDJWhZoeE/v5+psCWmj1Q/RgkJfgNVP+0lFsvqCsHpDNdaSm3XlC9BoXqzWSookGhipkMlbs/Q2WohoOakwaH741xr9b5jRDnM4LOeSdSbrZU7v4MNWbhRINCFTMNajrnqVcOSGdsuQ9joNLSBQwWjetnMTyNeD2M4T6GOY17g4dQ7pSgXsRgVtIVGE4qaYsGkFFBEEyoXHoRCoVOSJJkjZH/1zjLcRzDYIJ1DM8IsFyLWK7liPfMu7u7avqx0jBTEQ20gGFeSdONk4lAJSjXMVwlSPjhNgRxKqbvMJlC+fn5ASUtlZSUCEoD7JXYbIaCgoKoZ/Ly8sBisSREJTdXbh/Y3t5O6LlgMAhbW1uRl6ybm5vWCJCy1tbWKLpH4Px+v4CGYIqj7h7k9Bvz+oAv32AYUxtDGBgYuIwfPLqzs3NMaU0oKioChCVXhtJ0LScnJwyIYgJ2lEXgsQHkNMXIB+grUhsbG3LjBgIBOa1+bQr5+NBgbuK198L4+Lgbr1UXFhbKIAkeK34RbAKMFk7GN+d2u88J+CdqFdLz3BUzo0ct9qwAlgwLl8sl8HFKMvOwpT/w8fWgHKdznppV+v7pLTz4MQlfXCMwMTHx72bD/u7Piq2amhqQKithCP1o68oKdPX0QENDQ7j786h0gLq7u8HpdP73nkYc3E/jwH6rqwtWEG5bW5u2pfJAFW2N8egXzgCueb1wo6MDamtr2VL10Bm01ndWK1T39YEYCpUyVD02PkIhuLu8DK2dnWSpIg9USfpU1TVM4eqqHrt+fXs7OBwOeaBiqCn42zFcSd1ZWoKHOFA1NTXx5D8VEcDe9XXZQp/09oaBqiKfShu1pYwqfjU3N4PTZIJhhGmz2aIWW+qU6hvG5xmVPost7P7V1P0nmYVu+qyu/V8wC930UvWpr2hRQHPYVHKjzdr5+XlYXFyEdXTiRlBxcTFYcdJeUVEhb8SnKGI4QglzXV2dVFVVRS6gBZLctaKN2unpaVhYWJCPMIwiKuvq6iqIoghlZWV0RJJsVnQ+cxv96U+1+9Pcahwjh/JmwhY6MzMjF8yoorJTHZL8RTkxcygMASItEy8+w6ieRrBEcpydnQWfz2d4Z0h1oLokOtoTM4VdWJq/TrHb7Y2wd7pKJ6OXtHKjwzDyoR6P50iNNOXl5bKP3X8KvG+EJ3c5hjCHtG7gn/ykQQL/Zwr9xWt/hspQGSqLoTJUhspiqAyVobKS1V8BBgAxm7GJd6WA/AAAAABJRU5ErkJggg==";									break;
		//case :	/*							-->	Control_Front_Switch_L_R_1.png*/				control_image = "owQUEwRDgxQzA2OUUxMUUzODE3REI3QkM5MDdEM0Q5RiIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowQUEwRDgxQjA2OUUxMUUzODE3REI3QkM5MDdEM0Q5RiIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNzVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PsL2faUAAAQwSURBVHja7JxLSBtRFIbPJDG+KdoYUy2I2NdGkT5RSkqFFmmzKlJ1YemqguLOnYsWbNd2USMu3FgXLRXEYom0ICjSRaEgra9aaRdWCRGr4yPxEZ2eO05sTCdNxkwwk5wfjnNnkrk597v3nntmJpETBAFI6kpHCAgqQSWoJIJKUAkqiaAS1MQQ19nZSRRopCYOVDeaIJlbQ+2Pit9qQf0dpBzriorfakFd1CjUxViGymsUKh/LUGn6E1SCqjmohigE/MUQ75V7fsOFeQ6nct1K/KaRStOfpn9I53iNQuXr6+sVVyB370QLeer1IOWY9fs4Fio5FaMZZY6fQbP77fejNaDNyrx3+xj8jghqKZpeKuejWaSyUQbIAMdxOlQS29nb2zspCII5RP1fwvQjG+2VwjYeZATolwv9WvJ7Tb+7u+srP8WpzDrmq6+DRkdHkxwOh7WsrKzXZrN9x/AwpgQqg1KJdotBwg8vQhCnQ65yOt1eSkrKplQWMjMzOakD9j3W6yE1NfXQOcnJyWA0GhVRSUoS+wd2dnYUnbe9vQ1bW1v+h8wej8fsB1LU2toa2zxE23W73RwOBN309DRMTEzAY3xv7+rq/cD4ie1dQE6/sK5PuPsBbdDXGVxPT085fvCA1+vNknoT0tPTAWGJjWFldsxgMBwAYlsGLF7V19cHrS0t0J2dDVVpacDNzcHQ0BCwr0htbGyInbu5uSmWfV+bQj4rOGDu4rGP3PDw8BQeu5CGJzOQDF4iq6urC3ra2qDfZIKr0oxiUIOpuroampubAUc4G3yzU1NTZzn8c+gq5NnLkZAf3FJnjUugdrsdHB0d8D4nBwrDHFwMODI82B8ZGeESe1gGxNXu9naYtljAEmFoo2dUknCRhQeNjVCztATOgIUs4pQqXqd2OGpoaBCT4msYBgYwBBRLWcf/YmptbW3Ukv+4ApuVlQXlra3wBherSly8mfzjpuKRmsgLlf/oy83NBRuGg+cI+NzFG0G5yLGgmBpEFRUVcOfRE3hRVArnL988lmv/uNQJ0ym4crtG8Xn/5KmkyMTyVJr+URBBjRJUnjCoJt4HdZ5YqCanD+oYsVBNn31QXxML1dTny1Pfof1EK4ykNnazdn5+HlwuF6yvr2uCQEZGBpjNZsjPzxdvxEcoxvAtK+hLSkqEgoICFgLqjpoNeL1eGB8fB6fTKT7C0IqYr8vLy8DzPJjwOl+nO3IyxG5r3cMc9cdBSoU7w7hpkl5UPEInJydFxzS7ZKPvrA1H/EU5Y9YkMTycp+LBDtzY0L4pqXFmZgZWVlY0HwxZG1hbFIqxskns/l6myn3Dwmq1VsH+01X2ZPSSXG0ej0eMoQsLC3G10uTl5YkxNvApcMAKz8LlIMLslb32p5/8qC+O/jMFXfsTVIJKIqgElaCSCCpBJagkgho7+iPAANUWhz0INCmLAAAAAElFTkSuQmCC";			break;
		//case :	/*							-->	Control_Front_Switch_L_R_2.png*/				control_image = "owQjJGRkFENTA2OUUxMUUzOUM5MUZFRERFNUQ2MjNFNCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowQjJGRkFENDA2OUUxMUUzOUM5MUZFRERFNUQ2MjNFNCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNzVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PpNZqJoAAAQrSURBVHja7JzPTxNBFMfftqX8PoBQGmpCiJqICcTERBNieiAxIcjJcJAQjGeQv4CEC3rGCxAOXLAHjCYEUiPBg7YH0/gjQUUqBPWAYAMiNEApBbq+t2yxlIV2+yN06fsmj5nd7k5nPjM7M2+miyCKIrCSKx0jYKgMlaGyGCpDZagshspQM0PCwMAAU+CWmjlQfWiibD4NlT8l+U4W1L/HxNNdKcl3sqAuaxTqcjpD9WoUqjedofLjz1AZquagGlLQ4S9HuVZp/0aI8R4hyWmryTe3VH78GWrUzHk1CtWbblBTOU+9eUw8bfN9GgOVkqrRjArnL6L1hR2PorWhzSlcGziFfCcE9SqaXo5b0Mxy3KgAxC4Igg6VRQfBYPCcKIqmKOl/jjEfxWjDKst4MCPAfC1hvlbCPtPv7e2F4g/livkSVkEetAU5ThdOqoFKUOrRbhEk/PILCOJ81L5Dpwvm5OT45bhYWFgoyBWwn2O9HnJzcw/dk52dDUajURWVrCypfmBnZ0fVfYFAALa3t8NPmba2tkxhICWtr69TcJ/A+Xw+ARuCLoayLyKnX5jWOzx8hTYeqgzBZrPV4hfbd3d3i+TahPz8fEBYUmEoTucMBsMBIAoJ2FkWgccKkOIUIh+gn0htbm5Klev3+6V46GdTyGcNG8xtPPdWcDgcbjx3OS8vTwJJ8Fixi2ATYGzh1Pjm3G73JQH/HPJCHj1xRk2os9WaEcDiYeF0OgXeTjlpvvXnN7yfGJbC05innjm5XC745ByDB98nYebDa1X3Hnn8WQAjIyPQ3dkJQ8XF0IRjjTA/D8gppnvp8edRKUKDg4Ng6+mBNyYTXA+b+lVVVSle39zcDF1dXSe31EweqPr6+uBlfz9MlJZCZYyzoMhWzC01wgEY6u2Fb2YzmBOcg/NAJQu9QbjX3g53V1bAE+FxJez7Z8ocVEltbW3S6s0N7Abs2AVUy+4xPeLHifrUVK1SnSmwRUVFUNvdDc9KSqAevUxSrKM/Qz2h9ZWVlUEjdgePEbBSa4zWp3oZ41HV1dXBqN0OroYGaGlpidkJC02pvmJ4hTEmRTM4pbpMLXWSWSRNH0OP/1NmkTwPNzRQvUD7iVaZSGq0WLuwsABLS0uwsbGhCQIFBQVgQnfUYrFIC/EJihiOUURfU1MjVlRUUBfQGq8zQAu1U1NT4PF4pC0MrYjyurq6Cl6vF0pw+qTTxe0LkbdwB/vTHwceFR44MOiQP1TdQqenp6WMaVWUdypDnG+UE7MOmeFhNxVP9mPQSCOYmhRnZ2dhbW1N850hlYHKona0J2Yyu/+LLEpvp1it1ibY312lndFrSqnRZhj1oYuLi2dqpCkvL5f62Mhd4IgRnrrLcYT5XOkCfuUnBRL4P1MkX7z0x1AZKkNlMVSGylBZDJWhMlRWvPonwAB5m52fwA36MQAAAABJRU5ErkJggg==";				break;
		//case :	/*							-->	Control_Front_Switch_R_L_1.png*/				control_image = "owQkJERTUwOTA2OUUxMUUzOTkxNEY3QzY5QUFBNDdCMSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowQkJERTUwODA2OUUxMUUzOTkxNEY3QzY5QUFBNDdCMSIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNzVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PnCfAo8AAAQySURBVHja7JxfSFNRHMd/d875n4jGIE1EStOHRPrzEsNISFoNwrBQSAl8ECdC9hrSk28+hRY+FSXIQIhigdDTFiQIgeSfkUi+NBlOp/PP/Lvdfud2tza7c//ucnf+vnC8557dnXvO55zzO79zz50cz/NAklcqQkBQCSpBJRFUgkpQSQSVoJ4McUNDQ0SBeurJgerFwIvBq6D6p6TcckF1R4inu1JSbrmguhQK1ZXOUD0KhepJZ6g0/AkqQVUcVHUKDL4ryrVS+zdcjN/hZM47nnJTT6Xhn2nDv6OjI6kMxGcH7ghuipKgetKtp6bST9VHiKdtuY9jopLSJQwaifQLGF6GnH/AYMIwL3Ht3jGUW1JcjEO81mKxVIyPjzcZDAabXq/fFz/ShAB5LKZNchynQmWzE7/ff4bneV06jHUs1xKWayUkKcvn81WK8Tdiw0yFNJATg0OM+1jdYu6pCI1BuY3hFoOENz+PIM6FXri+vg7PfT54PTPzUKvVQlVVFWAB/bm5uTuCHVGp+KKiItZItcESZ2VBXl5e2A1zcnJAo9HEBSM7W2gf2N/fj+t7e3t7sLu7G5qk297e1iHIsOs2NjZA7BQ+r9fLYUeIahaxvovI6RfmNYGnnzGMBRqDGx4evo43thwcHJwWWxMKCgoAYQmVYXGWVl9fD3xpKYx6vdDmdkNvXx80NjZCpoqBxwYQ4uyIfIC9IrW1tSU07s7OjhAPvDalVqvXsMPcxbSvnNVqtWNaVX5+PvT394PZbI7sWSNUpgnsAfeWl+FRTw+0t7fDSRaDzQBjD2edb95ut1dw+Ce4Cqmurg6Ci6YFzKzB5QJDZyeYTKaMBNb3zhb1mmetdWHnNpuNS9ilKler4YtOB28HBwM2iZSsn+ry+6F5ZQXauroAJygiGclPbWlpAW5kJKpNnUJDbcShb8TVWKYOfamhHbPrFmpTj1LA3o6hUX6Ak9TT3l6hEUjwj01Vx2qcKy/fgIGF7/BkdRVeoB1lLlamK5GJKq5l6sWrN2FApYI7CPckAP0va/9T2rNwraGZiMlpU0mx21R67Sed/FTS0VA9hEE2eQJQHcRCNjkDUCeJhWz6FoBqJhay6X3AT/2EYQFDeTK5sYe1DocDlpaWYHNzUxEECgsLQafTQUlJifAgPkkxhh9ZJKumpoYvKytjJqA1UW+APaidnp4Gp9MpbGEoRaysq7js9ng8wLaIVKqEnSG2P3MffdSfQZcKT6x46BY/jLuHzs7OCgVT7JSNZWd1SPAX5YxZt8gw3E/FxFd4MGL4EU+Oc3NzsLa2pnhjyOrA6hKnGCujyO7vMlXq1yl1dXVN8Gd3le2MXpHKjW2GMRu6uLiYUTNNcXGxYGMP7wIfmuGZuRxDmKOSa3/6yY/84ug/U9Dan6ASVBJBJagElURQCSpBJRHU9NFvAQYAyJuooRhq0a8AAAAASUVORK5CYII=";		break;
		//case :	/*							-->	Control_Front_Switch_R_L_2.png*/				control_image = "owQzUxMjY4MTA2OUUxMUUzQkRGRDgzQjYxMERGNjk1RCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowQzUxMjY4MDA2OUUxMUUzQkRGRDgzQjYxMERGNjk1RCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNzVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PkxyMmgAAAQlSURBVHja7JxfSFNRHMd/d5vzP1HJCM0kVqBBEgQ9ROytCBLCMEhECXwQVr70Gr5IPvTmgxa+ljADIRQDqYdwgUh/wNIcitVLW+J0bqhzTt3t97ve2Wb7d7c73NXfF36ec+/uPTvnc/78zrlnV0EURWCpKx0jYKgMlaGyGCpDZagshspQj4aEvr4+psAt9ehA9aOJsvk1VP6s5FstqJ448VxXVvKtFlS3RqG6cxmqT6NQfbkMlbs/Q2WomoNqyMKA705ybaz9GyHFewSV01aSb26p3P0ZatLM+TQK1ZdrULM5T70WJ56z+T4IRxVLF9GMMc6fQ3sWcTyEZkWbj3Ft8ADynRHUS2h6OV6BdkqOG2MAGREEQYfKo4NQKHRSFEVTkvS/pZiPE2gDCsu4NyPAfC1ivpYjPtPv7OyE40/kipmKqKAFNKccpwsnlUAlKDfRrhMk/HIzgjiddOzQ6UIFBQUBOS6WlpYKcgXs5livh8LCwqh78vPzwWg0KqKSlyfVD2xtbSm6LxgMwubmZuQp08bGhikCpKTV1VUK7hM4v98vYEPQpVB2F3L6jWl9xMN3aKPhyhD6+/uv4hePbG9vH5drE4qLiwFhSYWhOJ0zGAx7gCgkYIdZBB4rQIpTiHyAfiK1vr4uVW4gEJDi4Z9NIR8vNphbeG5cGBsbc+C56qKiIgkkwWOlLoJNgLGFU+Obdzgc5wX8E7UK6XppT5rQ42bLkQCWDgu73S6kPKXyLf2BT28HpJCl0jx19vN7ePhjEr7ah2FiYoLJJdB/3T+eampqQKyshEEcO1o8Hujo6oL6+nomuE/U/aO8UmdnJ9hstoQ3NaBDO4PO7HZHB3gQbmtrK5NMNPknoNQak+kKzjPHTSa40d0tzQOtVis7KjXW/mextX5AsC96e8OTZ1amUN2hENxbXoaWBw8AV1JMMl73b2xsBCHBmBoeGqZwRVHndkNdW9uh7fqZzMcVe/9RXD3cXVqCR+ioqBJYkP7knwD2rK1JLfRpTw8DTdL96UHtsWQXNjU1gU2ngyGEaTabmVychWe4+3/H8ALzUEWz2P2rqftPMgvV9CU8pXrFLFTT6/CY+gbtF83nM0mNHtY6nU5YXFyENXRoWlBJSQmYcAFTUVEhPYjPUMRwmCL62tpasaqqioaA5nQXA/Sgdnp6GhYWFqQtDK2I8rqysgI+nw/KyspoiyTdpGh/5g6Opz/3VlR4MIZBu/yh4hY6MzMjZUyzLhvzTmVI841yYtYuM4xepuLJ5xjUkQdTkuLc3Bx4vV7ND4ZUBiqLUm9PzGR2/1ZUsd5OsVgsDbC7u0o7o5djpUabYTSGulyuQ+VpysvLpTF2/y7wPg9Pw+UowhyMuUzlV37Ul8D/mUJ98XtUDJWhMlQWQ2WoDJXFUBkqQ2Wlq78CDAD5yKjbr8mr+wAAAABJRU5ErkJggg==";						break;
		//case :	/*							-->	Control_Front_Switch_R_R_1.png*/				control_image = "owOTg0MTk1MTA2OUUxMUUzQTREQTg5Q0I4ODREQzEwNSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowOTg0MTk1MDA2OUUxMUUzQTREQTg5Q0I4ODREQzEwNSIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNzVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Ph2V7lQAAAQSSURBVHja7JzPSxtBFMffJjHGXxRt/FFzEGlrS8Eg/Qm2WOqhSOupeFDB0l4qjeQvKEhBeu+hKuKlWEHaCq1iqbQnc/AgFISKtiLtwUaC4o+gxhhNtu8tG5ukm2qSTc0m7wuPnZ3sjjOfmXkzs7OrIIoisNSVjhEwVIbKUFkMlaEyVBZDZaiZIaGvr48pcEvNHKgeNFE2j4bKn5R8qwV1LUo41ZWUfKsFdUWjUFdSGapbo1DdqQyVuz9DZaiag2pIgsNfOeRapf0b4Yj3CCqnHUu+uaVy90+37t/e3p5QAvKzg7Uo0xQtQXWnWktN5jz1RpRwyub7OAYqJVWjGRXiz6D1hJyPoNnQFhSu9R1DvhWlNDJeQHuM1os2K3fxGjzo5d8taGVy2BgC5IEcNy0Igg6VRSeBQOCkKIolqdDXMV/LmK/VkCi93++vksMv5Yr5GlJBLjSnHPZT2Y4MFaERlIbJycmHU1NT120uV/Gw1Qqtra3/9h06XcBkMnnlcE5BQUFYJen1esjJyQm7Jzs7G4xGY0wwsrKk+oG9vb2Y7vP5fLC7uxsWt7OzAwgyLG5zczMY9Hs8HgEbwqFuEcu7hJX0C9OawtPPaOPByhAGBwdr8Q+PORyOwjcDAzBQVARNubkgLC7C6Ogo5OXlUQ2DwWA4AERHApbOIvBUAcGK2N/fB3pFant7W6pcr9crhYOvTSGfDWwwdzFuUpiYmJgbGho6/76/H0bMZrgqtyKCGk0tLS3Q2dkJLJBgE2Bs4dT4Fubm5s4Kdrtd/NjbC5+Ki6HScLRxi4DjzWkP7Nkrx6HXPGmrCzvHHi8YBrq74VtZGZSleXf+n9Ld7+iA5tVVcEU4b1YC81SbzSZNBK/19MAYuoBqeaQ9zKdmgiK7dkyTfwJbWFgItV1d8BYHqwaTSfoxE/xmUlpqaOsrLS2FRnQHzxFw1cWbUR11vDWYCQPVX2v/+vp6uPPoKbw4XQPnLt/iJqfW2v+E+RRcud3MZBJZDqPf5C8pVBTNU/m1n2TMUxlBcqC6GYNqcgehOpmFanIFoU4zC9X0JQj1NbNQTe+C89QPaD/RKhNJjR7WOp1OWF5ehq2tLU0QyM/Ph5KSErBYLNKD+ARFDEcpoLdarWJFRQW5gLZ4ZwP0oHZmZgZcLpe0haEVUV7X19fB7XaD2WymLZJ4k6JHfPdwjvrjYEqFJxN4sMs/xtxCZ2dnpYxpdsjGvFMZ4vyinJjZZYbh81SMpN3TRrTvsaQ4Pz8PGxsbmneGVAYqS4wiVo0yuz/LVKWvU+rq6prw0IBGW9OXlFKjzTDyoUtLS2k10pSXl0s+NnIXOGKEJ3c5jjCHFdf+/MmP+hL4P1Pw2p+hMlQWQ2WoDJXFUBkqQ2Ux1NTRbwEGABwNhB3/QvmBAAAAAElFTkSuQmCC";													break;
		//case :	/*							-->	Control_Front_Switch_R_R_2.png*/				control_image = "owQTEyNzhCNzA2OUUxMUUzOERBQjlDRENFQjZGQTBEMCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowQTEyNzhCNjA2OUUxMUUzOERBQjlDRENFQjZGQTBEMCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNzVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Phwz8QAAAAQhSURBVHja7JzPSxtBFMffJjH+Pmg1ihZE2oIWlEKhBSkehIJYT8VDRSw9a/MXCF5sz/ai4sGLzcHSgigpFXtozaFIf4BtrVax7cFqg9bqosb4c/veuhuiXUl2s6lZ877wnNlfk5nPzLyZ2UkUJEkClrmyMQKGylAZKouhMlSGymKoDDU5JPT29jIFbqnJAzWAJikWsFD545Jvs6D+OSGe6IpLvs2CumxRqMuJDFW0KFQxkaFy92eoDNVyUB1xcPjLEe7V2r8RonxGMDltPfnmlsrdn6FGzJxoUahiokGN5zz1xgnxhM33aQxUWqpAc2qcv4jWHXY8hNaCNqdx784p5DsmqFfQ7Eq8GK1QiTs1gHgFQbChUujg4ODgnCRJrgjpf4oyH7loAzrLGJoRYL6WMF8rYdfs+/v7avyBUjGfwyrIj7agxOnGCT1QCUot2k2ChB9+AUGcj+g7bLaDtLS0oBKXsrOzBaUCDnNst0N6evqRZ1JTU8HpdOqikpIi1w/s7u7qem5nZwe2t7fDT7m2trZcYSBlra+vU3CPwAUCAQEbgi2Ksi8ip5+Y1ls8fIk2olaG4PF4qvCDvXt7ezlKbUJmZiYgLLkwFKdzDocjBIhCAnaWReCxAuQ4hcgH6CtSm5ubcuUGg0E5rn5tCvmsYYO5hefeCGNjY9N4riwjI0MGSfBY0YtgE2Bs4dT45qanpy8J+OfIKuThY1/EhNqaq5MCmBEWPp9P+Md3iL9/wbvRATlkmTBPHR8fh4++Ybj/bQJm3r9iOgYV6v6Dg4PQ0dYG/bm50ID+VZifB7zGhHSKur88KvX19YGnsxNeu1xwLWy6U15ervlgY2MjtLe3M8GTWqrb7ZZe9PTAaH4+lEY58idLKzY6UDn6u7rga2EhFJ7xeed/HajutrbCnZUV8B9bZbBiWPu3tLTIbyyud3eDF11AhbIkpC5+ksinJoOMzsdlJ0pgc3JyoKqjA57m5UEtrqxIPPqDcahq6ysoKIB6dAePEHCytMZ4Tf5DL2prampgyOuF8bo6aGpqYjr6JaqT/y8YXmYepmgGp1Rl1FInmIVp+qB2/yfMwjQNqgPVc7QfaKWxpEYvaxcWFmBpaQk2NjYsQSArKwtcuDQvLi6WX8THKGI4TBF7ZWWlVFJSQi6gGQzurtKL2snJSfD7/fIWhlVEeV1dXQVRFCEPp5I2m+HNZVo53UZ/+l3t/rReHcPArVzU3UKnpqbkjFl2yMa8UxkM/qKcmLkVhqEplfoioAeDehrB9KQ4OzsLa2trlneGVAYqi97Rnpgp7ELS/HVKdXV1AxzurtLO6FWt1GgzjHzo4uLimRppioqKZB97fBf42AhP7nIEYT7TuoF/8hMHCfyfKeKzTGUxVIbKUFkMlaEyVBZDZagMlWVEfwUYAAMkl58vYs53AAAAAElFTkSuQmCC";								break;

		//case :	/*							-->	Control_Top_Switch_L_D_1.png*/					control_image = "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";							break;
		//case :	/*							-->	Control_Top_Switch_L_D_2.png*/					control_image = "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";					break;
		//case :	/*							-->	Control_Top_Switch_L_U_1.png*/					control_image = "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";																								break;
		//case :	/*							-->	Control_Top_Switch_L_U_2.png*/					control_image = "owOUFGRjgxNzA2OUIxMUUzODc4NUM1NDQxRkQwOTExNCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowOUFGRjgxNjA2OUIxMUUzODc4NUM1NDQxRkQwOTExNCIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyNTVENDk2NTlBMDZFMzExODVCNEQ0OUFEM0IzMTY5NSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpCQkE1RUY5MjkwMDVFMzExQjAwQjk5MjAyMEZBMDRGOSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PswbhjoAAAiOSURBVHja7FxrTBRXFD4sy+LyWlhcpYAisgHEAqKJ1TaS9GHSpK2mPxpF468mVvtI/7T9Q+Of2l/2Rw2xatK0JsZKkyb2YdPGxKRAY9OkCSKgPJa3WuS1Iooir95vmFlmZ2d2HjvLLnS/5GRn9869c+63555zz5nZjbt16xaZCAcTN3+cxSSHP3bzbVKsZ+IKMp5SPwHtTB4a0FPod4fJdSbNTHrMIsEaQl8QtoWXbfxrPhomJiYoNTWVlgBFBvttk/lsjEkdk++Z/MBk1qhSFgN9UpgcZ9LN5DJ//KZA6JkzZ2j3jh3c6zKDk59HLZMbTHYvFalY0g1MqpnYpI01NTX01+nT1JqVRb+eOkXnzp2jZYoSJleYXOCNKGykwr9d45d5AC5evEiXz56lyy4X5cTH02/s9ZsTJ+jSpUu0jHGAt9rt4SB1C2+h+XKNdXV1dPL4cY5Ql2VhSLfVyr3/rLqaGhoaljOx+fzc95lJ6k4mf/BLPwBdXV303pEjdMHppNKEBL+27TYb1WZm0tHDh7nzljFsvK89agapLzG5Gmxbg2X/ZUYGvWa3y7bvYZ+jHeetAHzFxxPtW6rPz9f7jqsPVQqR0BZsgKqqKrowN0cf8KTNr1vna4sbGPCdc5DJCgF2O3bG1acirvxOiBNv/gVS2UmH2Mu3TOL1XG3Tpk0BpJqcXJgCifEYHeYEG+cTuTECNv/shPexOwrnpCYmp+j3vz3UdXeMCrKd9OpzbkpNSoy6MVXwMePKwYh9J6hP5S20JtyW8su1Duq4PUqzc/Pc649/tkXlmBpwmHH2dTBSXUtBKHBn+EHQ99Eypka8zeRDpeW/T4jyJvkc5aKBK416/vX6vY/GMXX4Y5B6Us5SX1qqr/b1nYWc3wPwuveF4qgcU2eCkCJnqaWhjoytU5xoP1qlsI1KS06k/S8/a+qswjGmgbqIR0qqM9RRjx07xkm0IxwujY9JHunyd1AMoSBF6lOdejf6MWgjNQaTSBXSVNxe+CfGS0h4l8npmKWaC19MstTX18dINYlUnkvflko3qbOzs3Tv3j0aGxujnxrHfJ/vrXCS0+mktWvXUnx8dMY+6D44OEher9dM3QM2/7pIHRkZIY/HQ0+fPg1oA8mQ/v5+crvdtHr16qgiFLp3dnbS9PS02bobj/4DAwN08+ZNWULFQDvOg4LRgr6+Pk4nOUJN0N0YqcPDw9TTo+9Bjt7eXs46Ig3oDlLDqHsAqQ4tfqi7u9vQhHDTD/0j6UON3njUobt+n4qgNDU1ZUgx9EP/7OzsgDYzyoxqY+Daau7KiO5KWyqrqBgQFKOjo7KfJyYm0lsvurlyW++gl0YGOmXJR38NigVMCO5mfHx8QWuHg/Lz87lr6oEW3XEbxnvHE4ruAZaq+mjLz9e9sp8feKWQ8p/J4I6hXEJ8MZ2/0iQTJbxUqqO4+OTJE2psbPQLKkNDQ9w2qKKiglatWqV5LC26F+ZmUn+CNRTd9ftUJUgr7GZV3OG/5aI0PjPq28OsewCpdqMj3R2ZkLw3597Q/fv3DbVFUHd7ZWUllzFY+QObWo89WzK4pSfFUH8Hzc4t+qXR2x7alRfYPz09XZeGMzMzhtrk8EZ5uuwXEQbdYa3j8KkpcMSZmZlBz0a7HKnwfbVXW3zv5ZQCIplZ4dpypJqpO88h3Og4lr+jo6ODS8+CAfmwzWYzNCn0Q/9IAddOkDw8Z6bu4A4cCn4VpNrn5+e5tOzBA2WfggJDQUGBIcXQL5LFFVwbuXw4dAdn4A4cCqRahYO5uTlqaWmh8vJySk5Olh3A5XLR48ePufRNKzZs2MD1U4IZN+G0jAEdJicndaWqaro/evSI4wzcWRaey120VHEAaG5u5ohTwvr166mkpER1OaEd5+H8YGi40cdJqNAyTl5eHhUXF5PVag1Zd3AEriRB02epDmmFBuyXlZUpZi5w3BkZGVxNkvPFfYsBDJ+jJpmVlaW65EFCfdMiEbvK8gwTqnWcNWvWcEE3FN2RdYEjmdTXR6o9Li4u4FsQXIHSt4qL5uTkcFJaGjoRCy7JGMR9hTGDERuK7rBMcCNdzTyHDmH5p2BJ8D7Bz1/AvOEvzIacZVWW5xkeD33FJGJsM1yKFOACnIAbMcAdOPTzqTB7+BCpxeJHZqLItqSEBvN7cm3hJlbYIYETqYWCO3AoWKrPp8KXbN68mVpbW/1IhN9pa2vjvgkx6VPTM/RF7TVdkVmPhSKLUSoQK2U4wlgCmXKuQFwmVMJH+5+nxASrH6HgQLqXBx/gDNyJfapFnKKiEY+YSy0WVXMzbouIDV5tyW/cuFF2hwErRflPqyswY5FhGwYOpISCKxGhJHBplRZTENlhlfhmxBYLUhE57XZ7SL5P7lgOKO1t3bqVq0iJ66kgW62equc6akBAGuB/ECImFBzJpK/clgFPqOBnLAG/D0K1u729PSDdKyoqov8TwAG4EAMcKKSu3zE5aFEq+6ETrELqBsKxG4hWYK7SZQ9O1GoB1mBlv9zcXC63FQIGLoJqj8SPaAaqQkIGgmO1W8XYukh3Hlh6Smm0eB+alJTke49j6ZZRa01XbERY7uAkCByyGZUUhYWF3OSEza4cqcgsINhugChkHMizcRcS/SJ5J1Wu6gSBz0YgBOH4EjAnaRVO8OUAYgm40AIrqVT9EW0xWFNTk89xy/lfvc8DRAqCATx86P+HFthRrBP9sA6AYYiNS61mIHBpIQ1Vf0RdwTqDFVtWGoS5Yu7gQMtCEEjVdLZwi1bND64kCHPVcWs9XiBVU/UYaRjMP5r8o5mQq0phrpgzn4JqgS+j0vR3Foi6+LMZREMzawHRCswRc01LSwvIMNWga58hRMeVaq1SKwV03tty6PKpSktkpcPInC0Ug5mw6/KpMWjzkLqifwz6SI3BvHjBLf//BBgAzfYJA07WWuMAAAAASUVORK5CYII=";					break;
		//case :	/*							-->	Control_Top_Switch_R_D_1.png*/					control_image = "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";													break;
		//case :	/*							-->	Control_Top_Switch_R_D_2.png*/					control_image = "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";						break;
		//case :	/*							-->	Control_Top_Switch_R_U_1.png*/					control_image = "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";																						break;
		//case :	/*							-->	Control_Top_Switch_R_U_2.png*/					control_image = "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";			break;

		case CONST_CTRL_Null:
		default:	/*NO-CTRL					-->	Control_Empty.png*/								control_image = "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";
	}
	
	if((CONST_CTRL_ValueFixedBegin <= control_id) && (control_id <= CONST_CTRL_ValueFixedEnd)){ //Fixed Value
		setHTML_Attribute(id, "src", "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFUAAAA9CAYAAADcUiVtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAOPSURBVHja7JtRiqNAEEB1DxDICQI5wYAnGDAXWMheYMDF/c6gZL8dlM33BAN7gQRygQhzAQO5QDxCAnMBtyrdWV2xW02bcZOpgpqGdHeiz+qqrmpHT9NUI2lXvhACgkpQCSoJQSWoBJWEoBJUgkpCUAkqQSUhqAT1LgXrqSpaEAvUAz3gV0s0BnX4+Lz0QF8Fc/DzAR/3CLqUfP9rxW0/8Wsom4vf+6jEpCWoE9C9ZVmp4zjp4XBIZRLH8Wkcjudzz+Lg52Xi+z6O9fm45RIvXaAWg+NJoMaxYO6Sg+0aqmcYRrrf79OmgnPwYdSBGoYhjg3PljqUQIVlkvYZnIcSoJ4lmWuyeaYKEyWfquv61+FwON1sNhq0H+m13hJNm7uCzn5m0naxC/qmvmDeCjSCBsBEXQYqGywIrrTfRTj4uYA/iaATnbXJmrx7mVgcepnwhzTvLPqDlcKqN0yQi388SU5IkgunH4+a9uxKBoSZtWIAfIC1NHUkQNH6wUrfutxSCYEe4XZHoxGClyqMiRQtYwZLdrUSdA7ZFoM3mu0IrBSf6oJbf9f71L5o2a/gNqMowuvUK3QEula8h5NvPQo6HQZ3CmpZgjEBm/8MVnr8b6EqLutLgtZLUBG0QkF/xKw0AqAzyqgKxhbgsxR0jlnQElppG8HpHqG+I5jvDSctmKUuwErXtwLVr0hVz+lkr6XfmyGgRd2tw5Ws9GpQIaWslXlA9mSXbNCVglYgCVrFZY++GK5jd1dVKp6FtZmK7WRBK7+FCv42VPqrlVNsa/hS3rwT1Jqps18xwMqa3t1BvcJ+FnN7w6hyO1mm5d8MVNd1K1NU1CAI5i1GX0xFfjkNtiZA1cZK2y1ZqlsjTf3Rol/DOmmjqJcruJBPLREsWttN17LJsi0TrHVCUBsEJ3TY3yrcALoNADsgqJk8gcWNx5JN/kqSaZ3rgllDUKVWumWbUWzqlAdbC1q3DtWTbaFyxyM7APpS85TgU0Md1DnEg+Y3/wjPtKJIErQsFrS8zwzVER2PFKz0n4KLWx20pqpB61ahYinGdiTBKWFAi4d46y2vZJVmDy0FLRWoSZIkH0YRDxNzsUZ43pQrPYnYBYEkN+bWj0Hr8nN3hTdTqt57uqRYUfddqoFkHL7xUrWZn/BxwuK5yhsqOv3D751VqQgqCUElqASVhKASVIJKQlAJKkElIagElaCSENRryR8BBgC8pG65iATSpAAAAABJRU5ErkJggg==");
	}
	else if((CONST_CTRL_FunctionoutputBegin <= control_id) && (control_id <= CONST_CTRL_FunctionoutputEnd)){ //Function Ouput
		setHTML_Attribute(id, "src", "data:image/png;base64,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");
	}
	else if((CONST_CTRL_VirtualSwitchBegin <= control_id) && (control_id <= CONST_CTRL_VirtualSwitchEnd)){	//Virtual Switch
		setHTML_Attribute(id, "src", "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAFUAAAA9CAYAAADcUiVtAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAP5SURBVHja7JtvatswGMbt0c8Fn2DgEwx8gg73AgWfYJCQ7x3uBTIc2OcM+wgeO4EDu4ADu0B6BAd6AU9PJCeOI8mKFzdV9z4gRPErJ/5Vfv+pdeu6dkiX1QdCQFAJKkElEVSCSlBJBJWgElQSQSWoBJVEUAkqQTWQ67pzNio2aslYSuy74yPsFOtzNu4kawI2YjYKxbr95wu7WKwZhyqa1JccTFWF20pGyAa7Hnbsu0oSxfqcr89btnf4OQiCOo7juiiKWqckSXZ2GFjD1j5e+vlr/m0vDrUsFVASDiXpgapcH/P1sbB79H2/zvO8HqLNZoN7bWyBqtxpBYdSaKB6nmItRsDXs8l5AFCAGaoxoY4RqNZrxYXgaJKbqC5uceP95MzSNHUY2P8m+q9WigseJ+ohSJwLdX2YmDsMQqY3G/1vRgh8WwYNu1UKKORkwgOnQVCVn//09OQsFgvldRak+M7fYtM7P6yA2tqt0kf3jqZT5mE/VN/zPIXfWQMobD6z8SIxuWXXZy2PktkEVelXw6PpSPCQnor26jBNVB8qYAsv4/yWmAD0wtaKSulXA/7USLy9c1797X7Cm7uV2iFwsRQL0esXG3PszKs41TFSinOKAJOkv8lvD+x8bbpUVdUuwUfKhHz2tZ9/TKh53pPEd6Aqk/6I20ct26Kvempy0clkgrXs1s6X9wAVcVZbbnagKne2x+3b7mKX/GNHmqgsyzqKol3hgbU2Q4WPlEKqOKSqBVVpW3LbUrLJ5qjfz6mqsLvxyxD+1j6ofX7V57D8ffpo5k+7emQR/6z6H7ubFQ6459JWqEq/2vGTpnYy7TpVAIXX3FRWdalM/WpnByqDlMSfqoRAVCLqv7sulalfbflKZWdK409VQl66hEtI07QXrHADoVVQdX61CVZ4taNh/lSnT2ykgKYLZGhad/u7b7X1Z1RdNR0rUZ721fvn6g8b09Vq9fX+/t4xKGutO/jr6wMoy9Pno2mQvj9zvSrUm2vt1Fa3WtqZ6jSlZYpaKVkmlpxkBgycr2pmC9jP1kFlPmbtui5aICcdqEC4AE/flZICZcobWFmWJbImC3YiTgjUr9B6qHu5TkOlE6yKQnP2ZHDI15VR7d9XBCBLAHsbA5XWBTj9/dNRNJ1O0UP8hpMKW3cqXtS6Mtylzamr5mv/004VbUE7y9QO2PnEAOjm0Bd40EDNh5z3I2dt1f231kMVYJeBSOplMIUf7W0sN/V+89cmOsAACRvR+ju59xjP6b72/6aK42nU6TNJWpqJE84Xw5J01kokIk26m4n5p8z9XfwZ6R9+7Tn4I6gkgkpQCSqJoBJUgkoiqASVoJIIKkElqCSCelX9FWAAG5zHhDwzjGIAAAAASUVORK5CYII=");
	}
	else{
		setHTML_Attribute(id, "src", "data:image/png;base64," + control_image);
	}
}
/*BAT 60 specific end*/

function setControlAssignments(tagID, val, state){
	// wenn Controlwert kleiner 94 dann Lo-Image und -XML-Wert anzeigen
	if(val < CONST_LoThreshold){
		if(state != "Low"){
			hideHTML(tagID + 'Empty_Value');
			hideHTML(tagID + 'High_Value');
			hideHTML(tagID + 'Center_Value');
			showHTML(tagID + 'Low_Value');
			
			hideHTML(tagID + 'Empty_IMG');
			hideHTML(tagID + 'High_IMG');
			hideHTML(tagID + 'Center_IMG');
			showHTML(tagID + 'Low_IMG');
			
			if(numpadOpen){
				handleNoneClosedNumpad();
			}
		}
		
		return "Low";
	}
	// wenn Controlwert zwischen -5 und +5 dann Center-Image und -XML-Wert anzeigen
	else if((val > CONST_CenterLowerThreshold) && (val < CONST_CenterUpperThreshold)){
		if(state != "Center"){
			hideHTML(tagID + 'Empty_Value');
			hideHTML(tagID + 'High_Value');
			showHTML(tagID + 'Center_Value');
			hideHTML(tagID + 'Low_Value');
			
			hideHTML(tagID + 'Empty_IMG');
			hideHTML(tagID + 'High_IMG');
			showHTML(tagID + 'Center_IMG');
			hideHTML(tagID + 'Low_IMG');
			
			if(numpadOpen){
				handleNoneClosedNumpad();
			}
		}
		
		return "Center";
	}
	// wenn Controlwert groesser 94 dann Image Hi-Image und -XML-Wert anzeigen
	else if(val > CONST_HiThreshold){
		if(state != "High"){
			hideHTML(tagID + 'Empty_Value');
			showHTML(tagID + 'High_Value');
			hideHTML(tagID + 'Center_Value');
			hideHTML(tagID + 'Low_Value');
			
			hideHTML(tagID + 'Empty_IMG');
			showHTML(tagID + 'High_IMG');
			hideHTML(tagID + 'Center_IMG');
			hideHTML(tagID + 'Low_IMG');
			
			if(numpadOpen){
				handleNoneClosedNumpad();
			}
		}
		
		return "High";
	}
	// sonst berechne den Wert selbst und zeige noEdit Image
	else{
		if((state == "Center") || (state == "High") || (state == "Low")){
			showHTML(tagID + 'Empty_Value');
			hideHTML(tagID + 'High_Value');
			hideHTML(tagID + 'Center_Value');
			hideHTML(tagID + 'Low_Value');
			
			showHTML(tagID + 'Empty_IMG');
			hideHTML(tagID + 'High_IMG');
			hideHTML(tagID + 'Center_IMG');
			hideHTML(tagID + 'Low_IMG');
			
			if(numpadOpen){
				handleNoneClosedNumpad();
			}
		}
		
		return "Empty";
	}	
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~JS FUNCTIONS MIN.~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
function setHTML(tagId, value){
	try{
		document.getElementById(tagId).innerHTML = value;
	}catch(err){
		onError(err, "Error setHTML: ", false);
	}	
}


function getHTML(tagId){
	try{
		return document.getElementById(tagId).innerHTML;
	}catch(err){
		onError(err, "Error getHTML: ", false);
	}	
}


function hideHTML(tagId){
	try{
		document.getElementById(tagId).style.display = "none";
	}catch(err){
		onError(err, "Error hideHTML: ", false);
	}	
}


function showHTML(tagId){
	try{
		document.getElementById(tagId).style.display = "inline";
	}catch(err){
		onError(err, "Error showHTML: ", false);
	}	
}


function setHTML_Attribute(tagId, attr, value){
	try{
		document.getElementById(tagId).setAttribute(attr, value);
	}catch(err){
		onError(err, "Error setHTML_Attribute: ", false);
	}	
}


function setCSS(tagId, property, value){
	try{
		document.getElementById(tagId).style[property] = value;
	}catch(err){
		onError(err, "Error setCSS: ", false);
	}	
}

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~POPUPS~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~PopupList~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Popup-List functions

var inputStringArray = [];
var g_popupList_Indices = [];

function showPopupList(tagObj, inputValue, isMultiple, isIndexUsed, Indices){ 
	if(numpadOpen && !($('#meindiv').is(':empty'))){
		handleNoneClosedNumpad();
	}

	g_isPopUp = true;

	showHTML('Pop_Up_Blocker');

	initScrollValues();

	tagId = $(tagObj).attr('id');
	$('#Pop_Up').css({'padding-left': '500px', 'top': '53px'});
	inputStringArray = inputValue;
	Indices = Indices[tagId];
	var htmlValue = $(tagObj).html();
	var htmlPopupListRow = '';	
	var scrollToIndex = -1;

	for(i in inputStringArray){
		clickedClass = '';
		
		if(isIndexUsed){
			if(isMultiple){
				for(var j = 0; j < Indices.length; j++){
//					temp1 = inputStringArray[i].Index;
//					temp2 = parseInt(Indices[j].Index);
					if(inputStringArray[i].Index == parseInt(Indices[j].Index)){
						if(typeof isFirstIndex == "undefined"){
							isFirstIndex = false;
						}

						if(!isFirstIndex){
							scrollToIndex = parseInt(Indices[j].Index);
							isFirstIndex = true;
						}

						clickedClass = 'popup-list-clicked';
					}	
				}
			}
			else{
				if(inputStringArray[i].Index == Indices){
					scrollToIndex = Indices;
					clickedClass = 'popup-list-clicked';
				}	
			}

			htmlPopupListRow += '<li id="Index_' + inputStringArray[i].Index + '" class="function-list-name ' + clickedClass + '" style="width: auto; min-width: 180px; max-width: 300px; white-space: nowrap;">' + inputStringArray[i].Name + '</li>';
		}
		else{
			if(inputStringArray[i] == htmlValue){
				clickedClass = 'popup-list-clicked';
			}	
			else{
				clickedClass = '';
			}	

			htmlPopupListRow += '<li id="' + tagId + '_' + i + '" class="function-list-name ' + clickedClass + '" style="width: auto; min-width: 180px; max-width: 300px; white-space: nowrap;">' + inputStringArray[i] + '</li>';
		}	
	}

	var Footer = 0;

	if((inputValue.length == 0) || (tagId == "Option_Button")){
		Footer = 1;
	}

	var htmlPopupListFooter = '';

	if(Footer == 0){
		htmlPopupListFooter += '<div id="poplist-footer-save" style="clear: both;" onclick="closePopupList(\'' + tagId + '\',' + isIndexUsed + ',' + isMultiple + ',true);">' +
								   '<div id="popuplist-close-save"></div>' +
							   '</div>' +
							   '<div id="poplist-footer-cancel" onclick="closePopupList(\'' + tagId + '\',' + isIndexUsed + ',' + isMultiple + ',false);">' +
								   '<div id="popuplist-close-cancel"></div>' +
							   '</div>';
	}
	else if(Footer == 1){
		htmlPopupListFooter += '<div id="poplist-footer" style="clear: both; width: 100%;" onclick="closePopupList(\'' + tagId + '\',' + isIndexUsed + ',' + isMultiple + ',false);">' +
							       '<div id="popuplist-close-cancel"></div>' +
							   '</div>';
	} 

	var htmlPopupList = '' +
		'<div id="popup-wrapper">' +
			'<div id="popup-outer">' +
				'<div id="PopUp_List_Container" class="popup-list-outer scrollContainerPopUpOuterVertical" style="height: auto; width: auto; max-height: 320px; overflow: hidden;">' +
					'<div id="scrollContainerPopUpInnerVertical" style="position: relative; top: 0px;">' +
						'<div class="popup-list-inner">' +
							'<ul id="PopupList" onClick="listElementClicked(event, ' + isMultiple + ');">' +
								htmlPopupListRow + 
							'</ul>' +
						'</div>' +
					'</div>' +
				'</div>' +
				htmlPopupListFooter + 
			'</div>' +
			'<div id="PopupArrowLeft"  style="margin-top: 0px; margin-left: 0px; display: none;"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAZCAYAAAA4/K6pAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAAZdEVYdFNvZnR3YXJlAEFkb2JlIEltYWdlUmVhZHlxyWU8AAADImlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPD94cGFja2V0IGJlZ2luPSLvu78iIGlkPSJXNU0wTXBDZWhpSHpyZVN6TlRjemtjOWQiPz4gPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iQWRvYmUgWE1QIENvcmUgNS4zLWMwMTEgNjYuMTQ1NjYxLCAyMDEyLzAyLzA2LTE0OjU2OjI3ICAgICAgICAiPiA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPiA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtbG5zOnhtcE1NPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvbW0vIiB4bWxuczpzdFJlZj0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL3NUeXBlL1Jlc291cmNlUmVmIyIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChXaW5kb3dzKSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDozNzlCQzA1MUREMTExMUUyQjQ0REVGOUExMUE1NUJBMyIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDozNzlCQzA1MkREMTExMUUyQjQ0REVGOUExMUE1NUJBMyI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjM3OUJDMDRGREQxMTExRTJCNDRERUY5QTExQTU1QkEzIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjM3OUJDMDUwREQxMTExRTJCNDRERUY5QTExQTU1QkEzIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+H9VfTQAAAJBJREFUOE+d01sKgCAURVFtUE2muQTNpck0KmODhpiPc+/+sZ+zwMB43k8wlq5jj/k7bPlUS/n8sgC/MalAd0wKMBzTCpiOaQYsxzQCpDH1AHlMLWAaUw2Yx1QA15gA3GMC+B6Gp3IFN1L/RBdSA2RGWoBMSA8gGRkBJCEzgJbICqApogA0RFSAuogFoAYJ4QWKeRAvsXw0vgAAAABJRU5ErkJggg==" alt="" draggable="false" /></div>' +
			'<div id="PopupArrowRight" style="margin-top: 0px; margin-left: 0px; display: none;"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAZCAYAAAA4/K6pAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6NDFDNEE3ODRERDI2MTFFMkI2OEI4QUIyMUFDRjFEMDgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6NDFDNEE3ODVERDI2MTFFMkI2OEI4QUIyMUFDRjFEMDgiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDo0MUM0QTc4MkREMjYxMUUyQjY4QjhBQjIxQUNGMUQwOCIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo0MUM0QTc4M0REMjYxMUUyQjY4QjhBQjIxQUNGMUQwOCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PnH/20IAAAB1SURBVHjapNXRDYAgDEVRXhd3GpdxqWc00cQIpOXyB4RDKC3Idnvath9XR63QojNmCpSQmMyZAikkEpuYAlMkCgE3BbpIFfghK8AHWQVehAA3QgERQOQIIkEUuUaRRBJJZZFiEilnkQcl9ToHWTwCSv/CKcAAS0QSHax/mhEAAAAASUVORK5CYII=" alt="" draggable="false" /></div>' +
		'</div>';

	var htmlPopupOuter = "<div id=\"Pop_Up_Outer\"></div>";
	$('#Pop_Up').append(htmlPopupOuter);
	$('#Pop_Up_Outer').html(htmlPopupList);

	if(Footer == 0){
		var popupInnerListWidth = $('#PopupList').outerWidth() - 26; //26 border und padding der Textelemente
		newpopupListFooterWidth = (( popupInnerListWidth - 180) * (0.28 / 120)) + 49.03;
		setCSS('poplist-footer-cancel', 'width', newpopupListFooterWidth + '%');
		setCSS('poplist-footer-save',   'width', newpopupListFooterWidth + '%');
	}

	setPositionPopupList(tagObj);

	initScrollbars('PopUp_List_Container');

	if(scrollToIndex != -1){
		//Aufruf der scroll to Methode
	}
}


function listElementClicked(e, isMultiple){
	if(isMultiple){
		if($('#' + e.target.id).hasClass('popup-list-clicked')){
			$('#' + e.target.id).removeClass('popup-list-clicked');
		}	
		else{
			$('#' + e.target.id).addClass('popup-list-clicked');
		}	
	}
	else{
		$('#PopupList').find('.popup-list-clicked').removeClass('popup-list-clicked');
		$('#' + e.target.id).addClass('popup-list-clicked');
	}
}


function setPositionPopupList (tagObj){
	var containerWidth  = $(tagObj).outerWidth();
	var containerHeight = $(tagObj).outerHeight();
	var containerOffset = $(tagObj).offset();
	var popupListWidth  = $('#popup-outer').outerWidth();
	var popupListHeight = $('#popup-outer').outerHeight();
	var popuoListTop  = 0;
	var popupListLeft = 0;
	var popupListMaxHeight = 320 + 90;
	var documentOffsetWidth = $('body').offset().left;
	var documentWidth = $('body').outerWidth();
	var arrowTop = 0;
	var offsetContainerHeight = 8; // um die Rundung der PopupList f�r den pfeil auszugleichen

	//Popup und Pfeil von Oben oder Unten ausrichten
	if((containerOffset.top + (containerHeight/2)) < 240){
		popupListTop = 53;
		arrowTop = popupListHeight + 63;
		// Ist das popup zu klein um neben dem Container zu erscheinen, dann Differenz besstimmen und neu von Oben ausrichten.
		if((containerOffset.top + (containerHeight / 2)) > (popupListHeight + popupListTop - offsetContainerHeight)){
			//alert("oben container zu klein");
			arrowTop += ((containerOffset.top + containerHeight/2) - (popupListHeight/2 + popupListTop));
			popupListTop += ((containerOffset.top + containerHeight/2) - (popupListHeight/2 + popupListTop));
		}
	}
	else{
		popupListTop = 53 + popupListMaxHeight - popupListHeight;
		arrowTop = popupListMaxHeight + 63;
		// Ist das popup zu klein um neben dem Container zu erscheinen, dann Differenz besstimmen und neu von Unten ausrichten.
		if((containerOffset.top + (containerHeight / 2) - offsetContainerHeight) < (popupListTop)){
			//alert("unten container zu klein");
			arrowTop -= (popupListTop - containerOffset.top - containerHeight/2 + popupListHeight/2);
			popupListTop -= (popupListTop - containerOffset.top - containerHeight/2 + popupListHeight/2);
		}
	}

	//Popup Links und Pfeil Rechts oder Popup Rechts und Pfeil Links ausrichten
	if((containerOffset.left - documentOffsetWidth + (containerWidth/2)) > 400){
		popupListLeft = containerOffset.left - popupListWidth - documentOffsetWidth;

		if((documentOffsetWidth) > (containerOffset.left - popupListWidth)){
			//alert("popup links ausserhalb");
			popupListLeft += documentOffsetWidth - containerOffset.left - popupListWidth;
		}

		$('#PopupArrowRight').show();
		$('#PopupArrowRight').css({'margin-left': (popupListWidth - 5) + 'px', 'margin-top': (containerOffset.top + (containerHeight/2) - arrowTop) + 'px'});
	}
	else{
		popupListLeft = containerOffset.left + containerWidth - documentOffsetWidth;
		
		if((documentOffsetWidth + documentWidth) < (containerOffset.left + containerWidth + popupListWidth)){
			//alert("popup rechts ausserhalb");
			popupListLeft-= (containerOffset.left + containerWidth + popupListWidth) - (documentOffsetWidth + documentWidth);
		}

		$('#PopupArrowLeft').show();
		$('#PopupArrowLeft').css({'margin-left': '-11px', 'margin-top': (containerOffset.top + (containerHeight/2) - arrowTop) + 'px'})
	}

	$('#Pop_Up').css({'padding-left': popupListLeft + 'px', 'top': popupListTop + 'px'});
}


function closePopupList(tagId, isIndexUsed, isMultiple, isSave){
	if(isSave){
		outputStringTemp = "";
		outputString = "";
		outputIndicesString = "";
		outputIndicesStringTemp = "";
		indexList = [];
		
		var i = 0;
		$('#PopupList .popup-list-clicked').each(function() {
			outputStringTemp = $(this).html();
			outputString += outputStringTemp + ", ";
			indexListObj = new Object();
			indexListObj.Name = outputStringTemp;
			
			if(isIndexUsed){
				str = $(this).attr('id');
				outputIndicesStringTemp = str.split('_')[1];
				outputIndicesString += outputIndicesStringTemp + ", ";
				indexListObj.Index = parseInt(outputIndicesStringTemp);
			}
			
			indexList[i] = (indexListObj);
			i++;
		});
		$('#' + tagId).html(outputString.substring(0, outputString.length - 2));
		
		if(isIndexUsed){
			outputIndicesString = outputIndicesString.substring(0, outputIndicesString.length - 2);
			
			if(isMultiple){
				submitSET(tagId, outputIndicesString);
			}	
			else{
				submitSET(tagId, parseFloat(outputIndicesString));
			}	
		}
		else{
			submitSET(tagId, outputString);
		}
		
		if(isMultiple){
			g_popupList_Indices[tagId]= indexList;
		}	
		else{
			g_popupList_Indices[tagId] = outputIndicesString;
		}	
	}

	hideHTML('Pop_Up_Blocker');
	$('#Pop_Up_Outer').remove();
	g_isPopUp = false;
}
//Popup-List functions end


/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~keypad~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
var keypad_selectionStart = 0;
var keypad_selectionEnd = 0;
var keypad_cursorposition = keypad_selectionStart;
var keypad_isPassword = false;

//Keypad functions
function showKeypad(tagId, isPasswordShown){
	if(numpadOpen && !($('#meindiv').is(':empty'))){
		handleNoneClosedNumpad();
	}
	
	g_isPopUp = true;
	showHTML('Pop_Up_Blocker');
	
	if(typeof isPasswordShown != "undefined"){
		keypad_isPassword = true;
	}
	else{
		isPasswordShown = true;
	}

	var inputType = "text";
	
	if(!isPasswordShown){
		inputType = "password";
	}

	setCSS("Pop_Up", "paddingLeft", "12px");
	setCSS("Pop_Up", "top", "80px");
	
	if(keypad_isPassword){
		inputString = $('#' + tagId).val();
	}
	else{
		inputString = $('#' + tagId).html();
	}
	
	var htmlKeypad = '' +
	'<div id="flat-keyboard">' +
		'<div id="keytop"><input type="' + inputType + '" id="keypad_textfield" maxlength="30" value=""><div id="keypad_delete_all" onClick=\'keyDeleteAll();\'></div></div>' +
		'<div id="keyboard">' +
			'<div id="gray">' +
				'<ul onClick=\'keyPressed(event);\'>'+
					'<li id="key_Q">Q</li>' +
					'<li id="key_W">W</li>' +
					'<li id="key_E">E</li>' +
					'<li id="key_R">R</li>' +
					'<li id="key_T">T</li>' +
					'<li id="key_Y">Y</li>' +
					'<li id="key_U">U</li>' +
					'<li id="key_I">I</li>' +
					'<li id="key_O">O</li>' +
					'<li id="key_P">P</li>' +

					'<li style="margin-left: 38px;" id="key_A">A</li>' +
					'<li id="key_S">S</li>' +
					'<li id="key_D">D</li>' +
					'<li id="key_F">F</li>' +
					'<li id="key_G">G</li>' +
					'<li id="key_H">H</li>' +
					'<li id="key_J">J</li>' +
					'<li id="key_K">K</li>' +
					'<li style="margin-right: 36px;" id="key_L">L</li>' +
				'</ul>' +
			'</div>' +
			'<div id="blue">' +
				'<ul>' +
					'<li id="key_case" onClick=\'keyCase();\'><img id="capsLockIndicator" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAcCAYAAABlL09dAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MkQ2MjU1NjM2NDk1MTFFMjgzM0RBNzg1NDMyQUI5NEYiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MkQ2MjU1NjQ2NDk1MTFFMjgzM0RBNzg1NDMyQUI5NEYiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyRDYyNTU2MTY0OTUxMUUyODMzREE3ODU0MzJBQjk0RiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDoyRDYyNTU2MjY0OTUxMUUyODMzREE3ODU0MzJBQjk0RiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PlTSZb8AAAESSURBVHjaYnz27BkDESAciNuB+C8QZwPxLkIamIgw1AeIFwCxIhCrAPFKILai1GB3IF4NxBxIYgJAvAmILcg12BGIV6EZCgPCUMONSDXYDGooHx6LRYF4LRCrE2uwKdQ1IkSEvwIQb8VmOLrBWtAwFWcgHihDXS6Py2BVqKHyDKQDbSBeAcQS6AbLQw3VYiAfWECToijMYDEgXg7E+gyUAzsgXgTE/IzAnHcAyLBnoC5YD3LxKwbqg9cgF7MCGdJoElOA2JsYA4DYElqGIINHLEDiNxA/QJP4TKTL/gDxXVJyHhORBjMCMQslBpAMRg0eNXjUYDIMZiQhS5Nk8F9aGVwMxJcIGPoFiKOgJRwGAAgwAOHMLUqq+uczAAAAAElFTkSuQmCC" alt="" draggable="false" /></li>' +
				'</ul>' +
			'</div>' +
			'<div id="gray">' +
				'<ul onClick=\'keyPressed(event);\'>' +
					'<li id="key_Z">Z</li>' +
					'<li id="key_X">X</li>' +
					'<li id="key_C">C</li>' +
					'<li id="key_V">V</li>' +
					'<li id="key_B">B</li>' +
					'<li id="key_N">N</li>' +
					'<li id="key_M">M</li>' +
				'</ul>' +
			'</div>' +
			'<div id="blue" style="float: none;">' +
				'<ul>' +
					'<li onClick=\'keyPressedDelete();\' id="key_delete"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACMAAAAUCAYAAAAHpoRMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo4MDcyNTg3Mjk1NjRFMjExODMzREU3RkVGNjRGMTBGMCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDowNDJCODg1NDY0OTYxMUUyQUE3MkZCN0M0MzE5RkUzRiIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDowNDJCODg1MzY0OTYxMUUyQUE3MkZCN0M0MzE5RkUzRiIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChXaW5kb3dzKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjgwNzI1ODcyOTU2NEUyMTE4MzNERTdGRUY2NEYxMEYwIiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOjgwNzI1ODcyOTU2NEUyMTE4MzNERTdGRUY2NEYxMEYwIi8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+kms0+QAAAMBJREFUeNrMluEOgzAIhNvG9+b2sn0N5xZ/GCzuQNaNpIkpKX6hd2jtvRciZFsoX472LyAMzDSQTzBTQa5gvCCPfUXz71iSQKDOe/JmZyJXsx6eoTqgQVa2M1GN4PDiomrAU7/ucyZDrLjQBVW/JboGhh7o+i+YmujOSu6ZMGBsF3AVc31DN90FGtlXvEDLQPmSAAKVp+q3aEuN2SEDa0tkzkQ7ZM0VNn+aMx6r/uSrneWytP+ZqUCN1MQUoKcAAwBn9TnAENTOqwAAAABJRU5ErkJggg==" alt="" draggable="false" /></li>' +
					'<li id="key_toggle" onClick=\'toggleLetters2Numbers();\'>?123</li>' +
				'</ul>' +
			'</div>' +
			'<div id="gray">' +
				'<ul>' +
					'<li id="key_space" onClick=\'keyPressed(event);\' style="width: 184px;"><img id="key_space_img" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADgAAAAbCAYAAAApvkyGAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjZDRTI1QTkzNjU5MzExRTJCODBFRTI3MzI4NTFCNTAzIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjZDRTI1QTk0NjU5MzExRTJCODBFRTI3MzI4NTFCNTAzIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6NkNFMjVBOTE2NTkzMTFFMkI4MEVFMjczMjg1MUI1MDMiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6NkNFMjVBOTI2NTkzMTFFMkI4MEVFMjczMjg1MUI1MDMiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6x5ePLAAAAXUlEQVR42uzWMQ6AIBAEQE78/4/1bKkoTBTE2YqG5CbcJkRmlpWzlcUDCAgICAjYyX7jTvsziJfmPJpzfRr4qU3TwT92cETOUcC0ooDzdTC8ICAgICAgIOAUuQQYAJ/JBz0OY7VCAAAAAElFTkSuQmCC" alt="" draggable="false" /></li>' +
					'<li id="key_left"  onClick=\'setFocusPosition("left");\'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAAAaCAYAAACkVDyJAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjU1OUJGMjMzNjU5NTExRTJCODQyRUVCNzEwNDc4NUJBIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjU1OUJGMjM0NjU5NTExRTJCODQyRUVCNzEwNDc4NUJBIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6NTU5QkYyMzE2NTk1MTFFMkI4NDJFRUI3MTA0Nzg1QkEiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6NTU5QkYyMzI2NTk1MTFFMkI4NDJFRUI3MTA0Nzg1QkEiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz7BgMvAAAABH0lEQVR42mL8//8/Az0BEwOdwfC3kOX58+fEqBMD4lVA/AqIo4H4Ny19KA/EG4DYHohDgViaIh8SkFcF4tVArE+PONSC+kyfHonGFIi3QS2lbqLBImYGxJuAWByHnilA/JnEFM4IxH+BuBjdQkdoahTBo9mbAg9qIbvSHRpnIjTMhnowH/pAUyMHPUqacHpZBrOwnV6WwSz8S+/COxuIP9DTwl3QpP6WntXTMWhKfU1j+74gZ/wTQOwBxGuBWAGPJpCj/kBLD1JKGhCOYnz27Bm6pDoQbwViZRyaVYD4LhE1DTbwB1t5eBMap1dxaIKl6j9kYJwFMMzSE/Rs0zwE4kAgPkTPRtQLIA4B4h20rA+xpcoIIJ4PZT+ixEKAAAMAj8BBH6I9ZekAAAAASUVORK5CYII=" alt="" draggable="false" /></li>' +  
					'<li id="key_right" onClick=\'setFocusPosition("right");\'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABwAAAAaCAYAAACkVDyJAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjYwMDIwNEUzNjU5NTExRTI4NEUyODQ0MkYwNDhCRkU3IiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjYwMDIwNEU0NjU5NTExRTI4NEUyODQ0MkYwNDhCRkU3Ij4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6NjAwMjA0RTE2NTk1MTFFMjg0RTI4NDQyRjA0OEJGRTciIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6NjAwMjA0RTI2NTk1MTFFMjg0RTI4NDQyRjA0OEJGRTciLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz4oiaX1AAABJ0lEQVR42mL8//8/Az0BEwOdwfC3kOX58+eU6GcF4qVALAbEYUD8itY+lAbiUCC2B+INQCxPzyC1BOKNQKxKzzjUh/pUi56JBmTZNiA2xZpogFgKiHuBmBmISSkF/gExLw45UFxuBmI/ID6FLMH47Nmzi0Baj0a54A009e5HDlI9GmY7EWicutMz4/NBLfWhZ0nDAcSrgTicnkUbyNJ2epelf+lp4Qcgzmahk2VvoXnyGMiHX2hs2WtoCj0GK2kCgHgZtJQhpaT5D9UvikfNAyAOBuJzyEXbXmg1Qyr4A8TKQHwHh/xdIPYG4pvoZSlMM1mpDof4VajPbtKjtjiBzWfoPqQWOAQqTYD4BT3qwx1AHILPMmr48BEQz4Km1EQg/khIA0CAAQBa2Tm1gSmEkAAAAABJRU5ErkJggg==" alt="" draggable="false" /></li>' +
					'<li id="key_dot"   onClick=\'keyPressed(event);\'>.</li>' +
				'</ul>' +
			'</div>' +
			'<div id="blue">' +
				'<ul>' +
					'<li id="key_cancel"  style="width: 115px;" class="" onClick=\'closeKeypad(false, "' + tagId + '");\'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACoAAAAjCAYAAADizJiTAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2RpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo4QUU1Nzg4RUM3NDRFMjExQTNCREVFNkMxQjk4MkM0NiIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo5MzZGRjRERTlCMEExMUUyODk1Njg0NkIwNjI4NjhFQSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo5MzZGRjRERDlCMEExMUUyODk1Njg0NkIwNjI4NjhFQSIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpBQkE3RDFEQUYyOUFFMjExQkY4NkRDQzBDNkQwODQ3QiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo4QUU1Nzg4RUM3NDRFMjExQTNCREVFNkMxQjk4MkM0NiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PgP6w2kAAAEOSURBVHjazNjhCoMwDATgOn3uSvbekiEIG0PW3OXaLiDbD3d+DNKmLu5eGlWvz2fRFpZ7Qn9c1d9VG/ciF5wbDVNiqVwkTIGlc9GwDDaVy4Qx2HTu46u3VqBr7aNzW91tQO4a7XpzrKron/Tr2VAzKbAyZGt5ymClyBaUxcqRESiDlSOj0F5YQ9ZhZMG2WUgUqsIasasVZr+20UgWymJp5N0WGq1j0G/Cg7NiW5SMiCORKexoJI2dgaSws5AwVo008TxLn0Kj66Qc23Myl2K7Hh+U2K7HByU2cwo93xntgft28L2V9BTKDBipXCY0MwXRuWhoalTL5CKhCiSduwUa4e57tuDcJfDG+S/qJcAAD2lfl8d7hcoAAAAASUVORK5CYII=" alt="" draggable="false" /></li>' +
					'<li id="key_confirm" style="width: 113px;" class="" onClick=\'closeKeypad(true, "' + tagId + '");\'><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACoAAAAjCAYAAADizJiTAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2RpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo4QUU1Nzg4RUM3NDRFMjExQTNCREVFNkMxQjk4MkM0NiIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpCQUIxRDZCQTlCMEExMUUyQTcxMEEzNzJDMzE5ODFDMyIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpCQUIxRDZCOTlCMEExMUUyQTcxMEEzNzJDMzE5ODFDMyIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M1IFdpbmRvd3MiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpBQkE3RDFEQUYyOUFFMjExQkY4NkRDQzBDNkQwODQ3QiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDo4QUU1Nzg4RUM3NDRFMjExQTNCREVFNkMxQjk4MkM0NiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Psw8DHIAAADdSURBVHja7NjrCoMwDAXg6fbcGWcv3lHYj9GbaTpPMvBAQaHgh61NcEsp3f4heyCLfEYzj0BIfN2/qhl56Z2HpDpSzouIbGKjIivsHmRP9nL33KOaN5kDz6U3IdlQM5IJXUKyoMtIBvQnyCOotCqEB3IElVE5YyN7UFXtZSJbUHXtZSJL6FTtZSJLKJQPEjaytfQW7OnI3sc0g6UgR8eTFktBHh34iILUlFBEQGprPbyRM00JPJGz3RO8kJY2Dx5Iaz8KNnKlcQYTmYf139Ozc31atuu34wUNnrcAAwCJ1ARaCuqr5QAAAABJRU5ErkJggg==" alt="" draggable="false" /></li>' +
				'</ul>' +
			'</div>' +
		'</div>' +
	'</div>';
	
	var htmlKeypadOutter = document.createElement('div');
	
	htmlKeypadOutter.setAttribute("id", "Pop_Up_Outer");
	Pop_Up.appendChild(htmlKeypadOutter);
	setHTML("Pop_Up_Outer", htmlKeypad);
	$("#keypad_textfield").val(inputString);
	//$("#keypad_textfield").focus();
	
	keyState = 0;
	shift = 1;
	capsLock = 0;
	setFocusPosition("set2End");
	
	$('#keypad_textfield').bind("click", function(){
		getFocusPosision("click");
	});
	$('#keypad_textfield').bind("input", function(){
		getFocusPosision("input");
	});
}

var inputString = "";
var keyState = 0;
var shift = 1;
var capsLock = 0;

var keys = new Array();

keys[0]= new Object();
keys[0]["key_Q"]= "Q";
keys[0]["key_W"]= "W";
keys[0]["key_E"]= "E";
keys[0]["key_R"]= "R";
keys[0]["key_T"]= "T";
keys[0]["key_Y"]= "Y";
keys[0]["key_U"]= "U";
keys[0]["key_I"]= "I";
keys[0]["key_O"]= "O";
keys[0]["key_P"]= "P";
keys[0]["key_A"]= "A";
keys[0]["key_S"]= "S";
keys[0]["key_D"]= "D";
keys[0]["key_F"]= "F";
keys[0]["key_G"]= "G";
keys[0]["key_H"]= "H";
keys[0]["key_J"]= "J";
keys[0]["key_K"]= "K";
keys[0]["key_L"]= "L";
keys[0]["key_Z"]= "Z";
keys[0]["key_X"]= "X";
keys[0]["key_C"]= "C";
keys[0]["key_V"]= "V";
keys[0]["key_B"]= "B";
keys[0]["key_N"]= "N";
keys[0]["key_M"]= "M";
keys[0]["key_toggle"]= "?123";
keys[0]["key_dot"]= ".";

keys[1]= new Object();
keys[1]["key_dot"]= ",";

keys[2]= new Object();
keys[2]["key_Q"]= "1";
keys[2]["key_W"]= "2";
keys[2]["key_E"]= "3";
keys[2]["key_R"]= "4";
keys[2]["key_T"]= "5";
keys[2]["key_Y"]= "6";
keys[2]["key_U"]= "7";
keys[2]["key_I"]= "8";
keys[2]["key_O"]= "9";
keys[2]["key_P"]= "0";
keys[2]["key_A"]= "!";
keys[2]["key_S"]= "@";
keys[2]["key_D"]= "#";
keys[2]["key_F"]= "$";
keys[2]["key_G"]= "%";
keys[2]["key_H"]= "~";	//"&";
keys[2]["key_J"]= "*";
keys[2]["key_K"]= "?";
keys[2]["key_L"]= "/";
keys[2]["key_Z"]= "_";
keys[2]["key_X"]= "|";	//"\"";
keys[2]["key_C"]= "\\";
keys[2]["key_V"]= "(";
keys[2]["key_B"]= ")";
keys[2]["key_N"]= "-";
keys[2]["key_M"]= "+";
keys[2]["key_toggle"]= "ABC";
keys[2]["key_dot"]= ".";


function closeKeypad(isConfirm, tagId){
	if(isConfirm){
		if(keypad_isPassword){
			$('#' + tagId).val(inputString);
		}
		else{
			$('#' + tagId).html(inputString);
		}
		
		//alert (inputString + " wird gespeichert");
		submitSET(tagId, inputString);
	}
	else{
		//alert (inputString + " wird verworfen");
	}
	
	inputString = "";
	
	hideHTML('Pop_Up_Blocker');
	$('#Pop_Up_Outer').remove();
	
	g_isPopUp = false;
}


function keyPressed(e){
	if(inputString.length <= 30){
		if((e.target.id == 'key_space') || (e.target.id == 'key_space_img')){
			inputChar = " ";
		}	
		else{
			inputChar = e.target.innerHTML;
		}

		inputString = [inputString.slice(0, keypad_cursorposition), inputChar, inputString.slice(keypad_cursorposition)].join('');
		keypad_cursorposition++;
	}

	
	//$("input").val(inputString);
//	$("#keypad_textfield").focus();
	
	if(!capsLock && !keyState){
		toogleLettersUpperlower();
	}

	setFocusPosition("set2Current");
}


function keyPressedDelete(){
	if(keypad_cursorposition > 0){
		//inputString = inputString.substring(0, inputString.length - 1);
		inputString = [inputString.slice(0, keypad_cursorposition-1), inputString.slice(keypad_cursorposition)].join('');
		//$("input").val(inputString);
		//$("#keypad_textfield").focus();
		keypad_cursorposition--;
	}
	
	setFocusPosition("set2Current");
}

function keyDeleteAll(){
	inputString = "";
	
	setFocusPosition("set2Current");
}

function keyCase(){
	if(shift && capsLock){
		shift = 0;
		capsLock = 0;
	}
	
	if(keyState){
		shift = 1;
	}	
	
	if(shift && !keyState){
		capsLock = 1;
	}	
	
	if(!capsLock){
		toogleLettersUpperlower();
	}
	
	if(capsLock){
		setHTML_Attribute('capsLockIndicator', "src", 'data:image/png;base64,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');
	}
	else{
		setHTML_Attribute('capsLockIndicator', "src", 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABYAAAAcCAYAAABlL09dAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MkQ2MjU1NjM2NDk1MTFFMjgzM0RBNzg1NDMyQUI5NEYiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MkQ2MjU1NjQ2NDk1MTFFMjgzM0RBNzg1NDMyQUI5NEYiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoyRDYyNTU2MTY0OTUxMUUyODMzREE3ODU0MzJBQjk0RiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDoyRDYyNTU2MjY0OTUxMUUyODMzREE3ODU0MzJBQjk0RiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PlTSZb8AAAESSURBVHjaYnz27BkDESAciNuB+C8QZwPxLkIamIgw1AeIFwCxIhCrAPFKILai1GB3IF4NxBxIYgJAvAmILcg12BGIV6EZCgPCUMONSDXYDGooHx6LRYF4LRCrE2uwKdQ1IkSEvwIQb8VmOLrBWtAwFWcgHihDXS6Py2BVqKHyDKQDbSBeAcQS6AbLQw3VYiAfWECToijMYDEgXg7E+gyUAzsgXgTE/IzAnHcAyLBnoC5YD3LxKwbqg9cgF7MCGdJoElOA2JsYA4DYElqGIINHLEDiNxA/QJP4TKTL/gDxXVJyHhORBjMCMQslBpAMRg0eNXjUYDIMZiQhS5Nk8F9aGVwMxJcIGPoFiKOgJRwGAAgwAOHMLUqq+uczAAAAAElFTkSuQmCC');
	}
}


function toogleLettersUpperlower(){
	if(keyState != 2){
		keyState^= 1;
		
		for(var key in keys[0]){
			str = $('#' + key).html();
			
			if(key == 'key_dot'){
				$('#' + key).text(keys[keyState][key]);
			}
			else{
				if(keyState == 0){
					$('#' + key).text(str.toUpperCase());
				}	
				
				if(keyState == 1){
					$('#' + key).text(str.toLowerCase());
				}	
			}
		}

		//$("#keypad_textfield").focus();
	}
}


function toggleLetters2Numbers(){
	if(keyState == 2){
		keyState = 0;
		shift = 1;
		capsLock = 0;
	}
	else{
		keyState = 2;
	}
	
	for(var key in keys[keyState]){
		$('#' + key).text(keys[keyState][key]);
	}	
	
	$("#keypad_textfield").focus();
}


function setFocusPosition(cmd){
	var inputfield = $('#keypad_textfield');
	var strLength = inputfield.val().length;

	if(cmd == "set2End"){
		keypad_cursorposition = strLength;
	}
	
	if(cmd == "left"){
		if(keypad_cursorposition != 0){
			keypad_cursorposition--;
		}
	}
	
	if(cmd == "right"){
		if(keypad_cursorposition < strLength){
			keypad_cursorposition++;
		}
	}

	inputfield.focus();
	$("#keypad_textfield").val(inputString);
	inputfield[0].setSelectionRange(keypad_cursorposition, keypad_cursorposition);
	// das hier wird gebraucht um die tastatur sekection eines textes zu erfassen
//	$('#foo').select(function(e) {
//	    var start = e.target.selectionStart;
//	    var end = e.target.selectionEnd;
//	    console.log('Changed: ' + start + ' to ' + end);
//	});
}

var inputCount = 0;

function getFocusPosision(eventType){
	//inputfield = document.getElementById('keypad_textfield');
	
	//	if (inputfield.selectionStart) { 
	//		cursorStart = inpufield.selectionStart;
	//	}
	//	if (inputfield.selectionStart) { 
	//		cursorEnd = inpufield.selectionEnd;
	//	}
		
	setFocusPosition("set2current");
}
//Keypad functions end

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Numpad~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Numpad functions
var numpadOpen = false;
var numpadSysTime = 0;
var numpadTargetTagId = "";
var numpadValue = 0;
var numpadTestValue = 0;
var numpadUnit = "";
var numpadPreValue = numpadValue;
var numpadIsTestUsed = false;
var numpadIsTestActive = false;
var numpadIsHTMLNumpadFirst = false;

//init limits object
var numpadMaxValue = 100;
var numpadMinValue = -100;
var numpadResolution = 0.1; // 1, 0.5 und 0.1 m�glich
var numpadIsSigned = 1;

function showNumpad(tagId, tagLimit, isTestUsed, isLimitFunction){
	if(numpadOpen && !($('#meindiv').is(':empty'))){
		handleNoneClosedNumpad();
	}
	
	if(typeof isTestUsed != "undefined"){
		numpadIsTestUsed = isTestUsed;
	}
	
	g_isPopUp = true;
	numpadOpen = true;
	
	showHTML('Pop_Up_Blocker');

	if(typeof g_numpadLimitObj[tagLimit] != "undefined"){
		if(g_numpadLimitObj[tagLimit]["IsSigned"] != -1){
			numpadMaxValue = g_numpadLimitObj[tagLimit]["Max"];
			numpadMinValue = g_numpadLimitObj[tagLimit]["Min"];
			
			//momentan liefert OutputResolution	dezimal, Anzeigegenauigkeit (siehe enum: E_OUTPUTResolution)
			//0 - kein Runden
			//1 - Runden auf 1/10
			switch(g_numpadLimitObj[tagLimit]["OutputResolution"]){
				case 3: numpadResolution = 1; break;
				case 2: numpadResolution = 0.5; break;
				case 1: ;
				case 0: ;
				default: numpadResolution = 0.1;
			}
			
			numpadIsSigned = g_numpadLimitObj[tagLimit]["IsSigned"];
		}
	}
	
	if(typeof isLimitFunction != "undefined"){
		setDependingLimits(tagId);
	}

	numpadTargetTagId = tagId;
	numpadStr = getHTML(numpadTargetTagId);
	numpadStr = splitUnitFromValue(numpadStr);
	//numpadValue = (parseFloat(numpadStr.value)) + ""; //TODO wenn diese zeile rausgenommen wird, dann muss das "+" zeichen weg
	numpadValue = numpadStr.value;

	if(numpadValue.substring(0, 1) == "+"){
		numpadValue = numpadValue.substring(1, numpadValue.length);
	}	

	numpadUnit = numpadStr.unit;
	numpadPreValue = numpadValue;
	numpadTestValue = numpadValue;
	$('#Pop_Up').css({'top': '80px', 'padding-left': '11px'});
	var htmlNumpadOutter = "<div id=\"Pop_Up_Outer\"></div>";
	$('#Pop_Up').append(htmlNumpadOutter);
	$('#Pop_Up_Outer').html(getHtmlNumpadSlider(numpadTargetTagId));
	numpadSlider();
	setPositionNumpad(numpadTargetTagId, numpadIsTestUsed);
}


function getHtmlNumpadSlider(numpadTargetTagId){
	htmlButtonMoveUp = 	 '<div id="Button_Start_Up" class="button_servo_move_stop button_servo_move_stop_top" onClick="numpadHandleTest(\'Up\', true);"><a draggable="false">Test</a></div>' +
						 '<div id="Button_Stop_Up"  class="button_servo_move_stop button_servo_move_stop_top" onClick="numpadHandleTest(\'Up\', false);"><a draggable="false">Stop</a></div>';
	htmlButtonMoveDown = '<div id="Button_Start_Down" class="button_servo_move_stop button_servo_move_stop_bottom" onClick="numpadHandleTest(\'Down\', true);"><a draggable="false">Test</a></div>' +
						 '<div id="Button_Stop_Down"  class="button_servo_move_stop button_servo_move_stop_bottom" onClick="numpadHandleTest(\'Down\', false);"><a draggable="false">Stop</a></div>';
	
	var htmlNumpadSlider = '' +
	'<div id="flat-numipt" style="position: absolute;">' +
		htmlButtonMoveUp +
		'<div id="PopupArrowUp" style="margin-top: -20px; padding-left: 0px; display: none;"><div class="popup_icon_arrowUp"></div></div>' +
		'<div id="tray" style="height: 62px;">' +
			'<div style="font-size: 16px; margin-left: 26px; padding-top: 16px; text-align: center; height: 46px; width: 705px;">' +
			//'<div style=" font-size:16px; margin-left:26px; padding-top:26px; text-align:center; height:36px; width:705px;">' +
				//'<div id="numiptSlider"></div>' +
				'<div id="Slider_Track" style="width: 705px; height: 30px;">' +
					//track_way_bg2.png
					'<img width="705" height="30" draggable="false" alt="" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAsEAAAAeCAYAAADNRsOnAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MUMxRTlBREFDRTQ5MTFFMkIzMTNGOUQ0QzM4REZFNkUiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MUMxRTlBREJDRTQ5MTFFMkIzMTNGOUQ0QzM4REZFNkUiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDoxQzFFOUFEOENFNDkxMUUyQjMxM0Y5RDRDMzhERkU2RSIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDoxQzFFOUFEOUNFNDkxMUUyQjMxM0Y5RDRDMzhERkU2RSIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pn1sK4cAAAD1SURBVHja7NzRCYMwFEDRWFxAXMsVnKF0ktIZXCFriSOkaZtAcQA/knPgIf6+r0sIGVJKAQAAenKzAgAARDAAAIhgAAAQwQAAIIIBAEAEAwCACAYAABEMAAAiGAAArjLGGG0BAIBuLMviJBgAgP6M5bvmeeWZrAQAgAYdee55ts9PPQl+CmAAABo2leYN/xE82wsAAI2bzxEMAADdqBG8WwUAAI3bzxH8CL/LwgAA0KKjNO9XfR1iKwMAAM1zJxgAgO4MKSVbAACgK06CAQAQwQAAIIIBAEAEAwCACAYAABEMAAAiGAAARDAAAIhgAAC4zFuAAQB1uxOBDaUmdQAAAABJRU5ErkJggg==" />' +
					'<div style="width: 705px; text-align: left; margin-top: -33px; margin-left: -22px;">' +
						//track_button.png
						'<img id="Slider_Thumb" width="51" height="30" style="cursor: pointer; left: 0%; position: relative;" draggable="false" alt="" src="data:image/png;base64,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"/>' +
					'</div>' +
				'</div>' +
			'</div>' +
			'<div id="tray" style="height: 124px;">' +
				'<div class="clear"></div>' +
				'<div id="gray">' +
					'<ul>' +
						'<li id="DecrementButton" style="width: 124px;" onClick="changeNumpadValue(\'dec\');"><div class="popup_icon_minus"></div></li>' +
					    '<li id="IncrementButton" style="width: 125px;" onClick="changeNumpadValue(\'inc\');"><div class="popup_icon_plus"></div></li>' +
					    /*BAT60 specific*/
					    '<li id="Control_IMG" style="width: 125px;"><div class="popup_icon_rotaries" style="background-image: url(data:image/png;base64,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);"></div></li>' + //Eule hier
					    /*BAT60 specific end*/
					    '<li id="SwitchToNumButton" style="width: 125px; font-size: 24px;" onClick="toggleNumpad(false);">123...</li>' +
					    '<li id="ResetValButton" style="width: 125px;" onClick="resetNumpadValue();"><div class="popup_icon_reset"></div></li>' +
					    '<li id="CheckButton" class="numipt_popup-close" style="width: 124px;" onClick="closeNumpad(false);"><div class="popup_icon_ok"></div></li>' +
					'</ul>' +
				'</div>' +
				'<div id="blue"></div>' +
			'</div>' +
		'</div>' +
		'<div id="PopupArrowDown" style="margin-top: 68px; padding-left: 0px; position: absolute; display: none;"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAANCAYAAABcrsXuAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkU1MjhGRUZFNDg2MzExRTJCNTYxODhBMDEzMUJDMzVCIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkU1MjhGRUZGNDg2MzExRTJCNTYxODhBMDEzMUJDMzVCIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6RTUyOEZFRkM0ODYzMTFFMkI1NjE4OEEwMTMxQkMzNUIiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RTUyOEZFRkQ0ODYzMTFFMkI1NjE4OEEwMTMxQkMzNUIiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5lMsq2AAAAZUlEQVR42rSUSQrAIBAEu3x4XpPP+KqYixBCjNu0MOCtxl7kOPMl80n3YGaQ6sUFqC+RCcRTLhlAvD1RMIgv4xUIopUuBYH4i7ACQPR6ok0QI2Xc2ZTRxq9qzsy3smLuVCiKAAMAa2gDHN9KacgAAAAASUVORK5CYII=" alt="" draggable="false" /></div>' +
		htmlButtonMoveDown +
	'</div>';

	return htmlNumpadSlider;
}


function getHtmlNumpadPad(tagId){
	if(numpadResolution == 1){
//		classDot = "numpad_dot_inactive";
		classDot = "no_edit";
	}	
	else{
		classDot = "";
	}	

	var htmlNumpadPad = '' +
		'<div id="flat-numipt">' +
			'<div id="PopupArrowUp" style="margin-top: -20px; padding-left: 0px; display: none;"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAAQCAYAAADj5tSrAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6Mzc5QkMwNTFERDExMTFFMkI0NERFRjlBMTFBNTVCQTMiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6Mzc5QkMwNTJERDExMTFFMkI0NERFRjlBMTFBNTVCQTMiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDozNzlCQzA0RkREMTExMUUyQjQ0REVGOUExMUE1NUJBMyIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDozNzlCQzA1MEREMTExMUUyQjQ0REVGOUExMUE1NUJBMyIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Ph/VX00AAABpSURBVHja3NRLCsAgDATQZg7e0/QyPdXUlVj6ScckmwoiUSYPQbR12xdxsE1TApgAxjUdoVOHEYr7MsLguYsweFMX4eSj+IyowGsOicBjHsnAbR8UAJd+KAJOEAqBDhlZbbTf9DfIIcAAYpMj5/WxV2sAAAAASUVORK5CYII=" alt="" draggable="false" /></div>' +
			'<div id="graybtn" style="height: 62px;">' +
				'<ul>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'1\');">1</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'2\');">2</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'3\');">3</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'4\');">4</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'5\');">5</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'6\');">6</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'7\');">7</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'8\');">8</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'9\');">9</li>' +
					'<li class="NumpadNum" onClick="changeNumpadValue(\'0\');">0</li>' +
				'</ul>' +
			'</div>' +
			'<div id="tray" style="height: 124px;">' +
				'<div class="clear"></div>' +
				'<div id="gray">' +
					'<ul>' +
						//Diese beiden werden zusammengefasst
//		      			'<li id="MinusButton" style="width:106px" onclick="changeNumpadValue(\'minus\',\'' + tagId + '\');"><img src="images/-.png" /></li>' +
//		      			'<li id="PlusButton" style="width:107px" onclick="changeNumpadValue(\'plus\',\'' + tagId + '\');"><img src="images/+.png" /></li>' +
						'<li id="MinusButton" style="width: 124px; font-size: 35px;" onClick="changeNumpadValue(\'toggle\');">+/<span style="margin-top: -5px;">-</span></li>' +  
						'<li id="DotButton" class="' + classDot + '" style="width: 125px;" onClick="changeNumpadValue(\'.\');">.</li>' +
						'<li id="BackspaceButton" style="width: 125px;" onClick="changeNumpadValue(\'del\');"><div class="popup_icon_delete"></div></li>' +
						'<li id="SwitchToSliderButton" style="width: 125px;" onClick="toggleNumpad(true);"><div class="popup_icon_slidebar"></div></li>' +
						'<li id="ResetValButton" style="width: 125px;" onClick="resetNumpadValue();"><div class="popup_icon_reset"></div></li>' +
						'<li id="CheckButton" style="width: 124px;" onClick="closeNumpad(true);"><div class="popup_icon_ok"></div></li>' +
					'</ul>' +
				'</div>' +
				'<div id="blue"> </div>' +
			'</div>' +
			'<div id="PopupArrowDown" style="margin-top: 6px; padding-left: 0px; position: absolute; display: none;"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABkAAAANCAYAAABcrsXuAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyBpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBXaW5kb3dzIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkU1MjhGRUZFNDg2MzExRTJCNTYxODhBMDEzMUJDMzVCIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkU1MjhGRUZGNDg2MzExRTJCNTYxODhBMDEzMUJDMzVCIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6RTUyOEZFRkM0ODYzMTFFMkI1NjE4OEEwMTMxQkMzNUIiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6RTUyOEZFRkQ0ODYzMTFFMkI1NjE4OEEwMTMxQkMzNUIiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5lMsq2AAAAZUlEQVR42rSUSQrAIBAEu3x4XpPP+KqYixBCjNu0MOCtxl7kOPMl80n3YGaQ6sUFqC+RCcRTLhlAvD1RMIgv4xUIopUuBYH4i7ACQPR6ok0QI2Xc2ZTRxq9qzsy3smLuVCiKAAMAa2gDHN9KacgAAAAASUVORK5CYII=" alt="" draggable="false" /></div>' +
		'</div>';

	return htmlNumpadPad;  
}


function setPositionNumpad(tagId, numpadIsTestUsed){
	var widthContainer  = $('#' + tagId).outerWidth();
	var heightContainer = $('#' + tagId).outerHeight();
	var numpadHeight = 140;
	var numpadTop = 0;
	var documentWidthOffset = $('body').offset().left + 30; // die 20px sind der offset von der Grafik, die es zu verschieben gilt

	var offsetContainer = $('#' + tagId).offset();
	
	if(offsetContainer.top > 240){
		numpadTop = offsetContainer.top - numpadHeight;
		$('#PopupArrowDown').show();
		
		if(numpadIsTestUsed){
			if(numpadIsTestActive){
				$('#Button_Stop_Down').show();
			}
			else{
				$('#Button_Start_Down').show();
			}
		}

		$('#PopupArrowDown').css({'padding-left': (offsetContainer.left + (widthContainer/2) - documentWidthOffset) + 'px'})
	}
	else{
		numpadTop = offsetContainer.top + heightContainer;
		$('#PopupArrowUp').show();
		
		if(numpadIsTestUsed){
			if(numpadIsTestActive){
				$('#Button_Stop_Up').show();
			}
			else{
				$('#Button_Start_Up').show();
			}	
		}

		$('#PopupArrowUp').css({'padding-left': (offsetContainer.left + (widthContainer/2) - documentWidthOffset) + 'px'})
	}
	
	$('#Pop_Up').css({'top': numpadTop + 'px'});
}


function numpadSlider(){
	setSliderThumb();
	
	var handlerMousemove = function(event){onSliderEvent(event, false)};

	var handlerBind = function(){
		$("#Slider_Track").bind("mousemove", handlerMousemove);
	}

	var handlerUnbind = function(event){
		$("#Slider_Track").unbind("mousemove", handlerMousemove);
	}

	$("#Slider_Track").bind("mousedown", handlerBind);
	$("#Slider_Track").bind("mouseup", function (event){onSliderEvent(event,true);});
	$(document).bind("mouseup", handlerUnbind);

	//wurde ersetzt durch direkt Aufruf der mouseup Funktion.
	//Sollte ein browser damit nicht zurecht kommen, muss das klick Event wieder rein und umgeschrieben werden
	//(auf eigenen Handler-Variable mit �bergabe-Parameter "true")
	//$("#Slider_Track").bind("click", handlerMousemove);
}


function setSliderThumb(){
	sliderVal = (parseFloat(numpadValue) - numpadMinValue)*100/(numpadMaxValue - numpadMinValue);
	$('#Slider_Thumb').css("left", sliderVal + "%");
}


function onSliderEvent(e, isMouseUp){
	var offset = numpadMaxValue - numpadMinValue;
	var offsetTrack = $('#Slider_Track').offset().left;

	pixelVal = e.pageX - offsetTrack;

  	if(pixelVal < 0){
  		pixelVal = 0;
  	}	

  	if(pixelVal > 705){
  		pixelVal = 705;
  	}	

  	sliderVal = pixelVal*100/705;
	$('#Slider_Thumb').css("left", sliderVal + "%");
 
  	//numpadValue = (numpadMinValue + offset*sliderVal/100).toFixed(1);
	numpadValue = (numpadMinValue + offset*sliderVal/100);
	
	if(numpadResolution == 0.5){
		numpadValue = (Math.round(parseFloat(numpadValue) * 2))/2;
	}
	
  	getToFixed(); 

	outputValue = checkSignPlus(numpadValue);
	$('#' + numpadTargetTagId).html(outputValue + numpadUnit);

	if(isMouseUp){
		submitSET(numpadTargetTagId, parseFloat(numpadValue));

		return;
	}

	var zeit = new Date();
	var ms = zeit.getMilliseconds();

	if((zeit - numpadSysTime) > 500){
		submitSET(numpadTargetTagId, parseFloat(numpadValue));
		numpadSysTime = zeit;
	}
}


function toggleNumpad(isPad){
	$('#flat-numipt').remove();

	if(isPad){
		isHTMLNumpadFirst = false;
		checkNumpadValue(numpadTargetTagId);
		//alert("Wert wird gespeichert");
		submitSET(numpadTargetTagId,  parseFloat(numpadValue));
		$('#Pop_Up_Outer').html(getHtmlNumpadSlider(numpadTargetTagId));
		numpadSlider();
		setPositionNumpad(numpadTargetTagId, numpadIsTestUsed);
	}
	else{
		isHTMLNumpadFirst = true;
		$('#Pop_Up_Outer').html(getHtmlNumpadPad(numpadTargetTagId));
		setPositionNumpad(numpadTargetTagId, numpadIsTestUsed);
	}
}


function closeNumpad(isPad){

	if(numpadIsTestUsed){
		if(numpadIsTestActive){
			var tagIdArrayTest = numpadTargetTagId.split("__");
			tagIdArrayTest = tagIdArrayTest[1].split("_");
			IndexTest = parseInt(tagIdArrayTest[0]);
			
			GetTd({"cmd":0x0257, "param": {"ServoIdx": IndexTest}}, "noEvent", "command");
			numpadIsTestActive = false;
			submitSET(numpadTargetTagId,  parseFloat(numpadValue));
		}
	}	
	
	if(isPad){
		checkNumpadValue(numpadTargetTagId);
		submitSET(numpadTargetTagId,  parseFloat(numpadValue));
	}	
	
	hideHTML('Pop_Up_Blocker');
	
	//alert("Wert wird gespeichert");
	$('#Pop_Up_Outer').remove();
	
	numpadOpen = false;
	g_isPopUp = false;
}


function handleNoneClosedNumpad(){
	//numpadValue = numpadPreValue;
	setHTML(numpadTargetTagId, numpadValue);
	//numpadHandleTest("", false);
	closeNumpad(true);
}


function changeNumpadValue(key, ControlValue){
	switch(key){
		case 'control': numpadValue = parseFloat(numpadValue) + ControlValue*numpadResolution;
						getToFixed();
		 				break;
		case 'dec': 	numpadValue = parseFloat(numpadValue) - numpadResolution;
						getToFixed();
						break;
		case 'inc':		numpadValue = parseFloat(numpadValue) + numpadResolution;
						getToFixed();
						break;
		case 'toggle':	if(numpadValue.substr(0, 1) == "-"){
							numpadValue = numpadValue.substr(1, numpadValue.length);
						}
						else{
							numpadValue = "-" + numpadValue;
						}
						break;			
		case '.':		if(numpadValue.indexOf('.') == -1){
							numpadValue += '.';
						}
						break;
		case 'del':		if((numpadValue.length != 1) || (numpadValue.substr(0, 1) != "-")){
							numpadValue = numpadValue.substr(0, numpadValue.length -1);
						}
						isHTMLNumpadFirst = false;
						break;
		default:		if(isHTMLNumpadFirst){
							if(numpadValue.substr(0, 1) == "-"){
								numpadValue = "-";
							}
							else{
								numpadValue = "";
							}
							isHTMLNumpadFirst = false;
						}
						numpadValue += key;
						dotPos = numpadValue.indexOf('.');
						//Eingabe auf eine Stelle nach dem Komma(Punkt) begrenzen
						if(dotPos != -1){
							numpadValue = numpadValue.substr(0, dotPos + 2);
							
							if(numpadResolution == 0.5){
								if(numpadValue.length > dotPos + 1){
									numpadValue = (Math.round(parseFloat(numpadValue) * 2))/2;
									getToFixed();
								}
							}
						}
						//fuehrende nullen vermeiden
						if((numpadValue.substr(0, 1) == '0') && (numpadValue.length > 1) && (dotPos == -1)){
							numpadValue = numpadValue.substr(1, numpadValue.length);
						}
						else if((numpadValue.substr(0, 1) == '-') && (numpadValue.substr(1, 1) == '0') && (numpadValue.length > 2) && (dotPos == -1)){
							numpadValue = "-" + numpadValue.substr(2, numpadValue.length);
						}
						break;	
	}

	if(parseFloat(numpadValue) > numpadMaxValue){
		numpadValue = numpadMaxValue + "";
	}	
	else if (parseFloat(numpadValue) < numpadMinValue){
		numpadValue = numpadMinValue + "";
	}	

	outputValue = checkSignPlus(numpadValue);
	$('#' + numpadTargetTagId).html(outputValue + numpadUnit);

	if((key == 'dec') || (key == 'inc') || (key == 'control')){ 
		//alert("Wert wird gespeichert");
		submitSET(numpadTargetTagId, parseFloat(numpadValue));
		setSliderThumb();
	}
}


function resetNumpadValue(){
	isHTMLNumpadFirst = true;
	numpadValue = numpadPreValue;
	submitSET(numpadTargetTagId,  parseFloat(numpadValue));
	checkNumpadValue(numpadTargetTagId);
	setSliderThumb();
}


function checkNumpadValue(tagId){
	numpadValue += '';

	if(numpadValue.indexOf('.') == numpadValue.length){
		numpadValue += 0;
	}	

	if((numpadValue == '') || (numpadValue == '-')){
		numpadValue = "0";
	}	

	//numpadValue = parseFloat(numpadValue).toFixed(1);
	getToFixed();
	outputValue = checkSignPlus(numpadValue);
	$('#'+ tagId).html(outputValue + numpadUnit);
}


function checkSignPlus(numpadValue){
	if(numpadIsSigned && (numpadValue.substr(0, 1) != "-")){
		outputValue = "+" + numpadValue;
	}	
	else{
		outputValue = numpadValue;
	}	
	
	return outputValue;
}


function getToFixed(){
	switch(numpadResolution){
		case 1:  numpadValue = parseFloat(numpadValue).toFixed(0); break;
		default: numpadValue = parseFloat(numpadValue).toFixed(1);
	}
}


function splitUnitFromValue(str){
	result = new Object();
	result.value = str;
	result.unit = "";
	
	for(var i = 0; i < str.length; i++){
		subStr = str.substring(i, i + 1);
		
		if((isNaN(subStr)) && (subStr != ".")  && (subStr != "-") && (subStr != "+")){
			result.value = str.substring(0, i);
			result.unit = str.substring(i, str.length);
			break;
		}
	}
	
	return result; 
}


function numpadHandleTest(buttonPosition, isTestActive){
	if(numpadIsTestUsed){
		numpadIsTestActive = isTestActive;
		if(numpadIsTestActive){
			$('#Button_Start_' + buttonPosition).hide();
			$('#Button_Stop_' + buttonPosition).show();
		}
		else{
			var tagIdArrayTest = numpadTargetTagId.split("__");
			tagIdArrayTest = tagIdArrayTest[1].split("_");
			IndexTest = parseInt(tagIdArrayTest[0]);
			
			GetTd({"cmd":0x0257, "param": {"ServoIdx": IndexTest}}, "noEvent", "command");
			
			$('#Button_Stop_' + buttonPosition).hide();
			$('#Button_Start_' + buttonPosition).show();
			submitSET(numpadTargetTagId, parseFloat(numpadValue));
		}
		
		handleTest(numpadTargetTagId, numpadValue);
	}	
}
//Numpad functions end

/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Dialogbox~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

//Dialogbox text
	//Delete
	//Wizzard
	var wizardStep1 = '"Kurulum Sihirbazı" na hoş geldiniz. Lütfen eklemek istediğniz model tipini seçiniz.';
	var wizardStep2 = 'Modelinizin tipine göre boş satırları doldurunuz. Unutmayınız ki, kontrol yüzey sayısı ve dümen tipi daha sonra değişitirilemez.';
	var wizardStep3 = 'Temel kontrolleri seçiniz.';
	var wizardStep4 = 'Uçağınızın durumuna göre satırları doldurunuz. Her ne olursa olsun alıcınızı bağlama işlemini şimdi yapınız. Daha sonra istediğiniz zaman bu menüden değişiklik yapabilirsiniz.';
	var wizardStep5 = 'Her hareketli kontrol yüzeyi için alıcınızın üzerindeki etiket numarasına göre bir fiş seçiniz. Servo parametrelerini, özellikle limitlerini giriniz. ';
	var wizardStep6 = 'Son adım olarak, geri kalan tüm servoları ayarlayın ve bir isim verin.';
	var wizardStep7 = 'Modeliniz için fonksiyonlar yaratılmıştır. Gereksinimlerinize göre fonksiyonlarınızı ayarlayın, kontroller ekleyin ve atanmış servoların çalışma aralıklarını ayarlayın.';
//Dialogbox text end
	
function showDialogbox(type, listType, name, index){
	if(numpadOpen && !($('#meindiv').is(':empty'))){
		handleNoneClosedNumpad();
	}
	else{
		hideHTML('Pop_Up_Blocker');
		$('#Pop_Up_Outer').remove();
		$('#Dialog_Outter').remove();
	}
	
	setCSS("Pop_Up", "paddingLeft", "0px");
	setCSS("Pop_Up", "top", "0px");
	//type = "wizard";
	
	//Dialogtext
	if((type == "delete") || (type == "deleteModel")){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%;">' + 'Silmek istediğinizden emin misiniz?' + ' ' + listType +  
							 	'<span style="font-weight: 700; white-space: nowrap;"> \"' + name  + '\"</span>? ' +
							 	'Bunu geri alamazsınız!' +
							'</div>' +
						 '</div>';
		header = 0;
		footer = 0;
	}
	else if(type == "changeRxType"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + 'Verici (RX) tipini değiştirdiğiniz zaman Servo Ayarları silinir ve sıfırlanır. Bu işlemi geri alamazsınız!' +
							'</div>' +
						 '</div>';
		header = 0;
		footer = 0;
	}
	else if(type == "saveCurve"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + 'Düzenlediğiniz eğriyi kaydetmek istiyor musunuz?' +
							'</div>' +
						'</div>';
		header = 0;
		footer = 0;
	}
	else if(type == "setTravel"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + 
								'Servo Çalışma aralığını ayarlamak mı istiyorsunuz?' +
								'<b>' + listType + '</b>' +
								'Limit ve Merkez ayarları otomatik mi olsun?' +
							'</div>' +
						'</div>';
		header = 2;
		footer = 0;
	}
	else if((type == "modelNameExistsAdd") || (type == "modelNameExistsConfig")){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + 'Bu Model Adı kullanılmış! Başka bir isim veriniz.' +
							'</div>' +
						 '</div>';
		header = 0;
		footer = 1;
	}
	else if(type == "StrickControlInfo"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + listType +
							'</div>' +
						 '</div>';
		header = 2;
		footer = 1;
	}
	else if(type == "info"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + listType +
							'</div>' +
						 '</div>';
		header = 2;
		footer = 1;
	}
	else if(type == "error"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + listType +
							'</div>' +
						 '</div>';
		header = 4;
		footer = 1;
	}
	else if(type == "actionWait"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + listType +
							'</div>' +
						 '</div>';
		header = 3;
		footer = -1;
	}
	else if(type == "progress"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + listType +
							'</div>' +
							'<div style="width: 98.5%; height: 50px; margin-top:25px; border: solid 4px #fff; border-radius: 5px;">'+
								'<div id="Dialog_Box_Progressbar" style="width: 0%; height: 100%; background: rgba(96, 153, 240, .7);"></div>' +
							 '</div>' +
						 '</div>';
		header = 5;
		footer = 4;
	}
	else if(type == "binding"){
		htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
							'<div style="width: 100%; text-align: center;">' + listType +
							'</div>' +
						 '</div>';
		header = 3;
		footer = 3;
	}
	else if((type == "rfConnected") || (type == "changeModelRfConnected") || (type == "addModelRfConnected")){
		if(type == "rfConnected"){
			htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
								'<div style="width: 100%;">' + listType +
								'</div>' +
							 '</div>';
		}
		else{
			htmlDialogText = '<div id="Dialogbox_Text" class="dialogbox-text">' +
								'<div style="width: 100%;">' + 'Verici ile bağlantı hala etkin durumda!' +
								'</div>' +
							 '</div>';
		}

		header = 0;
		footer = 2;
		htmlFooterButtonTextOk     = 'Unut';
		htmlFooterButtonTextCancel = 'Çık';
	}
	else if(type == "wizard"){
		switch (listType){
			case "wizardStep1": wizzardText = wizardStep1; break;
			case "wizardStep2": wizzardText = wizardStep2; break;
			case "wizardStep3": wizzardText = wizardStep3; break;
			case "wizardStep4": wizzardText = wizardStep4; break;
			case "wizardStep5": wizzardText = wizardStep5; break;
			case "wizardStep6": wizzardText = wizardStep6; break;
			case "wizardStep7": wizzardText = wizardStep7; break;
		}

		htmlDialogText = '<div id="Dialogbox_Text" style= "margin: 15px 10px 25px 10px;">' +
							'<div style="width: 100%;">' + wizzardText + '</div>' +
						 '</div>';
		header = 1;
		footer = 1;
	}
	else{
		header = -1;
		footer = -1;
		htmlDialogText = "";
	}
	
	//Header
	if(header == 0){//Warning
		htmlDialogHeader = 	'<div class="dialogbox-header">' +
								'<div class="icon_warning"></div>' +
								'<div>' + 'Uyarı' + '</div>' +
							'</div>';
	}
	else if(header == 1){//Wizard
		if(index == 0){
			htmlDialogHeaderWizard = '';
		}
		else{
			htmlDialogHeaderWizard = '<div style="float: right; margin-right: 10px;">' + 'Step' + ' ' + index + ' ' + 'of 6' + '</div>';
		}

		htmlDialogHeader = 	'<div class="dialogbox-header">' +
								'<div>' +
									'<div class="icon_wizard"></div>' +
									'<div>' + 'Kurulum Sihirbazı' + '</div>' +
								'</div>' +
								htmlDialogHeaderWizard +
							'</div>';
	}
	else if(header == 2){//Info
		htmlDialogHeader = 	'<div class="dialogbox-header">' +
								'<div class="icon_info"></div>' +
								'<div>' + 'Bilgi' + '</div>' +
							'</div>';
	}
	else if(header == 3){//Wait for Action
		htmlDialogHeader = '<div class="dialogbox-header" style="margin-right: 20px;">' +
								'<img width="96" height="96" style="margin: -29px 15px 0px 10px;" align="middle" draggable="false" alt="Warning" src="data:image/gif;base64,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" />' +
								'Lütfen Bekleyiniz' + '</div>';
	}
	else if(header == 4){//Error
		htmlDialogHeader = 	'<div class="dialogbox-header">' +
								'<div class="icon_error"></div>' +
								'<div>' + 'Hata' + '</div>' +
							'</div>';
	}
	else if(header == 5){//Progresss
		htmlDialogHeader = 	'<div class="dialogbox-header" style="margin-right: 20px;">' +
								'<img width="96" height="96" style="margin: -29px 15px 0px 10px;" align="middle" draggable="false" alt="Warning" src="data:image/gif;base64,R0lGODlhYABgAKIEANCKEM+ID9GKENCIDwAAAAAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQJBwAEACwAAAAAYABgAAAD/0i63P4wykmrvTjrzbv/YCiOZGmeaKqubOu+cCzPdG3feK7vfO//wKBwSCwaj8ikcslsOp/QqHRKrVqvEoBgMNgOAAAuFywod7uC8Hmr6mrB3LQYHYbHvWfGeS8278tbWnEDBIQThhhgBHVfaWGAaYFzcm4PXnJbkXiAfFyFiBGgixSCgn59X4Oqgodoa2d1l2KLlRJdDaIOcAKFmah2f3MWqcRoZYKwn7G2oJ4RkXlvcY9+1M4Xc2Ooxry+aKGpvWkRyKrayJxfYRzTrn1lCsXHABCPhHcQxW6EcqaXvh3WONr2SZ82Ngs03QOEi04mWQQ4eVOTK0M2TPDUmCKmBv/PpFSSxkDDSJHNuzesPqhbOWvTtj1ktACi13GQF43H/nWTxIleiEauFNx05+ZhMTILKQLdBZTOLHRqRngjpFSmOkiQsn3DmukROmhF4fHxKaJnRIH9iFqj9CViT6DVSnocY+/WCGO9ajZiO/cXP38UlU6EyYYRiTEK1orxmtOYuVswofYhc+oOGy8kxln92NEMGEYgH/ZKVVJjI8E8IVfkkHEaHJmvg6HyRe+mt7mBfOmcZfdnIdiwcHsU/OrTUNulKH/U1pbXXUgyh/eVZEqjspAvmUskem1GYOr7YDUtJXL1kOmBamPUrQXKvH/36JpBKKWOPUXzvWIxnZsPlgVKXsUX1H/xBDUTWQSe5cksCTb0m3MNMlCYeQS2R2GC30SYj4YcdujhhyCGKOKIJJZo4okopqjiiiy26OKLMMYo44w01mjjjThekAAAIfkECQcABAAsAAAAAGAAYAAAA/9Iutz+MMpJq7046827/2AojmRpnmiqrmzrvnAsz3Rt33iu73zv/8CgcEgsGo/IpHLJbDqf0Kh0Sq1arxTAYAvQCr4D7fZLFgDIA8EAVVanw9s0ueseewWQ91tdF5/TZ2BmBGkTaxhefm5afl1wcHyHEnFcgIt8ZWMEXxR4DJJ5boJfdJGAcXwXYmNgfpRya3EAk54LtQ+whGOQj3ZhahqPdaeYb4SOsxFhDGfKv3ukZ46ZcR2YkY6/nJteWxF8s7m4gpSXbdG3G6tvd1wEdKjeuIGEZukKYmaQf5HUhSBqArUyJkofGGMLKsX6xUDUrmkK94XRIuKPnEVrEp2yVCb/38VnH+sE7AON1zYRsOCF6/XMIqxLukztYgUOTjd9e0roK6XgYE1YXLBVCxhP4MSgqN5V6pKMBDxvB38FMokm6ix7S4tpDUTR3ImLeDhCszfMTD5gDoHacekTGKp7IU5tsmqJUrtyaF+VDSrSVL2TJeTEvBaVFa914cxO3TrqWpe5cEE0mztzTryZxFKpNZXP4k849b4qwOyK3zCwU3VJZZXI8ltym0A51dN5nWNpdZftQlfXrF5BjgidqEOZ06hn58rGtsRPlh5v8d6RycF4T7aLjIACRjLwbaHj0uhE6XY5dkFAVZ4L9ikGSz+L2SJP0RMWKJaGu7gFvN9A4HL+Ow8AQw+ADrglG4GjhYNgHvIs6MCBDkYo4YQUVmjhhRhmqOGGHHbo4YcghijiiCSWaOKJKKao4oosYpgAACH5BAkHAAQALAAAAABgAGAAAAP/SLrc/jDKSau9OOvNu/9gKI5kaZ5oqq5s675wLM90bd94ru987//AoHBILBqPyKRyyWw6n9CodEqtWq8YgWAgAAAGXLB4C/5uz4PSWUsWD75vdjucFZvvWjfcTUhHBFlzaABsXlx5YwAbZXlsYFuEh12KXBJ+C5cPh4ZhkJFfZmgeb4SloYePlWZ/mQSAEGOpc2ZhoSGcZLNchH1jsJlgsJCFeqhlXq+3b8duj4prXZp0axBrm4S5knkmbafICqhwyZhsrmIOqWW12nJfJ92ewc2gnZh89QpdXXG6jY6VKHbl8tIH0qZlsfY4moNwkkGFzbao6CSJAC1SjxyFOmMu/44eXNe00NPXihtGVbU2DkNTqI+hUhQz7prWJtqKdBbDsdzH8Jw4N4icMUK1LxiLSID8IQqFdNibXkjtyOIZtJfRm+d40hIZSZ2/NGf24CEFsyiaqxOD1RS565NGmebI/AQaRlslOiy0uMKmLyqobAPTdLoTq+5OQwXzphGHbGazTmHdveUXVqvBSedc0ILJl664heZAwenquHBXRS62hQWXsWjCR1a7rnwsOHM5Hl5JZasF2LETr1XlMJQoZTDs3bCtcDq+DxlqKx6jYy5ZpVmvolgYzAS0MXuDe+68O9CbWfz3xdTNVxpnvgHH9tXgy59Pv779+/jz69/Pv7///xYABijggAQWaOCBCCao4IIMNujgBQkAACH5BAkHAAQALAAAAABgAGAAAAP/SLrc/jDKSau9OOvNu/9gKI5kaZ5oqq5s675wLM90bd94ru987//AoHBILBqPyKRyyWw6n9CodEqtWq8cwUCgHQAGYK0AwP2GASLwl9wVj71kbzgE3rrhXHmdS0BH/BNhdXZqX2NrbiNqXGONd2sDBGASgAoCD11xeV1qdocnmZtkZnUEXRGTDJENnYR4dqOjKWyuXpySWl8QXgxjDrZhYrVbALopjIOMYqZlWg/BfaeqxYXBcVvYLYSbdpKGbJcNpNHGCtiC2G+CxS+ciJHXe3kL3H3drel7csirLsmMppINIoWNoKFFjKjV4tavRcJscIIVVKcwEroypDbliQNJ+AY6U9TcISvWhp0oWGeAQbrlMZGtXGI4woQ2iFiZi9sIzQDHzKCmh4NA6qHlxk1IWzQgvhN4CBlAeYdGXcSYp+GLUv+qAktZVdI5d3qUwSqz85JNYaI4VTVj76CykD/jWdWGZl9KhaNg3rrZKJ/TYXOveuIY8RyhcTKJCXoD7iONN1795DO8SE60mmPl1E0VJ4jGdIj4qusGpXFNr+jWVHF0LrLawKXb8PomDEuzYmaoYqFXB43scLt7bkE9PPiCNXWdGWflu/jyXhaBP+ctaTomMtafZd/Ovbv37+DDix9Pvrz58+jTq1/Pvr379/Djy59Pv759KAkAACH5BAkHAAQALAAAAABgAGAAAAP/SLrc/jDKSau9OOvNu/9gKI5kaZ5oqq5s675wLM90bd94ru987//AoHBILBqPyKRyyWw6n9CodEqtWq/YpkArGAgEAG/3OygPAJFBQ80wd91lQLi8hcXnb3e+3gCv12duYWNmXjFzYgBkYG8EZw9lDF1tcYlgiopjM2R0hF6fk2tgal6Kkl2KhWOobJtnX7BnaHkOeI6vC2KLdKCmNZ2chrFfDJmPiAqMccOxkTaFmVuXhAGqqW/YYdqgeYE4YoGksmR4r8Tgcrvk14Xf4NKD7+FujqvXmKW8ZjmfpvjhX+KBI8CpG7Yx5Vo9G+QoU7pVAUehMTPH4S49fnI0YkUOw+KeWarA8XqTyhkOYtgqCeokR01JfKuALePzTE0wlelKebplLJVPTogU/qrXbxieg1u4VQx4BxWrbzxV5ptJTlzETvqCtuSn8xWoShyFccxjDCIdjRT3FKIzCKGskl9F6qMZJF/Vc9o8hYrCCNG5TxTRVJEbSa8vK6hKNkuV5ZY3rHSvVCXYrnEuhrgsNwhDYKtmUQQFf26TdPQDhqYdCE3NurXr17Bjy55Nu7bt27hz697Nu7fv38CDCx9OvLjx40sSAAAh+QQJBwAEACwAAAAAYABgAAAD/0i63P4wykmrvTjrzbv/YCiOZGmeaKqubOu+cCzPdG3feK7vfO//wKBwSCwaj8ikcslsOp/QqHRKrVqv2KZAKhgAvIPuICwQAB5bxkA9DgPM7fHuWy6/v+F2o9s4K8Z4dV14Xjpibl1icA5lbAttgXAAk2uGXnCXX5QNgGt5lXadXm+JPW1id4lhDGWrh390p5JyPGSfY3aDf6gEZKRgn4eNpqiJpId5g3l3yWZwdXo9dJOtqsm4bwStgKrIpH49gp6YmLh65tWaYIpp4WQEx2St31/adeqotoU/rdpxz9jeWTMzCQ8hMUBW4YJ261avZZd8KaL2I1s1ZYpknbEW56MNoIK0TJ36dNAcIHvYoGFc6ANMPJIRn6GkdG8UzWi1fIGUJwzhv46EDrbbgexSLnSfHlYb1fFUvXAPPFo7Fo/csgeVjgCLBw9dwaFRivKJ5YyPFUSXes3DWSVSqHVPsSzceCduFpO9PGbNouAVQr4OsrEF/GiNXcILxiKG8G4xVseQI0ueTLmy5cuYM2vezLmz58+gQ4seTbq06dOoU6te3TkBACH5BAUHAAQALAAAAABgAGAAAAP/SLrc/jDKSau9OOvNu/9gKI5kaZ5oqq5s675wLM90bd94ru987//AoHBILBqPyKRyyWw6n9CodEqtWq/YpiBrGTS83C94AQh/y4vBFgpQD95vAWBNEAgG5btagb/b8W1oQW5zanp4aXAEcWt2coF4cUJtfnCUdosAhXVucnJqhXB0QIagjqJtfW+peo6VgYJAc4d+mnezmHGGn4yeiEJ/wZV9t2Vuq6edbkSHcbNwhF6UocOpe0PQpda9mZaRx9CjP7qWodlepZG8ds9jsse45Lt17H61zW/AxJb2gIAEl/4gmyYpiKtmf9rlecTIlLOCpIR96+dpUTlvmsDFGnfOb1swdNSgtSt1BNYth5T8WfMTJVClOwDvQasSChInZdeq8GuziNemK60EemrFxRFPcuKuZOP0xwwfRzedMoC5TOoCqu6s5kuqNadVBlm/ih1LtqzZs2jTql3Ltq3bt3Djyp1Lt67du3jz6t3Lt++SBAA7" />' +
								'Devam ediyor' + '</div>';
	}
	else{//no Header
		htmlDialogHeader = '';
	}
	
	//Footer
	if(footer == 0){//close with save or cancel (picture style)
		htmlDialogFooter = 	'<div style="background: #000; border-radius: 10px 10px 0px 0px; padding: 4px; clear: left; float: right;">' +
								'<div id="Footer_Left" class="dialogbox-footer round_left" style="clear: both;" onClick=\'closeDialogbox(true, "' + type +'",' + index + ',"' + name + '");\'>' +
									'<div class="dialogbox-close-save round_left"></div>' +
								'</div>' +
								'<div class="dialogbox-footer round_right" onClick=\'closeDialogbox(false, "' + type +'");\'>' +
									'<div class="dialogbox-close-cancel round_right"></div>' +
								'</div>' +
							'<div>';
	}						
	else if(footer == 1){//close without save
		htmlDialogFooter = 	'<div style="background: #000; border-radius: 10px 10px 0px 0px; padding: 4px; clear: left; float: right;">' +
								'<div class="dialogbox-footer round_top" onClick=\'closeDialogbox(true, "' + type + '");\'>' +
									'<div class="dialogbox-close-save"></div>' +
								'</div>' +
							'<div>';	
	}
	else if(footer == 2){//close with save or cancel (text style)
		htmlDialogFooter = 	'<div style="background: #000; border-radius: 10px 10px 0px 0px; padding: 4px; clear: left; float: right;">' +
								'<div id="Footer_Left" class="dialogbox-footer round_left" style="clear: both;" onClick=\'closeDialogbox(true, "' + type +'",' + index + ',"' + name + '");\'>' +
									'<div class="dialogbox-close-save round_left" style="background-image: none; line-height: 68px;">' + htmlFooterButtonTextOk + '</div>' +
								'</div>' +
								'<div class="dialogbox-footer round_right" onClick=\'closeDialogbox(false, "' + type +'");\'>' +
									'<div class="dialogbox-close-cancel round_right" style="background-image: none; line-height: 68px;">' + htmlFooterButtonTextCancel + '</div>' +
								'</div>' +
							'<div>';
	}
	else if(footer == 3){//Binding stop
		htmlDialogFooter = 	'<div style="background: #000; border-radius: 10px 10px 0px 0px; padding: 4px; clear: left; float: right;">' +
								'<div style="width: 200px;" class="dialogbox-footer round_top" onClick=\'closeDialogbox(true, "' + type + '");\'>' +
									'<div style="width: 100%; text-align: center; line-height: 70px;">' + 'Bağlamayı Durdur' + '</div>' +
								'</div>' +
							'<div>';	
	}
	else if(footer == 4){//close cancel
		htmlDialogFooter = 	'<div style="background: #000; border-radius: 10px 10px 0px 0px; padding: 4px; clear: left; float: right;">' +
								'<div class="dialogbox-footer round_top" onClick=\'closeDialogbox(true, "' + type + '");\'>' +
									'<div style="width: 100%; text-align: center; line-height: 70px;">' + 'Vazgeç' + '</div>' +
								'</div>' +
							'<div>';	
	}
	else{//no footer
		htmlDialogFooter = '';//	'<div style="background: #000; border-radius: 10px 10px 0px 0px; padding: 4px; clear: left; float: right;">' +
								//'<div class="dialogbox-footer round_top" onClick="closeDialogbox(false);">' +
									//'<div class="dialogbox-close-cancel"></div>' +
								//'</div>' +
							//'<div>';	
	}
	
	var htmlDialog = '' +
		'<div id="Dialog_Inner" class="dialogbox">' +
			htmlDialogHeader +
			htmlDialogText +
			htmlDialogFooter +
		'</div>';
	
	var htmlDialogOutter = document.createElement('div');
	htmlDialogOutter.setAttribute("id", "Dialog_Outter");
	Pop_Up.appendChild(htmlDialogOutter);
	setHTML("Dialog_Outter", htmlDialog);
	
//	var dialogBoxWidth = $('#Dialogbox_Text').outerWidth();
//	setCSS("Footer_Left", "marginLeft", 8 + (dialogBoxWidth - 300)/2 +"px");
	
	var widthContainer  = $('#Dialog_Outter').outerWidth();
	var heightContainer = $('#Dialog_Outter').outerHeight();
	
	setCSS("Dialog_Inner", "marginLeft", 796/2 - widthContainer/2 + "px");
	setCSS("Dialog_Inner", "top", 476/2 - heightContainer/2 + "px");
	
	$('#Dialog_Outter').addClass("dialogbox-outter");
}


function closeDialogbox(isConfirm, type, Index, name){
	$('#Dialog_Outter').remove();
	
	if(isConfirm){
		//alert (inputString + " wird gespeichert");
		switch(type){
			case "delete":					deleteItem(Index); break;
			case "deleteModel":				submitSET(Index, name); break;
			case "wizard":					if(typeof g_isWizzardPop != "undefined") g_isWizzardPop = false; break;
			case "changeRxType":			showPopupList($('#Receiver_Type'), g_popupList_Type, false, true, g_popupList_Indices); break;
			case "modelNameExistsAdd":		showKeypad('KeyPad_Temp'); break;
			case "modelNameExistsConfig":	showKeypad('Model_Name_List'); break;
			case "rfConnected":				GetTd({"cmd":0x0214}, "noEvent", "command"); closeDialogboxByTimer(Index); showDialogbox("info", name); break;
			case "changeModelRfConnected": 	submitSET(Index, name); break;
			case "addModelRfConnected": 	showKeypad('KeyPad_Temp'); break;
			case "binding":					binding(false); break;
			case "saveCurve":				/*g_gotoLocation = "1.14__ServoMonitor.html?LastURLMonitor=" + location.href;*/ isGotoSave= true; submitCurve("set", "save", g_curvePercentages, g_realPoints, g_currentFlightMode, g_global); break;
			case "progress":				GetTd({"cmd":0x0316, "param": {"Group": parseInt(g_currentGroupIndex)}}, "noEvent", "command"); break;
			case "setTravel":				showDialogbox("actionWait", 'Bütün Servo çalışma aralığı merkezine göre limitlenecektir.'); GetTd({"ModelWizard":{"cmd":4, "Servos":servoIdxArray}}, g_SetEvent, "4");break;
			case "StrickControlInfo":		window.location.href = "2.0__GeneralSettings.html"; break;
		}
	}
	else{
		switch(type){
			case "saveCurve":				g_curvePercentages = g_rollBackValue["CurveValue"].slice(0);
											g_realPoints = g_rollBackValue["RealPointsValue"].slice(0);
											//g_gotoLocation = "1.14__ServoMonitor.html?LastURLMonitor=" + location.href;
											isGotoSave = true;
											submitCurve("set", "save", g_curvePercentages, g_realPoints, g_currentFlightMode, g_global);
											break;
			case "setTravel":				if(g_isListViewButton){
												window.location.href = "1.3.2__ServoConfigurationListView.html?LastURL=" + g_lastURL;
											}
											else{
												window.location.href = g_lastURL;
											}
											break;
		}
		//alert (inputString + " wird verworfen");
	}
}


function closeDialogboxByTimer(counterValue){
	g_dialogBoxTimeoutFunction = setTimeout(function(){$('#Dialog_Outter').remove();}, counterValue);
}
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~SCROLLING~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
/*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
//Scrolling Start

//Param Init
var fixedContainerHeight  = 0;
var scrollContainerHeight = 0;
	
var maxPaddingNoPopUp = 0;
var max = false; 		//vertical
var min = false; 		//vertical
var maxLeft = false; 	//horizontal
var minLeft = false; 	//horizontal

//Key Scrolling
var isInit  = false;
var maxPaddingPopUp = 0;

var topValue  = 0, 		//vertical
	leftValue = 0; 		//horizontal

var otherPlatform = false;
//Param Init End

//TODO wird von jedem Popup aufgerufen und l�dt die scrollbar js
function initScrollbars(id){
	$('head').append('<link rel="Stylesheet" type="text/css" href="/css/mCSB.css" />');

	if(navigator.appVersion.indexOf("X11; U; Linux armv7l; c") != -1){
		//BAT60
		otherPlatform = false;

		$.getScript("/js/jquery.mCustomScrollbar.concat.min.js", function(data, textStatus, jqxhr){
			$('#' + id).mCustomScrollbar();

			/*if(id != "PopUp_List_Container"){
				var getHeight_dragrail = $('#scrollTool_1').height();
				var getHeight_visible  = $('#' + id).height();
				var getHeight_total    = $('#scrollContainerInnerVertical').height();
				var getHeight_ratio    = getHeight_dragrail/getHeight_total;

				$('.scrollContainerOuterVertical').find('.mCSB_dragger').css({'height': Math.floor(getHeight_visible * getHeight_ratio) + 'px'});
				$('.scrollContainerOuterVertical').find('.mCSB_dragger').children().css({'line-height': Math.floor(getHeight_visible * getHeight_ratio) + 'px'});
			}
			else{
				//alert('PopUp');
			}*/
		});

		isInit = true;
	}
	else{
		//Desktop
		otherPlatform = true;

		$.getScript("/js/jquery.mCustomScrollbar.concat.min.js", function(data, textStatus, jqxhr){
			$('#' + id).mCustomScrollbar();
//		  	//console.log( data ); // Data returned
//			//console.log( textStatus ); // Success
//			//console.log( jqxhr.status ); // 200
			log(2, "Load of scrollbar js-file was performed.");
		});
	}
}


function initScrollValues(){
	topValue   =   0; //vertical
	leftValue  =   0; //horizontal
}


function ScrollTo(char){
	if(typeof pre_g_List_Count == 'undefined' || g_PageRefreshed){
		pre_g_List_Count = -2;
		
		if(typeof g_List_Count == 'undefined')
			g_List_Count = -1;
	}

	if(pre_g_List_Count != g_List_Count){
		fixedContainerHeight  = $('.scrollContainerOuterVertical').height();
		scrollContainerHeight = $('#scrollContainerInnerVertical').height();

		var classHeight = $('.mCSB_container').height();
		var idHeight = $('#scrollContainerInnerVertical').height();

		maxPaddingNoPopUp = (scrollContainerHeight - fixedContainerHeight) * (-1);
		max = false;
		min = false;
		maxLeft = false;
		minLeft = false;
		
		pre_g_List_Count = g_List_Count;
		g_PageRefreshed = false;
	}

	if(g_isPopUp && isInit){
		popupfinished = $('#popup-wrapper').find("div.scrollContainerPopUpOuterVertical");

		if(typeof popupfinished != undefined){
			popupfinished.toggleClass("scrollContainerPopUpOuterVertical_active");
			$('#popup-wrapper').find("div#scrollContainerPopUpInnerVertical").attr("id", "scrollContainerPopUpInnerVertical_active");
			var fixedContainerPopUpHeight  = $('.scrollContainerPopUpOuterVertical_active').innerHeight(),
				scrollContainerPopUpHeight = $('#scrollContainerPopUpInnerVertical_active').innerHeight();
			maxPaddingPopUp = (scrollContainerPopUpHeight - fixedContainerPopUpHeight) * (-1);
			isInit = false;
		}

		maxPadding = maxPaddingPopUp;
	}

	if(!g_isPopUp)
		maxPadding = maxPaddingNoPopUp;

	//vertical start
	if((char == CONST_SCROLLING_Key_g) || (char == CONST_SCROLLING_Key_h) || (char == CONST_SCROLLING_Key_j)){
		//Scroll up
		min = false;

		switch(char){
			case CONST_SCROLLING_Key_g : 	topValue += CONST_SCROLLING_StepSmall;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepSmall;		break; //g
			case CONST_SCROLLING_Key_h : 	topValue += CONST_SCROLLING_StepMiddle; CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepMiddle;	break; //h
			case CONST_SCROLLING_Key_j : 	topValue += CONST_SCROLLING_StepBig;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepBig;		break; //j
		}

		if(topValue > 0)
			topValue = 0;
		else
			max = false;

		if(!max){
			animateScrollbar(topValue, CONST_SCROLLING_AnimationSpeed);

			if(topValue == 0){
				max = true;
			}
		}
	}
	
	if((char == CONST_SCROLLING_Key_b) || (char == CONST_SCROLLING_Key_n)|| (char == CONST_SCROLLING_Key_m)){
		//Scroll down
		max = false;

		switch(char){
			case CONST_SCROLLING_Key_b : 	topValue -= CONST_SCROLLING_StepSmall;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepSmall;		break; //b
			case CONST_SCROLLING_Key_n : 	topValue -= CONST_SCROLLING_StepMiddle;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepMiddle;	break; //n
			case CONST_SCROLLING_Key_m : 	topValue -= CONST_SCROLLING_StepBig;	CONST_SCROLLING_AnimationSpeed = CONST_SCROLLING_StepBig;		break; //m
		}

		if(topValue < maxPadding){
			topValue = maxPadding;
		}
		else{
			min = false;
		}

		if(!min){
			animateScrollbar(topValue, CONST_SCROLLING_AnimationSpeed);

			if(topValue == maxPadding){
				min = true;
			}
		}
	}
	//vertical end
}


function animateScrollbar(topValue, animationSpeed){
	if(g_isPopUp){
		var dragrailHeight = $('.scrollContainerPopUpOuterVertical').find('.mCSB_scrollTools').height();
		var totalHeight = $('.scrollContainerPopUpOuterVertical').find('.mCSB_container').height();
		var getHeight_ratio = dragrailHeight/totalHeight;

		$('#scrollContainerPopUpInnerVertical_active').animate({'top': topValue + 'px'}, animationSpeed);
		$('.scrollContainerPopUpOuterVertical').find('.mCSB_dragger').animate({'top': (topValue * getHeight_ratio * (-1)) + 'px'}, animationSpeed);
	}
	else{
		var dragrailHeight = $('#scrollTool_1').height();
		var totalHeight = $('#scrollContainerInnerVertical').height();
		var getHeight_ratio = dragrailHeight/totalHeight;
		
		$('#scrollContainerInnerVertical').animate({'top': topValue + 'px'}, animationSpeed);
		$('.scrollContainerOuterVertical').find('.mCSB_dragger').animate({'top': (topValue * getHeight_ratio * (-1)) + 'px'}, animationSpeed);
	}
}


function ScrollDownRefresh(){
	if(otherPlatform){
		$('#List_Container').mCustomScrollbar("update");
		$('#List_Container').mCustomScrollbar("scrollTo", "bottom");
	}
	else{
		var topValue = 246 - ((g_List_Count - 1) * 70);
		
		if(topValue > 0)
			topValue = 0;

		$('#scrollContainerInnerVertical').animate({'top': topValue + 'px'}, 500);
		
		var getHeight_dragrail = $('#scrollTool_1').height();
		var getHeight_visible  = $('#List_Container').height();
		var getHeight_total    = $('#scrollContainerInnerVertical').height();
		var getHeight_ratio    = getHeight_dragrail/getHeight_total;
		var newHeight          = Math.floor(getHeight_visible * getHeight_ratio);
		
		$('#Dragger_1').css({'height': newHeight + 'px'});
		$('#Dragger_1').children().css({'line-height': newHeight + 'px'});
		$('#Dragger_1').css({'top': Math.floor(topValue * getHeight_ratio * (-1)) + 'px '});
	}
}


function ScrollRefresh(){
	//if(otherPlatform){
		$('#List_Container').mCustomScrollbar("update");
		
		g_PageRefreshed = true;
	//}
}
//Scrolling End


function setHeaderMaxWidth(id1, id2){
	var pageNameWidth = $(".header_1st_div").width();
	var subDivWidth = (506 - pageNameWidth)/2;
	setCSS(id1, 'maxWidth', subDivWidth + 'px');
	setCSS(id2, 'maxWidth', subDivWidth + 'px');
}


function checkHTMLHeader(id){
	var pageNameWidth = $(".header_1st_div").width();
	var newWidth = 528 - pageNameWidth;
	
	setCSS(id, 'maxWidth', newWidth + 'px');
}
