#!/bin/bash -e

# globale Funktionen inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

is_logopt=false

bat_log "Launching service startup scripts"

# Führe erstmal ein Service "VOR"-Skript
script_before="$updt_dev/$WEATRONIC_FOLFER/service/wea_fs_service_before.sh"
if [ test -e "$updt_dev" ] && [[ "$updt_dev" != "" ]] && [ test -e "$script_before" ] ; then
	bash "$script_before"
fi

# Prüft, ob dies das erste Booten ist
mkdir -p "$INTERNAL_SD_TMPDIR"

if test -e "$ROOTFS_WRITTEN_FLAG_FILE" ; then
	bat_log "Last root-FS flash update failed."
else
	bat_log "Erasing rootfs flash..."
	flash_eraseall "$ROOTFS_FLASH_MTD"
	bat_log "Writing rootfs flash..."
	nandwrite -p "$ROOTFS_FLASH_MTD" "$SERVICE_FILES_PATH/rootfs-ro.ubi"
	bat_log "Creating rootfs flag file"
	echo "rootfs_writtten_flag=1" > "$ROOTFS_WRITTEN_FLAG_FILE"
	bat_log "Setting u-boot env var custom_boot_mode to try_normal"
	fw_setenv custom_boot_mode 'try_normal'
	
	sync
	sleep 0.5
	
	reboot
fi

# Führe zu Ende ein Service "NACH"-Skript
script_after="$updt_dev/$WEATRONIC_FOLFER/service/wea_fs_service_after.sh"
if [ test -e "$updt_dev" ] && [[ "$updt_dev" != "" ]] && [ test -e "$script_after" ] ; then
	bash "$script_after"
fi



exit 0

