#!/bin/sh -e 

#Diverse lokale Variablen werden deklariert
argc=1

# globale Funktionen und Defines inkludieren
. '/etc/bat60_scripts/scripts/includes/functions_global.sh'

is_logopt=true
is_update=false
tmp_dir="$TMP_DIR"

argc=2

#wenn Argumentanzahl nicht uebereinstimmt
if [ "$#" -lt $argc ] ; then
	echo "No file given to update with" 1>&2
	exit 1
fi

update_fname=$1
target=$2
reinvoke=false

if [ ! -z "$3" ] && [[ "$3" == "--reinvokeisp" ]]; then
	reinvoke=true
fi

retries=10
		
while [ $retries -gt 0 ] ; do
	update_target_global $LINDIS_TRX_UART $target $update_fname $reinvoke
	#wait $!
	update_result=$?
	bat_log "Return value is $update_result"
	
	if [ $update_result -eq 0 ] ; then
		break
	fi
	
	let retries=$retries-1
	bat_log "Target's $target update failed. $retries retries remain(s)"
done

if [ $retries -eq 0 ] ; then
	bat_log "All retries by update target $target failed"
	exit $update_result
fi

exit 0
